/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointType;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrWatchpointUtil {
    public static boolean canAddWatchpoint(XValue valueContainer2) {
        return valueContainer2 instanceof CidrPhysicalValue;
    }

    @Nullable
    public static XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> addWatchpoint(XValue valueContainer2, LLWatchpoint.AccessType accessType, LLWatchpoint.Lifetime lifetime) {
        if (!(valueContainer2 instanceof CidrPhysicalValue)) {
            return null;
        }
        CidrPhysicalValue value = (CidrPhysicalValue)valueContainer2;
        CidrDebugProcess process = value.getProcess();
        CidrWatchpointType.CidrWatchpointProperties properties = new CidrWatchpointType.CidrWatchpointProperties();
        properties.setDebugProcess(process);
        properties.setOriginalPosition(process.getSession().getCurrentPosition());
        properties.setAccessType(accessType);
        properties.setLLValue(value.getVar());
        properties.setExpr(value.getEvaluationExpression());
        properties.setLifetime(process.supportsWatchpointLifetime() ? lifetime : null);
        return CidrWatchpointUtil.addWatchpoint(process.getProject(), properties);
    }

    public static XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> addWatchpoint(@NotNull Project project, @Nullable CidrWatchpointType.CidrWatchpointProperties properties) {
        if (project == null) {
            CidrWatchpointUtil.$$$reportNull$$$0(0);
        }
        return XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)XBreakpointType.EXTENSION_POINT_NAME.findExtension(CidrWatchpointType.class), (XBreakpointProperties)properties);
    }

    public static void showWatchpointEditor(XValueNodeImpl node, XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint, Project project) {
        XDebuggerTree tree = node.getTree();
        Rectangle bounds = tree.getRowBounds(tree.getSelectionRows()[0]);
        DebuggerUIUtil.showXBreakpointEditorBalloon((Project)project, (Point)new Point((int)bounds.getCenterX(), (int)bounds.getCenterY()), (JComponent)tree, (boolean)false, breakpoint);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/execution/debugger/CidrWatchpointUtil", "addWatchpoint"));
    }
}

