/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012J>\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\r2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u001c\u001a\u00020\u000bJ\b\u0010\u001d\u001a\u00020\u000bH\u0002J\u0006\u0010\u001e\u001a\u00020\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrStackFrameVariables;", "", "debuggerDriverName", "", "(Ljava/lang/String;)V", "filterLocalVarsFinishMs", "Ljava/util/concurrent/atomic/AtomicLong;", "filterLocalVarsStartMs", "startTimeMs", "", "addAllTo", "", "values", "", "Lcom/intellij/xdebugger/frame/XNamedValue;", "toNode", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "last", "", "addLocalValues", "vars", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "frame", "Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;", "finishFilterLocalVariables", "reportTime", "startFilterLocalVariables", "intellij.cidr.debugger"})
@ApiStatus.Internal
public final class CidrStackFrameVariables {
    @NotNull
    private final String debuggerDriverName;
    private final long startTimeMs;
    @NotNull
    private final AtomicLong filterLocalVarsStartMs;
    @NotNull
    private final AtomicLong filterLocalVarsFinishMs;

    public CidrStackFrameVariables(@NotNull String debuggerDriverName) {
        Intrinsics.checkNotNullParameter((Object)debuggerDriverName, (String)"debuggerDriverName");
        this.debuggerDriverName = debuggerDriverName;
        this.startTimeMs = System.currentTimeMillis();
        this.filterLocalVarsStartMs = new AtomicLong(0L);
        this.filterLocalVarsFinishMs = new AtomicLong(0L);
    }

    public final void addLocalValues(@NotNull Collection<? extends LLValue> vars, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame, @NotNull XCompositeNode toNode2, boolean last) {
        Intrinsics.checkNotNullParameter(vars, (String)"vars");
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)((Object)frame), (String)"frame");
        Intrinsics.checkNotNullParameter((Object)toNode2, (String)"toNode");
        CidrValue.addLocalValues(vars, process, position, frame, toNode2, last);
        if (last) {
            this.reportTime();
        }
    }

    public final void addAllTo(@NotNull Collection<? extends XNamedValue> values, @NotNull XCompositeNode toNode2, boolean last) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)toNode2, (String)"toNode");
        CidrValue.addAllTo(values, toNode2, last);
        if (last) {
            this.reportTime();
        }
    }

    public static /* synthetic */ void addAllTo$default(CidrStackFrameVariables cidrStackFrameVariables, Collection collection, XCompositeNode xCompositeNode, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        cidrStackFrameVariables.addAllTo(collection, xCompositeNode, bl);
    }

    public final void startFilterLocalVariables() {
        this.filterLocalVarsStartMs.set(System.currentTimeMillis());
    }

    public final void finishFilterLocalVariables() {
        this.filterLocalVarsFinishMs.set(System.currentTimeMillis());
    }

    private final void reportTime() {
        long totalDurationMs = System.currentTimeMillis() - this.startTimeMs;
        long filterDurationMs = this.filterLocalVarsFinishMs.get() - this.filterLocalVarsStartMs.get();
        CidrDebuggerUsagesCollector.INSTANCE.logFrameVariablesComputed(this.debuggerDriverName, filterDurationMs, totalDurationMs);
        CidrDebuggerLog.LOG.debug("Frame variables filtering duration: " + filterDurationMs + "ms, total duration: " + totalDurationMs + "ms");
    }
}

