/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedRegisterValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrRegisterValue;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Promise;

public class CidrEvaluator
extends XDebuggerEvaluator {
    public static final Key THROW_ON_EVALUATION = Key.create((String)"THROW_ON_EVALUATION");
    @NotNull
    protected final CidrStackFrame myFrame;

    public CidrEvaluator(@NotNull CidrStackFrame frame) {
        if (frame == null) {
            CidrEvaluator.$$$reportNull$$$0(0);
        }
        this.myFrame = frame;
    }

    @NotNull
    public CidrEvaluatedValue doEvaluate(@NotNull DebuggerDriver driver, @Nullable XSourcePosition valuePosition, @NotNull XExpression expression) throws ExecutionException, DebuggerCommandException {
        String expr;
        LLValue val;
        if (driver == null) {
            CidrEvaluator.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            CidrEvaluator.$$$reportNull$$$0(2);
        }
        ThrowInTest.doThrow((UserDataHolder)this.myFrame.getProcess(), THROW_ON_EVALUATION);
        EvaluationContext context = this.createEvaluationContext(driver);
        LLValue registerValue = this.evaluateRegister(driver, expression);
        if (registerValue != null) {
            val = registerValue;
            expr = expression.getExpression();
        } else if (expression.getMode() == EvaluationMode.EXPRESSION) {
            Pair<LLValue, String> pair = CidrEvaluatorHelper.getInstance().convertAndEvaluate(this.myFrame.getProcess(), driver, expression, valuePosition, this.myFrame);
            val = (LLValue)((Object)pair.first);
            expr = (String)pair.second;
        } else {
            val = context.evaluate(expression.getExpression());
            expr = expression.getExpression();
        }
        if (((Boolean)CidrRegisterValue.IS_REGISTER_VALUE.get((UserDataHolder)val, (Object)false)).booleanValue()) {
            return new CidrEvaluatedRegisterValue(val, this.myFrame.getProcess(), this.myFrame, expr);
        }
        return new CidrEvaluatedValue(val, this.myFrame.getProcess(), valuePosition, this.myFrame, expr);
    }

    @Nullable
    private LLValue evaluateRegister(@NotNull DebuggerDriver driver, @NotNull XExpression expression) throws ExecutionException, DebuggerCommandException {
        if (driver == null) {
            CidrEvaluator.$$$reportNull$$$0(3);
        }
        if (expression == null) {
            CidrEvaluator.$$$reportNull$$$0(4);
        }
        if (Registry.is((String)"cidr.debugger.showRegisters") && driver.supportsRegisters()) {
            String expressionText = expression.getExpression();
            String registerName = driver.extractRegisterName(expressionText);
            if (registerName == null) {
                return null;
            }
            List<LLValue> registers = driver.getRegisters(this.myFrame.getThread(), this.myFrame.getFrame(), Set.of(registerName));
            for (LLValue register : registers) {
                if (!registerName.equals(register.getName())) continue;
                return register;
            }
        }
        return null;
    }

    public boolean isCodeFragmentEvaluationSupported() {
        return this.myFrame.getProcess().driverSupportsCodeFragmentEvaluation();
    }

    protected EvaluationContext createEvaluationContext(DebuggerDriver driver) {
        return this.myFrame.getProcess().createEvaluationContext(driver, null, this.myFrame);
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            CidrEvaluator.$$$reportNull$$$0(5);
        }
        if (callback == null) {
            CidrEvaluator.$$$reportNull$$$0(6);
        }
        this.evaluate((XExpression)XExpressionImpl.fromText((String)expression), callback, expressionPosition);
    }

    public void evaluate(final @NotNull XExpression expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, final @Nullable XSourcePosition expressionPosition) {
        if (expression == null) {
            CidrEvaluator.$$$reportNull$$$0(7);
        }
        if (callback == null) {
            CidrEvaluator.$$$reportNull$$$0(8);
        }
        this.myFrame.getProcess().postCommand(new CidrDebugProcess.DebuggerUIUpdateCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (driver == null) {
                    1.$$$reportNull$$$0(0);
                }
                XSourcePosition valuePosition = expressionPosition == null ? CidrEvaluator.this.myFrame.getSourcePosition() : expressionPosition;
                try {
                    CidrEvaluatedValue evaluatedValue = CidrEvaluator.this.doEvaluate(driver, valuePosition, expression);
                    callback.evaluated((XValue)evaluatedValue);
                }
                catch (DebuggerCommandException e) {
                    callback.errorOccurred(e.getMessage());
                }
                catch (ExecutionException e) {
                    callback.errorOccurred(CidrDebuggerUtil.getExceptionMessage((Exception)((Object)e)));
                    throw e;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "driver", "com/jetbrains/cidr/execution/debugger/CidrEvaluator$1", "run"));
            }
        });
    }

    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(@NotNull Project project, @NotNull Document document2, int offset, boolean sideEffectsAllowed) {
        if (project == null) {
            CidrEvaluator.$$$reportNull$$$0(9);
        }
        if (document2 == null) {
            CidrEvaluator.$$$reportNull$$$0(10);
        }
        CancellablePromise cancellablePromise = ReadAction.nonBlocking(() -> this.getExpressionInfoAtOffset(project, document2, offset, sideEffectsAllowed)).inSmartMode(project).withDocumentsCommitted(project).submit((Executor)AppExecutorUtil.getAppExecutorService());
        if (cancellablePromise == null) {
            CidrEvaluator.$$$reportNull$$$0(11);
        }
        return cancellablePromise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "driver";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/CidrEvaluator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/CidrEvaluator";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionInfoAtOffsetAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doEvaluate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "evaluateRegister";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionInfoAtOffsetAsync";
                break;
            }
            case 11: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

