/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ExceptionUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u001c\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J9\u0010\u000b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00040\r\"\u0004\u0018\u00010\u0004H\u0016\u00a2\u0006\u0002\u0010\u000eJ\u001c\u0010\u000f\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J,\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0016H\u0016J\u001c\u0010\u0019\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDevToolLogger;", "Lcom/intellij/openapi/diagnostic/Logger;", "()V", "buildMessage", "", "msg", "t", "", "debug", "", "message", "error", "details", "", "(Ljava/lang/String;Ljava/lang/Throwable;[Ljava/lang/String;)V", "info", "isDebugEnabled", "", "log", "time", "", "logLevel", "Lcom/intellij/openapi/diagnostic/LogLevel;", "setLevel", "level", "warn", "intellij.cidr.debugger"})
public class CidrDevToolLogger
extends Logger {
    public void log(long time, @NotNull LogLevel logLevel, @Nullable String message, @Nullable Throwable t) {
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
    }

    public void debug(@Nullable String message, @Nullable Throwable t) {
        this.log(System.currentTimeMillis(), LogLevel.DEBUG, message, t);
    }

    public void info(@Nullable String message, @Nullable Throwable t) {
        this.log(System.currentTimeMillis(), LogLevel.INFO, message, t);
    }

    public void warn(@Nullable String message, @Nullable Throwable t) {
        this.log(System.currentTimeMillis(), LogLevel.WARNING, message, t);
    }

    public void error(@Nullable String message, @Nullable Throwable t, String ... details) {
        Intrinsics.checkNotNullParameter((Object)details, (String)"details");
        this.log(System.currentTimeMillis(), LogLevel.ERROR, message, t);
    }

    @NotNull
    public final String buildMessage(@Nullable String msg, @Nullable Throwable t) {
        StringBuilder result2 = new StringBuilder();
        if (msg != null) {
            result2.append(msg);
        }
        if (t != null) {
            result2.append(ExceptionUtil.getMessage((Throwable)t));
            result2.append(ExceptionUtil.getThrowableText((Throwable)t));
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public void setLevel(@NotNull LogLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
    }

    public final boolean isDebugEnabled() {
        return false;
    }
}

