/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.diagnostic.LogLevel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.content.Content;
import com.jetbrains.cidr.execution.debugger.CidrDebugLogConsole;
import com.jetbrains.cidr.execution.debugger.CidrDebugSessionEventListener;
import com.jetbrains.cidr.execution.debugger.CidrDebugSessionEventType;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerDevToolWindowKt;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDevToolLogger;
import java.time.format.DateTimeFormatter;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugLogConsole;", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugSessionEventListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getLogger", "Lcom/jetbrains/cidr/execution/debugger/CidrDevToolLogger;", "printWithTimestamp", "", "time", "", "msg", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "sessionEvent", "eventType", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugSessionEventType;", "Companion", "intellij.cidr.debugger"})
public final class CidrDebugLogConsole
extends ConsoleViewImpl
implements CidrDebugSessionEventListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nls
    @NotNull
    public static final String CONTENT_ID = "Log";
    @NotNull
    private static final DateTimeFormatter LOG_TIME_FORMAT;

    public CidrDebugLogConsole(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, true);
    }

    private final void printWithTimestamp(long time, String msg, ConsoleViewContentType contentType) {
        String timestamp = CidrDebuggerDevToolWindowKt.access$formatTime(LOG_TIME_FORMAT, time);
        this.print("[" + timestamp + "] " + ((Object)StringsKt.trimEnd((CharSequence)msg)).toString() + "\n", contentType);
    }

    static /* synthetic */ void printWithTimestamp$default(CidrDebugLogConsole cidrDebugLogConsole, long l, String string, ConsoleViewContentType consoleViewContentType, int n, Object object) {
        if ((n & 4) != 0) {
            ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.NORMAL_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"NORMAL_OUTPUT");
            consoleViewContentType = consoleViewContentType2;
        }
        cidrDebugLogConsole.printWithTimestamp(l, string, consoleViewContentType);
    }

    @Override
    public void sessionEvent(long time, @NotNull CidrDebugSessionEventType eventType) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        if (eventType == CidrDebugSessionEventType.FIRST_SESSION_STARTED) {
            this.clear();
            long l = System.currentTimeMillis();
            String string = "CidrDebuggerLog.LOG.isDebugEnabled=" + CidrDebuggerLog.LOG.isDebugEnabled();
            ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
            Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"LOG_DEBUG_OUTPUT");
            this.printWithTimestamp(l, string, consoleViewContentType);
        }
        String string = eventType.toString();
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.LOG_DEBUG_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"LOG_DEBUG_OUTPUT");
        this.printWithTimestamp(time, string, consoleViewContentType);
    }

    @NotNull
    public final CidrDevToolLogger getLogger() {
        return new CidrDevToolLogger(this){
            final /* synthetic */ CidrDebugLogConsole this$0;
            {
                this.this$0 = $receiver;
            }

            public void log(long time, @NotNull LogLevel logLevel, @Nullable String message, @Nullable Throwable t) {
                Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
                ConsoleViewContentType contentType = switch (getLogger.WhenMappings.$EnumSwitchMapping$0[logLevel.ordinal()]) {
                    case 1, 2 -> ConsoleViewContentType.LOG_WARNING_OUTPUT;
                    default -> ConsoleViewContentType.NORMAL_OUTPUT;
                };
                String string = this.buildMessage(message, t);
                Intrinsics.checkNotNull((Object)contentType);
                CidrDebugLogConsole.access$printWithTimestamp(this.this$0, time, string, contentType);
            }
        };
    }

    public static final /* synthetic */ void access$printWithTimestamp(CidrDebugLogConsole $this, long time, String msg, ConsoleViewContentType contentType) {
        $this.printWithTimestamp(time, msg, contentType);
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        LOG_TIME_FORMAT = dateTimeFormatter;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugLogConsole$Companion;", "", "()V", "CONTENT_ID", "", "LOG_TIME_FORMAT", "Ljava/time/format/DateTimeFormatter;", "getLOG_TIME_FORMAT", "()Ljava/time/format/DateTimeFormatter;", "findConsole", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugLogConsole;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTimeFormatter getLOG_TIME_FORMAT() {
            return LOG_TIME_FORMAT;
        }

        @Nullable
        public final CidrDebugLogConsole findConsole(@NotNull Project project) {
            Content content;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindow toolWindow = ToolWindowManager.Companion.getInstance(project).getToolWindow("CidrDebuggerDevTool");
            ToolWindow toolWindow2 = toolWindow;
            Content content2 = content = toolWindow2 != null && (toolWindow2 = toolWindow2.getContentManager()) != null ? toolWindow2.findContent(CidrDebugLogConsole.CONTENT_ID) : null;
            JComponent jComponent = content2 != null ? content2.getComponent() : null;
            return jComponent instanceof CidrDebugLogConsole ? (CidrDebugLogConsole)((Object)jComponent) : null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

