/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.ide.ui.UISettings;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebugEventsTimelineContent;
import com.jetbrains.cidr.execution.debugger.CidrDebugSessionEventType;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerDevToolWindowKt;
import com.jetbrains.cidr.execution.debugger.CidrTimelineEvent;
import com.jetbrains.cidr.execution.debugger.TimelineModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.time.format.DateTimeFormatter;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimelineColumnHeader;", "Ljavax/swing/JComponent;", "model", "Lcom/jetbrains/cidr/execution/debugger/TimelineModel;", "(Lcom/jetbrains/cidr/execution/debugger/TimelineModel;)V", "getModel", "()Lcom/jetbrains/cidr/execution/debugger/TimelineModel;", "paintComponent", "", "graphics", "Ljava/awt/Graphics;", "Companion", "intellij.cidr.debugger"})
public final class CidrDebugEventsTimelineColumnHeader
extends JComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TimelineModel model;
    @NotNull
    private static final DateTimeFormatter TIME_FORMAT;
    @NotNull
    private static final Font FONT;

    public CidrDebugEventsTimelineColumnHeader(@NotNull TimelineModel model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        this.model = model;
        this.model.addUpdateListener((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.revalidate();
                this.repaint();
            }
        }));
    }

    @NotNull
    public final TimelineModel getModel() {
        return this.model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@Nullable Graphics graphics) {
        super.paintComponent(graphics);
        Graphics graphics2 = graphics;
        Graphics graphics3 = graphics2 != null ? graphics2.create() : null;
        if (graphics3 == null) {
            return;
        }
        Graphics g = graphics3;
        try {
            long firstDropTime;
            int seconds = this.model.getSecondsCount();
            if (seconds == 0) {
                return;
            }
            UISettings.Companion.setupAntialiasing(g);
            g.setFont(FONT);
            int marginY = 5;
            int tickHeight = 5;
            int labelOffset = 10;
            g.setColor((Color)JBColor.GRAY);
            g.drawLine(10, marginY, CidrDebugEventsTimelineContent.Companion.secondStartOffsetX(this.model, seconds), marginY);
            int s = 0;
            if (s <= seconds) {
                while (true) {
                    int secondStartOffset = CidrDebugEventsTimelineContent.Companion.secondStartOffsetX(this.model, s);
                    g.drawLine(secondStartOffset, marginY, secondStartOffset, marginY + tickHeight);
                    g.drawString(CidrDebuggerDevToolWindowKt.access$formatTime(TIME_FORMAT, CidrDebugEventsTimelineContent.Companion.secondStartTime(this.model, s)), secondStartOffset + 2, marginY + tickHeight + labelOffset);
                    if (s == seconds) break;
                    ++s;
                }
            }
            int runningRectHeight = 4;
            g.setColor((Color)JBColor.GREEN);
            long resumeStartTime = 0L;
            for (CidrTimelineEvent.DebugSessionEvent event : this.model.getDebugSessionEvents()) {
                if (event.getType() == CidrDebugSessionEventType.SESSION_RESUMED) {
                    resumeStartTime = event.getTime();
                }
                if (resumeStartTime == 0L || event.getType() != CidrDebugSessionEventType.SESSION_PAUSED && event.getType() != CidrDebugSessionEventType.SESSION_STOPPED) continue;
                int resumeStartX = CidrDebugEventsTimelineContent.Companion.millisStartOffsetX(this.model, resumeStartTime);
                int resumeFinishX = CidrDebugEventsTimelineContent.Companion.millisStartOffsetX(this.model, event.getTime());
                g.fillRect(resumeStartX, marginY - runningRectHeight, resumeFinishX - resumeStartX, runningRectHeight);
                resumeStartTime = 0L;
            }
            if (resumeStartTime != 0L) {
                int resumeStartX = CidrDebugEventsTimelineContent.Companion.millisStartOffsetX(this.model, resumeStartTime);
                int resumeFinishX = CidrDebugEventsTimelineContent.Companion.millisStartOffsetX(this.model, this.model.getMaxTime());
                g.fillRect(resumeStartX, marginY - runningRectHeight, resumeFinishX - resumeStartX, runningRectHeight);
            }
            if ((firstDropTime = this.model.getFirstDroppedEventTime().get()) != 0L) {
                g.setColor((Color)JBColor.RED);
                int firstDropX = CidrDebugEventsTimelineContent.Companion.millisStartOffsetX(this.model, firstDropTime);
                g.drawString("!", firstDropX, marginY + 10);
                long lastDropTime = this.model.getLastDroppedEventTime().get();
                if (lastDropTime != firstDropTime) {
                    int lastDropX = CidrDebugEventsTimelineContent.Companion.millisStartOffsetX(this.model, lastDropTime);
                    g.drawString("!", lastDropX, marginY + 10);
                    if (lastDropX - firstDropX > 10) {
                        g.drawLine(firstDropX + 5, marginY + 5, lastDropX, marginY + 5);
                    }
                }
            }
            int width = CidrDebugEventsTimelineContent.Companion.contentWidth(this.model);
            this.setPreferredSize(new Dimension(width, marginY + tickHeight + labelOffset + marginY));
        }
        finally {
            g.dispose();
        }
    }

    static {
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        Intrinsics.checkNotNullExpressionValue((Object)dateTimeFormatter, (String)"ofPattern(...)");
        TIME_FORMAT = dateTimeFormatter;
        Font font = UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getLabelFont(...)");
        FONT = font;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/CidrDebugEventsTimelineColumnHeader$Companion;", "", "()V", "FONT", "Ljava/awt/Font;", "Lorg/jetbrains/annotations/NotNull;", "TIME_FORMAT", "Ljava/time/format/DateTimeFormatter;", "getTIME_FORMAT", "()Ljava/time/format/DateTimeFormatter;", "intellij.cidr.debugger"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTimeFormatter getTIME_FORMAT() {
            return TIME_FORMAT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

