/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

public class ExecutionResult<T> {
    @NotNull
    private final CompletableFuture<T> myResult;

    public ExecutionResult() {
        this(new CompletableFuture());
    }

    private ExecutionResult(@NotNull CompletableFuture<T> result2) {
        if (result2 == null) {
            ExecutionResult.$$$reportNull$$$0(0);
        }
        this.myResult = result2;
    }

    public void set(@Nullable T result2) {
        if (!this.myResult.complete(result2)) {
            throw new IllegalStateException("Result is already set");
        }
    }

    public void setException(Throwable e) {
        if (!this.myResult.completeExceptionally(e)) {
            throw new IllegalStateException("Result is already set");
        }
    }

    public boolean isDone() {
        return this.myResult.isDone();
    }

    public T get() throws ExecutionException {
        return ExecutionResult.get(this.myResult);
    }

    public T get(long timeout, TimeUnit unit) throws ExecutionException, TimeoutException {
        return ExecutionResult.get(this.myResult, timeout, unit);
    }

    public static <T> T get(@NotNull Future<T> future) throws ExecutionException {
        if (future == null) {
            ExecutionResult.$$$reportNull$$$0(1);
        }
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            throw new ExecutionException(CidrDebuggerBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
        }
        catch (java.util.concurrent.ExecutionException e) {
            throw new ExecutionException(e.getMessage(), e.getCause());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T get(@NotNull Future<T> future, long timeout, TimeUnit timeUnit) throws ExecutionException, TimeoutException {
        if (future == null) {
            ExecutionResult.$$$reportNull$$$0(2);
        }
        try {
            void unit;
            return future.get(timeout, (TimeUnit)unit);
        }
        catch (InterruptedException e) {
            throw new ExecutionException(CidrDebuggerBundle.message("error.execution.interrupted", new Object[0]), (Throwable)e);
        }
        catch (java.util.concurrent.ExecutionException e) {
            throw new ExecutionException(e.getMessage(), e.getCause());
        }
    }

    @NotNull
    public CompletableFuture<T> asCompletableFuture() {
        CompletableFuture<T> completableFuture = this.myResult;
        if (completableFuture == null) {
            ExecutionResult.$$$reportNull$$$0(3);
        }
        return completableFuture;
    }

    @NotNull
    public static <T> ExecutionResult<T> fromCompletableFuture(@NotNull CompletableFuture<T> future) {
        if (future == null) {
            ExecutionResult.$$$reportNull$$$0(4);
        }
        return new ExecutionResult<T>(future);
    }

    @NotNull
    public static <T> ExecutionResult<T> fromPromise(@NotNull Promise<T> promise) {
        if (promise == null) {
            ExecutionResult.$$$reportNull$$$0(5);
        }
        ExecutionResult<T> result2 = new ExecutionResult<T>();
        promise.onSuccess(result2::set).onError(result2::setException);
        ExecutionResult<T> executionResult = result2;
        if (executionResult == null) {
            ExecutionResult.$$$reportNull$$$0(6);
        }
        return executionResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "future";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/ExecutionResult";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/ExecutionResult";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "asCompletableFuture";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "fromPromise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "fromCompletableFuture";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "fromPromise";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 6 -> new IllegalStateException(string);
        };
    }
}

