/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.cidr.ArchitectureType;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

public final class ExecutableFileFormatUtil {
    @NotNull
    public static ArchitectureType tryReadElfMachineType(@NlsSafe @NotNull String path) {
        if (path == null) {
            ExecutableFileFormatUtil.$$$reportNull$$$0(0);
        }
        try {
            return ExecutableFileFormatUtil.readElfMachineType(path);
        }
        catch (IOException e) {
            ArchitectureType architectureType = ArchitectureType.UNKNOWN;
            if (architectureType == null) {
                ExecutableFileFormatUtil.$$$reportNull$$$0(1);
            }
            return architectureType;
        }
    }

    @NotNull
    public static ArchitectureType tryReadPeMachineType(@NlsSafe @NotNull String path) {
        if (path == null) {
            ExecutableFileFormatUtil.$$$reportNull$$$0(2);
        }
        try {
            return ExecutableFileFormatUtil.readPeMachineType(path);
        }
        catch (IOException e) {
            ArchitectureType architectureType = ArchitectureType.UNKNOWN;
            if (architectureType == null) {
                ExecutableFileFormatUtil.$$$reportNull$$$0(3);
            }
            return architectureType;
        }
    }

    @NotNull
    public static ArchitectureType readElfMachineType(@NlsSafe @NotNull String path) throws IOException {
        if (path == null) {
            ExecutableFileFormatUtil.$$$reportNull$$$0(4);
        }
        return ExecutableFileFormatUtil.readElfMachineType(Paths.get(path, new String[0]));
    }

    @NotNull
    public static ArchitectureType readPeMachineType(@NlsSafe @NotNull String path) throws IOException {
        if (path == null) {
            ExecutableFileFormatUtil.$$$reportNull$$$0(5);
        }
        return ExecutableFileFormatUtil.readPeMachineType(Paths.get(path, new String[0]));
    }

    @NotNull
    public static ArchitectureType readElfMachineType(@NotNull Path file) throws IOException {
        if (file == null) {
            ExecutableFileFormatUtil.$$$reportNull$$$0(6);
        }
        if (!Files.isRegularFile(file, new LinkOption[0]) || !Files.isReadable(file)) {
            throw new IOException("Not a readable file");
        }
        long len = Files.size(file);
        if (len < 0L) {
            throw new IOException("File length reported negative");
        }
        SeekableByteChannel channel = Files.newByteChannel(file, new OpenOption[0]);
        int ELF_HEADER_LEN = 20;
        ByteBuffer elfHeader = ByteBuffer.allocate(20);
        if (channel.read(elfHeader) < 20) {
            throw new IOException("Not a valid ELF executable: ELF header is too short");
        }
        elfHeader.flip();
        if (elfHeader.getInt() != 2135247942) {
            throw new IOException("Not a valid ELF executable: missing ELF magic");
        }
        elfHeader.position(18);
        short elfMachineType = elfHeader.order(ByteOrder.LITTLE_ENDIAN).getShort();
        ArchitectureType architectureType = ArchitectureType.forElfMachineType((short)elfMachineType);
        ArchitectureType architectureType2 = architectureType;
        if (architectureType2 == null) {
            ExecutableFileFormatUtil.$$$reportNull$$$0(7);
        }
        return architectureType2;
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }

    @NotNull
    public static ArchitectureType readPeMachineType(@NotNull Path file) throws IOException {
        if (file == null) {
            ExecutableFileFormatUtil.$$$reportNull$$$0(8);
        }
        if (!Files.isRegularFile(file, new LinkOption[0]) || !Files.isReadable(file)) {
            throw new IOException("Not a readable file");
        }
        long len = Files.size(file);
        if (len < 0L) {
            throw new IOException("File length reported negative");
        }
        SeekableByteChannel channel = Files.newByteChannel(file, new OpenOption[0]);
        int DOS_HEADER_LEN = 64;
        ByteBuffer dosHeader = ByteBuffer.allocate(64);
        if (channel.read(dosHeader) < 64) {
            throw new IOException("Not a valid PE executable: DOS header is too short");
        }
        dosHeader.flip();
        if (dosHeader.getShort() != 19802) {
            throw new IOException("Not a valid PE executable: missing DOS magic");
        }
        dosHeader.position(60);
        int peOffset = dosHeader.order(ByteOrder.LITTLE_ENDIAN).getInt();
        channel.position(peOffset);
        int PE_HEADER_LEN = 6;
        ByteBuffer peHeader = ByteBuffer.allocate(6);
        if (channel.read(peHeader) < 6) {
            throw new IOException("Not a valid PE executable: PE header is too short");
        }
        peHeader.flip();
        if (peHeader.getInt() != 0x50450000) {
            throw new IOException("Not a valid PE executable: missing PE magic");
        }
        short peMachineType = peHeader.order(ByteOrder.LITTLE_ENDIAN).getShort();
        ArchitectureType architectureType = ArchitectureType.forPeMachineType((short)peMachineType);
        ArchitectureType architectureType2 = architectureType;
        if (architectureType2 == null) {
            ExecutableFileFormatUtil.$$$reportNull$$$0(9);
        }
        return architectureType2;
        finally {
            if (channel != null) {
                channel.close();
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 7, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/ExecutableFileFormatUtil";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/ExecutableFileFormatUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "tryReadElfMachineType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "tryReadPeMachineType";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "readElfMachineType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readPeMachineType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "tryReadElfMachineType";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 9: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tryReadPeMachineType";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "readElfMachineType";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readPeMachineType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3, 7, 9 -> new IllegalStateException(string);
        };
    }
}

