/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.vagrant;

import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.ssh.config.unified.SshConfig;
import com.jetbrains.plugins.remotesdk.VagrantCredentialsUtil;
import com.jetbrains.plugins.remotesdk.target.vagrant.VagrantEnvironmentConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u00a8\u0006\u0005"}, d2={"toRemoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "Lcom/jetbrains/plugins/remotesdk/target/vagrant/VagrantEnvironmentConfiguration;", "toSshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "intellij.remoteRun"})
public final class VagrantTargetsKt {
    @NotNull
    public static final RemoteCredentials toRemoteCredentials(@NotNull VagrantEnvironmentConfiguration $this$toRemoteCredentials) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toRemoteCredentials), (String)"<this>");
        String string = $this$toRemoteCredentials.getVagrantFolder();
        if (string == null) {
            throw new IllegalStateException("Vagrant folder must be specified");
        }
        String vagrantFolder = string;
        VagrantBasedCredentialsHolder credentials = new VagrantBasedCredentialsHolder(vagrantFolder, $this$toRemoteCredentials.getMachineName());
        RemoteCredentials remoteCredentials = VagrantCredentialsUtil.getAndCheckVagrantRemoteCredentials(credentials, true);
        Intrinsics.checkNotNullExpressionValue((Object)remoteCredentials, (String)"getAndCheckVagrantRemoteCredentials(...)");
        return remoteCredentials;
    }

    @NotNull
    public static final SshConfig toSshConfig(@NotNull VagrantEnvironmentConfiguration $this$toSshConfig) {
        SshConfig sshConfig;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$toSshConfig), (String)"<this>");
        RemoteCredentials remoteCredentials = VagrantTargetsKt.toRemoteCredentials($this$toSshConfig);
        SshConfig $this$toSshConfig_u24lambda_u240 = sshConfig = new SshConfig(true);
        boolean bl = false;
        $this$toSshConfig_u24lambda_u240.setUsername(remoteCredentials.getUserName());
        $this$toSshConfig_u24lambda_u240.setHost(remoteCredentials.getHost());
        $this$toSshConfig_u24lambda_u240.setPort(remoteCredentials.getPort());
        $this$toSshConfig_u24lambda_u240.setAuthType(remoteCredentials.getAuthType());
        $this$toSshConfig_u24lambda_u240.setKeyPath(remoteCredentials.getPrivateKeyFile());
        SshConfig.AuthData authData = SshConfig.AuthData.create((RemoteCredentials)remoteCredentials);
        Intrinsics.checkNotNullExpressionValue((Object)authData, (String)"create(...)");
        SshConfig.AuthData authData2 = authData;
        $this$toSshConfig_u24lambda_u240.saveAuthDataToPasswordSafe(authData2);
        return sshConfig;
    }
}

