/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.remotesdk.target.ssh.target.wizard;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.ssh.ConnectionBuilder;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 Y2\u00020\u0001:\u0004XYZ[B\u007f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\r\b\u0002\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\r\b\u0002\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\r\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u001fJ\u0016\u0010J\u001a\u00020H2\u0006\u0010K\u001a\u00020L2\u0006\u0010M\u001a\u00020NJ\b\u0010O\u001a\u00020HH\u0016J\u0018\u0010P\u001a\u00020H2\u0006\u0010M\u001a\u00020N2\u0006\u0010Q\u001a\u00020\u0012H\u0002J\u0006\u0010R\u001a\u00020SJ\b\u0010T\u001a\u00020\u0007H\u0007J\u0006\u0010U\u001a\u00020VJ\u0006\u0010W\u001a\u00020HR$\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u001d\u001a\u0015\u0012\f\u0012\n  *\u0004\u0018\u00010\u001f0\u001f0\u001e\u00a2\u0006\u0002\b!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001f\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R$\u0010.\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u0010\u000f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u0010+\"\u0004\b4\u0010-R\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010+\"\u0004\b6\u0010-R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010\u000e\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010+\"\u0004\b<\u0010-R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010>\"\u0004\bB\u0010@R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010>\"\u0004\bD\u0010@R\u001f\u0010\u000b\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bE\u0010+\"\u0004\bF\u0010-\u00a8\u0006\\"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/ConnectionData;", "Lcom/intellij/openapi/Disposable;", "useExistingConfig", "", "existingConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "host", "", "Lcom/intellij/openapi/util/NlsSafe;", "port", "", "username", "password", "savePassword", "privateKey", "passphrase", "savePassphrase", "openSshAgentConnectionStateParam", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/ConnectionData$OpenSshAgentConnectionState;", "(ZLcom/intellij/ssh/config/unified/SshConfig;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;ZLcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/ConnectionData$OpenSshAgentConnectionState;)V", "value", "Lcom/intellij/remote/AuthType;", "authType", "getAuthType", "()Lcom/intellij/remote/AuthType;", "setAuthType", "(Lcom/intellij/remote/AuthType;)V", "connectionThread", "Ljava/lang/Thread;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/ConnectionData$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getExistingConfig", "()Lcom/intellij/ssh/config/unified/SshConfig;", "setExistingConfig", "(Lcom/intellij/ssh/config/unified/SshConfig;)V", "failedAgentConnection", "Lcom/intellij/ui/layout/ComponentPredicate;", "getFailedAgentConnection$intellij_remoteRun", "()Lcom/intellij/ui/layout/ComponentPredicate;", "getHost", "()Ljava/lang/String;", "setHost", "(Ljava/lang/String;)V", "openSshAgentConnectionState", "getOpenSshAgentConnectionState", "()Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/ConnectionData$OpenSshAgentConnectionState;", "setOpenSshAgentConnectionState", "(Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/ConnectionData$OpenSshAgentConnectionState;)V", "getPassphrase", "setPassphrase", "getPassword", "setPassword", "getPort", "()I", "setPort", "(I)V", "getPrivateKey", "setPrivateKey", "getSavePassphrase", "()Z", "setSavePassphrase", "(Z)V", "getSavePassword", "setSavePassword", "getUseExistingConfig", "setUseExistingConfig", "getUsername", "setUsername", "addSshAgentConnectionListener", "", "listener", "checkAgentConnection", "project", "Lcom/intellij/openapi/project/Project;", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "dispose", "finalizeConnectionState", "state", "getResultingCredentials", "Lcom/intellij/remote/RemoteCredentials;", "getResultingCredentialsLine", "getResultingSshUiData", "Lcom/intellij/ssh/ui/unified/SshUiData;", "stopCheckingConnection", "AuthPredicate", "Companion", "Listener", "OpenSshAgentConnectionState", "intellij.remoteRun"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSshTargetWizardModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshTargetWizardModel.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/ConnectionData\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,298:1\n13#2:299\n*S KotlinDebug\n*F\n+ 1 SshTargetWizardModel.kt\ncom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/ConnectionData\n*L\n290#1:299\n*E\n"})
public final class ConnectionData
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean useExistingConfig;
    @Nullable
    private SshConfig existingConfig;
    @NotNull
    private String host;
    private int port;
    @NotNull
    private String username;
    @NotNull
    private String password;
    private boolean savePassword;
    @NotNull
    private String privateKey;
    @NotNull
    private String passphrase;
    private boolean savePassphrase;
    @NotNull
    private final EventDispatcher<Listener> eventDispatcher;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private OpenSshAgentConnectionState openSshAgentConnectionState;
    @NotNull
    private AuthType authType;
    @NotNull
    private static final Logger LOG;

    public ConnectionData(boolean useExistingConfig, @Nullable SshConfig existingConfig, @NotNull String host, int port, @NotNull String username, @NotNull String password, boolean savePassword, @NotNull String privateKey, @NotNull String passphrase, boolean savePassphrase, @NotNull OpenSshAgentConnectionState openSshAgentConnectionStateParam) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        Intrinsics.checkNotNullParameter((Object)((Object)openSshAgentConnectionStateParam), (String)"openSshAgentConnectionStateParam");
        this.useExistingConfig = useExistingConfig;
        this.existingConfig = existingConfig;
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.savePassword = savePassword;
        this.privateKey = privateKey;
        this.passphrase = passphrase;
        this.savePassphrase = savePassphrase;
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.openSshAgentConnectionState = openSshAgentConnectionStateParam;
        this.authType = AuthType.OPEN_SSH;
    }

    public /* synthetic */ ConnectionData(boolean bl, SshConfig sshConfig, String string, int n, String string2, String string3, boolean bl2, String string4, String string5, boolean bl3, OpenSshAgentConnectionState openSshAgentConnectionState, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            sshConfig = null;
        }
        if ((n2 & 4) != 0) {
            string = "";
        }
        if ((n2 & 8) != 0) {
            n = 22;
        }
        if ((n2 & 0x10) != 0) {
            string2 = "";
        }
        if ((n2 & 0x20) != 0) {
            string3 = "";
        }
        if ((n2 & 0x40) != 0) {
            bl2 = true;
        }
        if ((n2 & 0x80) != 0) {
            string4 = "";
        }
        if ((n2 & 0x100) != 0) {
            string5 = "";
        }
        if ((n2 & 0x200) != 0) {
            bl3 = true;
        }
        if ((n2 & 0x400) != 0) {
            openSshAgentConnectionState = OpenSshAgentConnectionState.NOT_STARTED;
        }
        this(bl, sshConfig, string, n, string2, string3, bl2, string4, string5, bl3, openSshAgentConnectionState);
    }

    public final boolean getUseExistingConfig() {
        return this.useExistingConfig;
    }

    public final void setUseExistingConfig(boolean bl) {
        this.useExistingConfig = bl;
    }

    @Nullable
    public final SshConfig getExistingConfig() {
        return this.existingConfig;
    }

    public final void setExistingConfig(@Nullable SshConfig sshConfig) {
        this.existingConfig = sshConfig;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    @NotNull
    public final String getUsername() {
        return this.username;
    }

    public final void setUsername(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.username = string;
    }

    @NotNull
    public final String getPassword() {
        return this.password;
    }

    public final void setPassword(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.password = string;
    }

    public final boolean getSavePassword() {
        return this.savePassword;
    }

    public final void setSavePassword(boolean bl) {
        this.savePassword = bl;
    }

    @NotNull
    public final String getPrivateKey() {
        return this.privateKey;
    }

    public final void setPrivateKey(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.privateKey = string;
    }

    @NotNull
    public final String getPassphrase() {
        return this.passphrase;
    }

    public final void setPassphrase(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.passphrase = string;
    }

    public final boolean getSavePassphrase() {
        return this.savePassphrase;
    }

    public final void setSavePassphrase(boolean bl) {
        this.savePassphrase = bl;
    }

    @NotNull
    public final OpenSshAgentConnectionState getOpenSshAgentConnectionState() {
        return this.openSshAgentConnectionState;
    }

    public final void setOpenSshAgentConnectionState(@NotNull OpenSshAgentConnectionState value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.openSshAgentConnectionState = value;
        ((Listener)this.eventDispatcher.getMulticaster()).sshAgentConnectionStateChanged();
    }

    @NotNull
    public final AuthType getAuthType() {
        return this.authType;
    }

    public final void setAuthType(@NotNull AuthType value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.authType = value;
        ((Listener)this.eventDispatcher.getMulticaster()).sshAgentConnectionStateChanged();
    }

    @NotNull
    public final ComponentPredicate getFailedAgentConnection$intellij_remoteRun() {
        return new AuthPredicate(this){

            public boolean isRadioSelected() {
                return true;
            }
        };
    }

    public final void addSshAgentConnectionListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener, (Disposable)this);
    }

    public final void checkAgentConnection(@NotNull Project project, @NotNull ModalityState modalityState) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        Thread thread = new Thread(() -> ConnectionData.checkAgentConnection$lambda$0(this, project, modalityState), "ConnectionData.checkConnection thread");
        thread.start();
        this.connectionThread = thread;
        this.setOpenSshAgentConnectionState(OpenSshAgentConnectionState.CONNECTING);
    }

    public final void stopCheckingConnection() {
        Thread thread = this.connectionThread;
        if (thread == null) {
            return;
        }
        this.connectionThread = null;
        this.setOpenSshAgentConnectionState(OpenSshAgentConnectionState.NOT_STARTED);
        try {
            thread.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private final void finalizeConnectionState(ModalityState modalityState, OpenSshAgentConnectionState state) {
        Thread currentThread = Thread.currentThread();
        ApplicationManager.getApplication().invokeLater(() -> ConnectionData.finalizeConnectionState$lambda$1(this, currentThread, state), modalityState);
    }

    public void dispose() {
    }

    @NotNull
    public final RemoteCredentials getResultingCredentials() {
        if (this.useExistingConfig) {
            SshConfig sshConfig = this.existingConfig;
            Intrinsics.checkNotNull((Object)sshConfig);
            return (RemoteCredentials)new SshUiData(sshConfig);
        }
        RemoteCredentialsHolder holder = new RemoteCredentialsHolder();
        holder.setHost(this.host);
        holder.setPort(this.port);
        holder.setUserName(this.username);
        holder.setAuthType(this.authType);
        holder.setPassword(this.password);
        holder.setPrivateKeyFile(this.privateKey);
        holder.setPassphrase(this.passphrase);
        return (RemoteCredentials)holder;
    }

    @NlsSafe
    @NotNull
    public final String getResultingCredentialsLine() {
        RemoteCredentials $this$getResultingCredentialsLine_u24lambda_u242 = this.getResultingCredentials();
        boolean bl = false;
        return $this$getResultingCredentialsLine_u24lambda_u242.getUserName() + "@" + $this$getResultingCredentialsLine_u24lambda_u242.getHost() + ":" + $this$getResultingCredentialsLine_u24lambda_u242.getPort();
    }

    @NotNull
    public final SshUiData getResultingSshUiData() {
        if (this.useExistingConfig) {
            SshConfig sshConfig = this.existingConfig;
            Intrinsics.checkNotNull((Object)sshConfig);
            return new SshUiData(sshConfig);
        }
        SshConfig config = new SshConfig(true);
        config.setHost(this.host);
        config.setPort(this.port);
        config.setUsername(this.username);
        config.setAuthType(this.authType);
        config.setKeyPath(this.privateKey);
        SshConfig.AuthData authData = new SshConfig.AuthData();
        authData.setPassword(this.password);
        authData.setPassphrase(this.passphrase);
        authData.setSavePassword(this.savePassword);
        authData.setSavePassphrase(this.savePassphrase);
        return new SshUiData(config, authData);
    }

    private static final void checkAgentConnection$lambda$0(ConnectionData this$0, Project $project, ModalityState $modalityState) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$modalityState, (String)"$modalityState");
        RemoteCredentialsHolder credentialsHolder = new RemoteCredentialsHolder();
        credentialsHolder.setHost(this$0.host);
        credentialsHolder.setPort(this$0.port);
        credentialsHolder.setUserName(this$0.username);
        credentialsHolder.setAuthType(AuthType.OPEN_SSH);
        try {
            if (ConnectionBuilder.checkCanAuthenticate$default((ConnectionBuilder)RemoteCredentialsUtil.connectionBuilder$default((RemoteCredentials)((RemoteCredentials)credentialsHolder), (Project)$project, null, (boolean)false, null, (int)10, null), (boolean)false, (int)1, null)) {
                this$0.finalizeConnectionState($modalityState, OpenSshAgentConnectionState.SUCCESS);
            } else {
                this$0.finalizeConnectionState($modalityState, OpenSshAgentConnectionState.FAILED);
            }
        }
        catch (Exception e) {
            LOG.info("Got error in checkConnection", (Throwable)e);
            this$0.finalizeConnectionState($modalityState, OpenSshAgentConnectionState.FAILED);
        }
    }

    private static final void finalizeConnectionState$lambda$1(ConnectionData this$0, Thread $currentThread, OpenSshAgentConnectionState $state) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$state), (String)"$state");
        if (Intrinsics.areEqual((Object)this$0.connectionThread, (Object)$currentThread)) {
            this$0.setOpenSshAgentConnectionState($state);
            if ($state == OpenSshAgentConnectionState.FAILED && this$0.authType == AuthType.OPEN_SSH) {
                this$0.setAuthType(AuthType.PASSWORD);
            }
            this$0.connectionThread = null;
        }
    }

    public ConnectionData() {
        this(false, null, null, 0, null, null, false, null, null, false, null, 2047, null);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ConnectionData.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00a2\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006H\u0016J\u000e\u0010\b\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u0007H&\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/ConnectionData$AuthPredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "(Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/ConnectionData;)V", "addListener", "", "listener", "Lkotlin/Function1;", "", "invoke", "()Ljava/lang/Boolean;", "isRadioSelected", "intellij.remoteRun"})
    private abstract class AuthPredicate
    extends ComponentPredicate {
        @NotNull
        public Boolean invoke() {
            return ConnectionData.this.getOpenSshAgentConnectionState() == OpenSshAgentConnectionState.FAILED && this.isRadioSelected();
        }

        public abstract boolean isRadioSelected();

        public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            ConnectionData.this.eventDispatcher.addListener((EventListener)new Listener(listener, this){
                final /* synthetic */ Function1<Boolean, Unit> $listener;
                final /* synthetic */ AuthPredicate this$0;
                {
                    this.$listener = $listener;
                    this.this$0 = $receiver;
                }

                public void sshAgentConnectionStateChanged() {
                    this.$listener.invoke((Object)this.this$0.invoke());
                }
            }, (Disposable)ConnectionData.this);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/ConnectionData$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.remoteRun"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/ConnectionData$Listener;", "Ljava/util/EventListener;", "sshAgentConnectionStateChanged", "", "intellij.remoteRun"})
    public static interface Listener
    extends EventListener {
        public void sshAgentConnectionStateChanged();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/plugins/remotesdk/target/ssh/target/wizard/ConnectionData$OpenSshAgentConnectionState;", "", "(Ljava/lang/String;I)V", "NOT_STARTED", "CONNECTING", "FAILED", "SUCCESS", "intellij.remoteRun"})
    public static final class OpenSshAgentConnectionState
    extends Enum<OpenSshAgentConnectionState> {
        public static final /* enum */ OpenSshAgentConnectionState NOT_STARTED = new OpenSshAgentConnectionState();
        public static final /* enum */ OpenSshAgentConnectionState CONNECTING = new OpenSshAgentConnectionState();
        public static final /* enum */ OpenSshAgentConnectionState FAILED = new OpenSshAgentConnectionState();
        public static final /* enum */ OpenSshAgentConnectionState SUCCESS = new OpenSshAgentConnectionState();
        private static final /* synthetic */ OpenSshAgentConnectionState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OpenSshAgentConnectionState[] values() {
            return (OpenSshAgentConnectionState[])$VALUES.clone();
        }

        public static OpenSshAgentConnectionState valueOf(String value) {
            return Enum.valueOf(OpenSshAgentConnectionState.class, value);
        }

        @NotNull
        public static EnumEntries<OpenSshAgentConnectionState> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = openSshAgentConnectionStateArray = new OpenSshAgentConnectionState[]{OpenSshAgentConnectionState.NOT_STARTED, OpenSshAgentConnectionState.CONNECTING, OpenSshAgentConnectionState.FAILED, OpenSshAgentConnectionState.SUCCESS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

