/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.smart;

import com.intellij.codeInsight.editorActions.CopyPastePreProcessor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RawText;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLElementGenerator;
import org.jetbrains.yaml.YAMLElementType;
import org.jetbrains.yaml.YAMLElementTypes;
import org.jetbrains.yaml.YAMLLanguage;
import org.jetbrains.yaml.YAMLTextUtil;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockSequenceImpl;
import org.jetbrains.yaml.refactoring.rename.YamlKeyValueRenameInputValidator;
import org.jetbrains.yaml.smart.YAMLEditorOptions;

public class YAMLCopyPasteProcessor
implements CopyPastePreProcessor {
    private static final String CONFIG_KEY_SEQUENCE_PATTERN = "\\.*([^\\s{}\\[\\].][^\\s.]*\\.)+[^\\s{}\\[\\].][^\\s.]*:?\\s*";

    @Nullable
    public String preprocessOnCopy(PsiFile file, int[] startOffsets, int[] endOffsets, String text) {
        boolean inTheStartOfSubElement;
        if (startOffsets.length != 1 || endOffsets.length != 1) {
            return null;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        int caretOffset = startOffsets[0];
        PsiElement element = file.findElementAt(caretOffset);
        if (element == null) {
            return null;
        }
        PsiElement prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)element, (boolean)true);
        if (prevLeaf instanceof PsiWhiteSpace) {
            prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)prevLeaf, (boolean)true);
        }
        if (element instanceof PsiWhiteSpace && (element = PsiTreeUtil.nextLeaf((PsiElement)element, (boolean)true)) == null) {
            return null;
        }
        boolean bl = inTheStartOfSubElement = YAMLCopyPasteProcessor.isYamlElementType(element) && PsiUtilCore.getElementType((PsiElement)element) == YAMLTokenTypes.INDENT || element.getTextRange().getStartOffset() == caretOffset && YAMLCopyPasteProcessor.isYamlElementType(prevLeaf) && PsiUtilCore.getElementType((PsiElement)prevLeaf) == YAMLTokenTypes.INDENT || element.getTextRange().getStartOffset() >= caretOffset && YAMLCopyPasteProcessor.isYamlElementType(prevLeaf) && PsiUtilCore.getElementType((PsiElement)prevLeaf) == YAMLTokenTypes.SEQUENCE_MARKER;
        if (!inTheStartOfSubElement) {
            return null;
        }
        int lineStartOffset = DocumentUtil.getLineStartOffset((int)caretOffset, (Document)document);
        if (lineStartOffset == caretOffset) {
            return null;
        }
        PsiElement borderParent = PsiTreeUtil.findFirstParent((PsiElement)PsiTreeUtil.nextLeaf((PsiElement)element, (boolean)false), (boolean)true, psi -> psi instanceof YAMLBlockSequenceImpl || psi instanceof YAMLBlockMappingImpl);
        if (borderParent == null) {
            return null;
        }
        int endOffset = endOffsets[0];
        PsiElement endElement = file.findElementAt(endOffset - 1);
        if (endElement != null && YAMLUtil.psiAreAtTheSameLine((PsiElement)element, (PsiElement)endElement)) {
            return null;
        }
        if (borderParent.getTextRange().getEndOffset() < endOffset) {
            PsiElement nextElement = borderParent;
            while ((nextElement = PsiTreeUtil.nextLeaf((PsiElement)nextElement, (boolean)true)) != null && nextElement.getTextRange().getStartOffset() < endOffset) {
                IElementType elementType = PsiUtilCore.getElementType((PsiElement)nextElement);
                if (!(elementType instanceof YAMLElementType)) {
                    return null;
                }
                if (YAMLElementTypes.BLANK_ELEMENTS.contains(elementType)) continue;
                return null;
            }
        }
        return StringUtil.repeatSymbol((char)' ', (int)(caretOffset - lineStartOffset)) + text;
    }

    private static boolean isYamlElementType(PsiElement element) {
        return PsiUtilCore.getElementType((PsiElement)element) instanceof YAMLElementType;
    }

    @NotNull
    public String preprocessOnPaste(Project project, PsiFile file, Editor editor, String text, RawText rawText) {
        String specialKeyPaste;
        int caretOffset;
        if (!file.getViewProvider().hasLanguage((Language)YAMLLanguage.INSTANCE)) {
            String string = text;
            if (string == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(0);
            }
            return string;
        }
        CaretModel caretModel = editor.getCaretModel();
        SelectionModel selectionModel = editor.getSelectionModel();
        int n = caretOffset = selectionModel.getSelectionStart() != selectionModel.getSelectionEnd() ? selectionModel.getSelectionStart() : caretModel.getOffset();
        if (YAMLCopyPasteProcessor.isCommentElement(file.findElementAt(caretOffset))) {
            String string = text;
            if (string == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(1);
            }
            return string;
        }
        Document document = editor.getDocument();
        int lineNumber = document.getLineNumber(caretOffset);
        int lineStartOffset = YAMLTextUtil.getLineStartSafeOffset((Document)document, (int)lineNumber);
        int indent = caretOffset - lineStartOffset;
        boolean smartPaste = YAMLEditorOptions.getInstance().isUseSmartPaste();
        String string = specialKeyPaste = smartPaste ? YAMLCopyPasteProcessor.tryToPasteAsKeySequence(text, file, editor, caretOffset, indent) : null;
        if (specialKeyPaste != null) {
            String string2 = specialKeyPaste;
            if (string2 == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(2);
            }
            return string2;
        }
        if (indent == 0) {
            String string3 = text;
            if (string3 == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(3);
            }
            return string3;
        }
        LineAdjustmentMode adjustmentMode = YAMLCopyPasteProcessor.adjustmentAfterInsertion(file, caretOffset);
        if (adjustmentMode == LineAdjustmentMode.None) {
            String string4 = text;
            if (string4 == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(4);
            }
            return string4;
        }
        if (adjustmentMode == LineAdjustmentMode.Indent) {
            return YAMLCopyPasteProcessor.indentText(text, StringUtil.repeatSymbol((char)' ', (int)indent), YAMLCopyPasteProcessor.shouldInsertIndentAtTheEnd(caretOffset, document));
        }
        List lines = LineTokenizer.tokenizeIntoList((CharSequence)text, (boolean)false, (boolean)false);
        if (lines.isEmpty()) {
            String string5 = text;
            if (string5 == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(5);
            }
            return string5;
        }
        String firstLine = (String)lines.get(0);
        if (firstLine.trim().endsWith(":")) {
            return YAMLCopyPasteProcessor.indentText(text, StringUtil.repeatSymbol((char)' ', (int)indent), YAMLCopyPasteProcessor.shouldInsertIndentAtTheEnd(caretOffset, document));
        }
        String string6 = YAMLCopyPasteProcessor.adjustListItems(lines, indent + YAMLCopyPasteProcessor.fixOffset(document, caretOffset));
        if (string6 == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(6);
        }
        return string6;
    }

    private static int fixOffset(Document document, int caretOffset) {
        CharSequence sequence = document.getCharsSequence();
        int offset = 0;
        while (sequence.charAt(caretOffset - 1 + offset) != '-') {
            --offset;
        }
        return offset - 1;
    }

    private static String adjustListItems(List<String> lines, int indent) {
        String firstLine = lines.get(0).substring(YAMLTextUtil.getStartIndentSize((CharSequence)lines.get(0)));
        String firstLineAdjusted = ContainerUtil.and(lines, s -> s.trim().startsWith("-")) ? StringUtil.trimLeading((String)StringUtil.trimStart((String)firstLine, (String)"-")) : firstLine;
        return firstLineAdjusted + "\n" + lines.stream().skip(1L).map(line -> {
            if (YAMLCopyPasteProcessor.isEmptyLine(line)) {
                return "";
            }
            if (line.trim().startsWith("-")) {
                return StringUtil.repeatSymbol((char)' ', (int)indent) + StringUtil.trimLeading((String)line);
            }
            return StringUtil.repeatSymbol((char)' ', (int)indent) + "- " + StringUtil.trimLeading((String)line);
        }).reduce((left, right) -> left + "\n" + right).orElse("");
    }

    private static boolean isCommentElement(@Nullable PsiElement element) {
        return element != null && YAMLCopyPasteProcessor.isCommentNode(element.getNode());
    }

    private static boolean isCommentNode(@Nullable ASTNode node) {
        return node != null && YAMLTokenTypes.COMMENT == PsiUtilCore.getElementType((ASTNode)(node.getElementType() == YAMLTokenTypes.EOL ? node.getTreePrev() : node));
    }

    private static boolean shouldInsertIndentAtTheEnd(int caretOffset, Document document) {
        for (int i = caretOffset; i < document.getTextLength(); ++i) {
            char c = document.getCharsSequence().charAt(i);
            if (c == '\n') {
                return false;
            }
            if (Character.isWhitespace(c)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static LineAdjustmentMode adjustmentAfterInsertion(PsiFile file, int caretOffset) {
        PsiElement previousElement;
        PsiElement element = file.findElementAt(caretOffset);
        if (element != null) {
            if (PsiUtilCore.getElementType((PsiElement)element) == YAMLTokenTypes.SCALAR_LIST || PsiUtilCore.getElementType((PsiElement)element.getParent()) == YAMLElementTypes.SCALAR_LIST_VALUE) {
                return LineAdjustmentMode.None;
            }
            TokenSet ends = TokenSet.create((IElementType[])new IElementType[]{YAMLTokenTypes.EOL, YAMLTokenTypes.SCALAR_EOL, YAMLTokenTypes.COMMENT});
            IElementType nextType = PsiUtilCore.getElementType((PsiElement)element.getNextSibling());
            if (PsiUtilCore.getElementType((PsiElement)element) == YAMLTokenTypes.INDENT && (nextType == null || ends.contains(nextType))) {
                return LineAdjustmentMode.Indent;
            }
        }
        if (element == null) {
            if (caretOffset <= 0) return LineAdjustmentMode.Indent;
            previousElement = file.findElementAt(caretOffset - 1);
        } else {
            previousElement = PsiTreeUtil.prevLeaf((PsiElement)element, (boolean)true);
        }
        if (PsiUtilCore.getElementType((PsiElement)previousElement) == TokenType.WHITE_SPACE) {
            previousElement = PsiTreeUtil.prevLeaf((PsiElement)previousElement, (boolean)true);
        }
        if (PsiUtilCore.getElementType((PsiElement)previousElement) == YAMLTokenTypes.INDENT || PsiUtilCore.getElementType((PsiElement)previousElement) == YAMLTokenTypes.EOL) {
            return LineAdjustmentMode.Indent;
        }
        if (PsiUtilCore.getElementType((PsiElement)previousElement) != YAMLTokenTypes.SEQUENCE_MARKER && (PsiUtilCore.getElementType((PsiElement)previousElement) != YAMLTokenTypes.TEXT || !previousElement.textMatches((CharSequence)"-"))) return LineAdjustmentMode.None;
        return LineAdjustmentMode.ListItem;
    }

    @NotNull
    private static String indentText(@NotNull String text, @NotNull String curLineIndent, boolean shouldInsertIndentInTheEnd) {
        List lines;
        if (text == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(7);
        }
        if (curLineIndent == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(8);
        }
        if ((lines = LineTokenizer.tokenizeIntoList((CharSequence)text, (boolean)false, (boolean)false)).isEmpty()) {
            String string = text;
            if (string == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(9);
            }
            return string;
        }
        int minIndent = YAMLCopyPasteProcessor.calculateMinBlockIndent(lines);
        String firstLine = (String)lines.iterator().next();
        if (lines.size() == 1) {
            String string = firstLine;
            if (string == null) {
                YAMLCopyPasteProcessor.$$$reportNull$$$0(10);
            }
            return string;
        }
        String suffixIndent = shouldInsertIndentInTheEnd && YAMLCopyPasteProcessor.isEmptyLine((String)lines.get(lines.size() - 1)) ? curLineIndent : "";
        String string = firstLine.substring(YAMLTextUtil.getStartIndentSize((CharSequence)firstLine)) + "\n" + lines.stream().skip(1L).map(line -> {
            if (!YAMLCopyPasteProcessor.isEmptyLine(line)) {
                return curLineIndent + line.substring(minIndent);
            }
            return "";
        }).reduce((left, right) -> left + "\n" + right).orElse("") + suffixIndent;
        if (string == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(11);
        }
        return string;
    }

    private static int calculateMinBlockIndent(@NotNull List<String> list) {
        if (list == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(12);
        }
        Iterator<String> it = list.iterator();
        String str = "";
        while (it.hasNext() && YAMLCopyPasteProcessor.isEmptyLine(str = it.next())) {
        }
        if (!it.hasNext()) {
            return 0;
        }
        int minIndent = YAMLTextUtil.getStartIndentSize((CharSequence)str);
        while (it.hasNext()) {
            str = it.next();
            if (YAMLCopyPasteProcessor.isEmptyLine(str)) continue;
            minIndent = Math.min(minIndent, YAMLTextUtil.getStartIndentSize((CharSequence)str));
        }
        return minIndent;
    }

    private static boolean isEmptyLine(@NotNull String str) {
        if (str == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(13);
        }
        return YAMLTextUtil.getStartIndentSize((CharSequence)str) == str.length();
    }

    @Nullable
    private static String tryToPasteAsKeySequence(@NotNull String text, @NotNull PsiFile file, @NotNull Editor editor, int caretOffset, int indent) {
        String result;
        if (text == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(14);
        }
        if (file == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(15);
        }
        if (editor == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(16);
        }
        if (!text.matches(CONFIG_KEY_SEQUENCE_PATTERN)) {
            return null;
        }
        List<String> keys = YAMLCopyPasteProcessor.separateCompositeKey(text);
        assert (!keys.isEmpty());
        for (String key : keys) {
            if (YamlKeyValueRenameInputValidator.IDENTIFIER_PATTERN.matcher(key).matches()) continue;
            return null;
        }
        PsiElement element = file.findElementAt(caretOffset);
        if (element != null && (result = YAMLCopyPasteProcessor.tryToPasteAsKeySequenceAtMapping(editor, keys, element, caretOffset, indent)) != null) {
            return result;
        }
        if ((element == null || element.getTextRange().getStartOffset() == caretOffset) && caretOffset > 0 && (element = file.findElementAt(caretOffset - 1)) != null) {
            int parentIndent;
            result = YAMLCopyPasteProcessor.tryToPasteAsKeySequenceAtMapping(editor, keys, element, caretOffset, indent);
            if (result != null) {
                return result;
            }
            YAMLKeyValue keyValue = YAMLCopyPasteProcessor.getPreviousKeyValuePairBeforeEOL(element);
            if (keyValue != null && keyValue.getValue() == null && indent > (parentIndent = YAMLUtil.getIndentToThisElement((PsiElement)keyValue))) {
                return YAMLElementGenerator.createChainedKey(keys, (int)indent);
            }
        }
        return null;
    }

    @Nullable
    private static YAMLKeyValue getPreviousKeyValuePairBeforeEOL(@NotNull PsiElement element) {
        PsiElement cur;
        if (element == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(17);
        }
        if (PsiUtilCore.getElementType((PsiElement)element.getParent()) != YAMLElementTypes.MAPPING) {
            return null;
        }
        boolean eolMet = false;
        for (cur = element; cur != null && YAMLElementTypes.BLANK_ELEMENTS.contains(PsiUtilCore.getElementType((PsiElement)cur)); cur = cur.getPrevSibling()) {
            if (PsiUtilCore.getElementType((PsiElement)cur) != YAMLTokenTypes.EOL) continue;
            eolMet = true;
        }
        if (eolMet && PsiUtilCore.getElementType((PsiElement)cur) == YAMLElementTypes.KEY_VALUE_PAIR) {
            return (YAMLKeyValue)cur;
        }
        return null;
    }

    @Nullable
    private static String tryToPasteAsKeySequenceAtMapping(@NotNull Editor editor, @NotNull List<String> keys, @NotNull PsiElement element, int caretOffset, int indent) {
        if (editor == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(18);
        }
        if (keys == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(19);
        }
        if (element == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(20);
        }
        while (true) {
            YAMLKeyValue keyValue;
            YAMLBlockMappingImpl blockMapping;
            if (element.getParent() instanceof YAMLFile) {
                PsiElement prev = element.getPrevSibling();
                if (!(prev instanceof YAMLDocument)) {
                    return null;
                }
                element = ((YAMLDocument)prev).getTopLevelValue();
                if (!(element instanceof YAMLBlockMappingImpl)) {
                    return null;
                }
                blockMapping = (YAMLBlockMappingImpl)element;
            } else {
                blockMapping = (YAMLBlockMappingImpl)PsiTreeUtil.getParentOfType((PsiElement)element, YAMLBlockMappingImpl.class);
            }
            if (blockMapping == null) {
                return null;
            }
            int mappingIndent = YAMLUtil.getIndentToThisElement((PsiElement)blockMapping);
            if (mappingIndent == indent && (keyValue = (YAMLKeyValue)ApplicationManager.getApplication().runWriteAction(() -> {
                YAMLKeyValue lastKeyVal = blockMapping.getOrCreateKeySequence(keys, caretOffset);
                if (lastKeyVal == null) {
                    return null;
                }
                ASTNode colon = lastKeyVal.getNode().findChildByType((IElementType)YAMLTokenTypes.COLON);
                if (colon != null) {
                    int newOffset = colon.getTextRange().getEndOffset();
                    editor.getCaretModel().moveToOffset(newOffset);
                }
                return lastKeyVal;
            })) != null) {
                return "";
            }
            element = blockMapping;
        }
    }

    @NotNull
    private static List<String> separateCompositeKey(@NotNull String text) {
        if (text == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(21);
        }
        text = text.trim();
        text = StringUtil.trimEnd((String)text, (char)':');
        int leadingDotsNumber = StringUtil.countChars((CharSequence)text, (char)'.', (int)0, (boolean)true);
        String dotPrefix = text.substring(0, leadingDotsNumber);
        text = text.substring(leadingDotsNumber);
        ArrayList<String> sequence = new ArrayList<String>(StringUtil.split((String)text, (String)"."));
        if (!dotPrefix.isEmpty() && sequence.size() > 0) {
            sequence.set(0, dotPrefix + (String)sequence.get(0));
        }
        ArrayList<String> arrayList = sequence;
        if (arrayList == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    public boolean requiresAllDocumentsToBeCommitted(@NotNull Editor editor, @NotNull Project project) {
        if (editor == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(23);
        }
        if (project == null) {
            YAMLCopyPasteProcessor.$$$reportNull$$$0(24);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 7, 8, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/smart/YAMLCopyPasteProcessor";
                break;
            }
            case 7: 
            case 14: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curLineIndent";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "preprocessOnPaste";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/smart/YAMLCopyPasteProcessor";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "indentText";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "separateCompositeKey";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "indentText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calculateMinBlockIndent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isEmptyLine";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "tryToPasteAsKeySequence";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousKeyValuePairBeforeEOL";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tryToPasteAsKeySequenceAtMapping";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "separateCompositeKey";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "requiresAllDocumentsToBeCommitted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 7, 8, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 23, 24 -> new IllegalArgumentException(string);
        };
    }

    private static enum LineAdjustmentMode {
        None,
        Indent,
        ListItem;

    }
}

