/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.ProcessingContext;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public final class YamlKeyValueRenameInputValidator
implements RenameInputValidatorEx {
    private static final String IDENTIFIER_START_PATTERN = "(([^\\n\\t\\r \\-?:,\\[\\]{}#&*!|>'\"%@`])|([?:-][^\\n\\t\\r ]))";
    private static final String IDENTIFIER_END_PATTERN = "(([^\\n\\t\\r ]#)|([^\\n\\t\\r :#])|(:[^\\n\\t\\r ]))";
    public static final Pattern IDENTIFIER_PATTERN = Pattern.compile("((([^\\n\\t\\r \\-?:,\\[\\]{}#&*!|>'\"%@`])|([?:-][^\\n\\t\\r ]))([ \t]*(([^\\n\\t\\r ]#)|([^\\n\\t\\r :#])|(:[^\\n\\t\\r ])))*)|('[^\\n']*')|(\"[^\\n\"]*\")");

    @Nullable
    public String getErrorMessage(@NotNull String newName, @NotNull Project project) {
        if (newName == null) {
            YamlKeyValueRenameInputValidator.$$$reportNull$$$0(0);
        }
        if (project == null) {
            YamlKeyValueRenameInputValidator.$$$reportNull$$$0(1);
        }
        return IDENTIFIER_PATTERN.matcher(newName).matches() ? null : YAMLBundle.message((String)"rename.invalid.name", (Object[])new Object[]{newName});
    }

    @NotNull
    public ElementPattern<? extends PsiElement> getPattern() {
        PsiElementPattern.Capture capture = PlatformPatterns.psiElement(YAMLKeyValue.class);
        if (capture == null) {
            YamlKeyValueRenameInputValidator.$$$reportNull$$$0(2);
        }
        return capture;
    }

    public boolean isInputValid(@NotNull String newName, @NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (newName == null) {
            YamlKeyValueRenameInputValidator.$$$reportNull$$$0(3);
        }
        if (element == null) {
            YamlKeyValueRenameInputValidator.$$$reportNull$$$0(4);
        }
        if (context == null) {
            YamlKeyValueRenameInputValidator.$$$reportNull$$$0(5);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/yaml/refactoring/rename/YamlKeyValueRenameInputValidator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/yaml/refactoring/rename/YamlKeyValueRenameInputValidator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInputValid";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

