/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLBundle;
import org.jetbrains.yaml.inspections.YAMLAddQuoteQuickFix;
import org.jetbrains.yaml.inspections.YAMLAddQuotesToSiblingsQuickFix;
import org.jetbrains.yaml.inspections.YAMLIncompatibleTypesInspectionKt;
import org.jetbrains.yaml.inspections.YamlIncompatibleTypesVisitor;
import org.jetbrains.yaml.inspections.YamlIncompatibleTypesVisitor$visitScalar$;
import org.jetbrains.yaml.meta.model.YamlMetaType;
import org.jetbrains.yaml.meta.model.YamlStringType;
import org.jetbrains.yaml.psi.YAMLPsiElement;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.YAMLValue;
import org.jetbrains.yaml.psi.YamlPsiElementVisitor;
import org.jetbrains.yaml.psi.YamlPsiUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/yaml/inspections/YamlIncompatibleTypesVisitor;", "Lorg/jetbrains/yaml/psi/YamlPsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "getMostPopularTypeForSiblings", "Lorg/jetbrains/yaml/meta/model/YamlMetaType;", "value", "Lorg/jetbrains/yaml/psi/YAMLValue;", "visitScalar", "", "scalar", "Lorg/jetbrains/yaml/psi/YAMLScalar;", "intellij.yaml"})
@SourceDebugExtension(value={"SMAP\nYAMLIncompatibleTypesInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YAMLIncompatibleTypesInspection.kt\norg/jetbrains/yaml/inspections/YamlIncompatibleTypesVisitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,95:1\n473#2:96\n1247#2,2:97\n37#3,2:99\n66#4,2:101\n*S KotlinDebug\n*F\n+ 1 YAMLIncompatibleTypesInspection.kt\norg/jetbrains/yaml/inspections/YamlIncompatibleTypesVisitor\n*L\n43#1:96\n47#1:97,2\n56#1:99,2\n62#1:101,2\n*E\n"})
final class YamlIncompatibleTypesVisitor
extends YamlPsiElementVisitor {
    @NotNull
    private final ProblemsHolder holder;
    @NotNull
    private final LocalInspectionToolSession session;

    public YamlIncompatibleTypesVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.holder = holder;
        this.session = session;
    }

    public void visitScalar(@NotNull YAMLScalar scalar) {
        Intrinsics.checkNotNullParameter((Object)scalar, (String)"scalar");
        YamlMetaType yamlMetaType = YamlPsiUtilKt.estimatedType(scalar);
        if (yamlMetaType == null) {
            return;
        }
        YamlMetaType estimatedType = yamlMetaType;
        YamlMetaType mostPopularType = this.getMostPopularTypeForSiblings((YAMLValue)scalar);
        if (mostPopularType == null || Intrinsics.areEqual((Object)mostPopularType, (Object)estimatedType)) {
            return;
        }
        SmartList quickFixes = new SmartList();
        if (Intrinsics.areEqual((Object)mostPopularType, (Object)YamlStringType.getInstance())) {
            boolean bl;
            boolean singleQuote;
            block5: {
                Sequence<YAMLPsiElement> siblings;
                Sequence<YAMLPsiElement> $this$filterIsInstance$iv = siblings = YamlPsiUtilKt.findStructuralSiblings((YAMLValue)scalar);
                boolean $i$f$filterIsInstance = false;
                Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)visitScalar$$inlined$filterIsInstance$1.INSTANCE);
                Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                YAMLQuotedText yAMLQuotedText = (YAMLQuotedText)SequencesKt.firstOrNull((Sequence)sequence);
                singleQuote = yAMLQuotedText != null ? yAMLQuotedText.isSingleQuote() : false;
                PsiElement psiElement = (PsiElement)scalar;
                String string = YAMLBundle.message((String)"inspections.incompatible.types.quickfix.wrap.quotes.message", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                quickFixes.add((Object)new YAMLAddQuoteQuickFix(psiElement, string, singleQuote));
                Sequence<YAMLPsiElement> $this$any$iv = siblings;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    YAMLPsiElement it = (YAMLPsiElement)element$iv;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)scalar) && !(it instanceof YAMLQuotedText))) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
            if (bl) {
                quickFixes.add((Object)new YAMLAddQuotesToSiblingsQuickFix((YAMLValue)scalar, singleQuote));
            }
        }
        Object[] objectArray = new Object[]{estimatedType.getDisplayName(), mostPopularType.getDisplayName()};
        String string = YAMLBundle.message((String)"inspections.incompatible.types.message", (Object[])objectArray);
        Collection $this$toTypedArray$iv = (Collection)quickFixes;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
        this.holder.registerProblem((PsiElement)scalar, string, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(objectArray, objectArray.length));
        super.visitScalar(scalar);
    }

    private final YamlMetaType getMostPopularTypeForSiblings(YAMLValue value) {
        PsiElement $this$parentOfType_u24default$iv = (PsiElement)value;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        YAMLSequence yAMLSequence = (YAMLSequence)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, YAMLSequence.class, (boolean)true);
        if (yAMLSequence == null) {
            return null;
        }
        YAMLSequence topSeq = yAMLSequence;
        return (YamlMetaType)YAMLIncompatibleTypesInspectionKt.access$memoizeWith2Keys((UserDataHolder)this.session, YAMLIncompatibleTypesInspectionKt.access$getSTRUCTURAL_SIBLINGS_TYPE_KEY$p(), topSeq, YamlPsiUtilKt.getKeysInBetween(value, topSeq), getMostPopularTypeForSiblings.1.INSTANCE);
    }
}

