/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.treetable;

import com.intellij.ui.CellRendererPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MouseAwareTreeCellRendererPanel
extends CellRendererPanel
implements TreeCellRenderer {
    @NotNull
    protected final JTree tree;
    protected boolean isUpdateCursor;
    @NotNull
    private final HighlightState highlight;
    @NotNull
    private final CellRendererPane renderer;
    private final MouseAdapter listener;
    private final PropertyChangeListener propertyListener;

    protected MouseAwareTreeCellRendererPanel(@NotNull JTree tree) {
        if (tree == null) {
            MouseAwareTreeCellRendererPanel.$$$reportNull$$$0(0);
        }
        this.isUpdateCursor = true;
        this.highlight = new HighlightState();
        this.renderer = new CellRendererPane();
        this.listener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (MouseAwareTreeCellRendererPanel.this.highlight.component != null) {
                    MouseAwareTreeCellRendererPanel.this.mousePressed(e);
                    MouseAwareTreeCellRendererPanel.this.processMouseMovements(e.getPoint());
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MouseAwareTreeCellRendererPanel.this.highlight.component != null) {
                    MouseAwareTreeCellRendererPanel.this.mouseClicked(e);
                    MouseAwareTreeCellRendererPanel.this.processMouseMovements(e.getPoint());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (MouseAwareTreeCellRendererPanel.this.highlight.component != null) {
                    MouseAwareTreeCellRendererPanel.this.mouseReleased(e);
                    MouseAwareTreeCellRendererPanel.this.processMouseMovements(e.getPoint());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                MouseAwareTreeCellRendererPanel.this.processMouseMovements(Objects.requireNonNull(e).getPoint());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MouseAwareTreeCellRendererPanel.this.processMouseMovements(Objects.requireNonNull(e).getPoint());
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                MouseAwareTreeCellRendererPanel.this.processMouseMovements(Objects.requireNonNull(e).getPoint());
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                MouseAwareTreeCellRendererPanel.this.tree.getParent().dispatchEvent(e);
                MouseAwareTreeCellRendererPanel.this.update();
            }
        };
        this.propertyListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("cellRenderer".equals(evt.getPropertyName()) && evt.getNewValue() != MouseAwareTreeCellRendererPanel.this) {
                    MouseAwareTreeCellRendererPanel.this.clear();
                }
            }
        };
        this.tree = tree;
        this.tree.addMouseListener(this.listener);
        this.tree.addMouseMotionListener(this.listener);
        this.tree.addMouseWheelListener(this.listener);
        this.tree.addPropertyChangeListener(this.propertyListener);
        this.tree.add(this.renderer);
    }

    public int getHighlightedRow() {
        return this.highlight.row;
    }

    @Nullable
    public Object getHighlightedValue() {
        return this.highlight.value;
    }

    @Nullable
    public JComponent getHighlightedComponent() {
        return this.highlight.component;
    }

    protected void mousePressed(MouseEvent event) {
    }

    protected void mouseClicked(MouseEvent event) {
    }

    protected void mouseReleased(MouseEvent event) {
    }

    public boolean isHighlightEnabled(int row, Object value) {
        return true;
    }

    public void update() {
        Point location = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(location, this.tree);
        this.processMouseMovements(location);
    }

    protected abstract JComponent @NotNull [] getHighlightables();

    public void clear() {
        this.tree.remove(this.renderer);
        this.tree.removeMouseListener(this.listener);
        this.tree.removeMouseMotionListener(this.listener);
        this.tree.removeMouseWheelListener(this.listener);
        this.tree.removePropertyChangeListener(this.propertyListener);
        this.highlight.clear();
    }

    private void processMouseMovements(@NotNull Point mousePosition) {
        TreePath path;
        int row;
        if (mousePosition == null) {
            MouseAwareTreeCellRendererPanel.$$$reportNull$$$0(1);
        }
        if ((row = this.tree.getRowForPath(path = this.tree.getClosestPathForLocation(mousePosition.x, mousePosition.y))) >= 0 && this.isHighlightEnabled(row, Objects.requireNonNull(path).getLastPathComponent())) {
            boolean focus;
            boolean leaf;
            boolean selected = this.tree.isRowSelected(row);
            boolean expanded = this.tree.isExpanded(row);
            Object value = Objects.requireNonNull(path).getLastPathComponent();
            Component component = this.getTreeCellRendererComponent(this.tree, value, selected, expanded, leaf = this.tree.getModel().isLeaf(value), row, focus = this.tree.hasFocus());
            if (component != this) {
                throw new IllegalStateException("MouseAwareTreeCellRendererPanel must return itself");
            }
            Rectangle bounds2 = this.tree.getRowBounds(row);
            this.renderer.add(component);
            component.setBounds(bounds2);
            component.validate();
            this.renderer.removeAll();
            for (JComponent highlightable : this.getHighlightables()) {
                Rectangle b = highlightable.getBounds();
                b.x += bounds2.x;
                b.y += bounds2.y;
                if (!highlightable.isVisible() || !b.contains(mousePosition)) continue;
                if (!this.highlight.equalsTo(highlightable, b, value, row)) {
                    this.highlight.repaint(this.tree);
                    this.highlight.setComponent(highlightable, b, value, row);
                    if (this.isUpdateCursor) {
                        this.tree.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    this.tree.repaint(b);
                }
                return;
            }
        }
        this.highlight.repaint(this.tree);
        this.highlight.clear();
        if (this.isUpdateCursor && this.tree.getRowCount() > 0) {
            this.tree.setCursor(Cursor.getDefaultCursor());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mousePosition";
                break;
            }
        }
        objectArray2[1] = "com/intellij/profiler/ui/treetable/MouseAwareTreeCellRendererPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "processMouseMovements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class HighlightState {
        private JComponent component;
        private final Rectangle componentBounds = new Rectangle();
        private Object value;
        private int row = -1;

        private HighlightState() {
        }

        public void setComponent(JComponent component, Rectangle componentBounds, Object value, int row) {
            this.component = component;
            this.componentBounds.setBounds(componentBounds);
            this.value = value;
            this.row = row;
        }

        public void clear() {
            this.component = null;
            this.componentBounds.setBounds(0, 0, 0, 0);
            this.value = null;
            this.row = -1;
        }

        public boolean equalsTo(JComponent component, Rectangle componentBounds, Object value, int row) {
            return row == this.row && component == this.component && Objects.equals(componentBounds, this.componentBounds) && Objects.equals(value, this.value);
        }

        public void repaint(JTree tree) {
            if (this.component != null) {
                tree.repaint(this.componentBounds);
            }
        }
    }
}

