/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.flamegraph;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.profiler.api.Fraction;
import com.intellij.profiler.ui.flamegraph.DefaultFlameGraphModel;
import com.intellij.profiler.ui.flamegraph.FlameGraphModel;
import com.intellij.profiler.ui.flamegraph.FlameGraphNode;
import com.intellij.profiler.ui.flamegraph.FlameGraphNodes;
import com.intellij.profiler.ui.grouping.FoldingNodesGroup;
import com.intellij.util.containers.FilteredTraverserBase;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.IntUnaryOperator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0012\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001*B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002JG\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t2\u001e\u0010\u000b\u001a\u001a\u0012\u0004\u0012\u00028\u0000\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\t0\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H\u0016Jo\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00190\u00182\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00160\u0018\u00a2\u0006\u0002\u0010\u001bJ3\u0010\u001c\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0014\u00a2\u0006\u0002\u0010\u001eJ\u001b\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00192\u0006\u0010 \u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010!J\b\u0010\"\u001a\u00020\u0016H\u0016J\b\u0010#\u001a\u00020\u0016H\u0016J\u0015\u0010$\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010%J\u0019\u0010&\u001a\u00020\u0016*\u00028\u00002\u0006\u0010 \u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010'J\u0011\u0010(\u001a\u00020\u0005*\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010)\u00a8\u0006+"}, d2={"Lcom/intellij/profiler/ui/flamegraph/DefaultFlameGraphModel;", "T", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphModel;", "()V", "alwaysVisibleSize", "", "create", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNodes;", "alwaysVisible", "", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "visibleUnfolded", "", "([Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;Ljava/util/Map;)Lcom/intellij/profiler/ui/flamegraph/FlameGraphNodes;", "createNodes", "root", "size", "start", "", "end", "depth", "includeRoot", "", "computeChildren", "Lkotlin/Function1;", "", "stop", "(Ljava/lang/Object;IDDIZLkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Lcom/intellij/profiler/ui/flamegraph/FlameGraphNodes;", "doCreateFlameGraphNode", "content", "(Ljava/lang/Object;DDI)Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "getChildrenIgnoreGroups", "node", "(Ljava/lang/Object;)Ljava/util/List;", "isEmpty", "isRootNodeVisible", "isUnfoldedGroup", "(Ljava/lang/Object;)Z", "containsAsGroupEnd", "(Ljava/lang/Object;Ljava/lang/Object;)Z", "groupSize", "(Ljava/lang/Object;)I", "SimpleFlameGraphNode", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nFlameGraphModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FlameGraphModel.kt\ncom/intellij/profiler/ui/flamegraph/DefaultFlameGraphModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n1#2:218\n1549#3:219\n1620#3,3:220\n1054#3:223\n1855#3,2:224\n1855#3,2:226\n*S KotlinDebug\n*F\n+ 1 FlameGraphModel.kt\ncom/intellij/profiler/ui/flamegraph/DefaultFlameGraphModel\n*L\n136#1:219\n136#1:220,3\n138#1:223\n160#1:224,2\n172#1:226,2\n*E\n"})
public abstract class DefaultFlameGraphModel<T>
implements FlameGraphModel<T> {
    @Override
    public boolean isEmpty() {
        return this.getRoot() == null;
    }

    @NotNull
    protected FlameGraphNode<T> doCreateFlameGraphNode(T content, double start2, double end, int depth) {
        return new SimpleFlameGraphNode<T>(content, start2, end, depth);
    }

    public boolean isRootNodeVisible() {
        return true;
    }

    @Override
    @NotNull
    public FlameGraphNodes<T> createNodes() {
        Object t = this.getRoot();
        if (t == null) {
            return FlameGraphNodes.Companion.empty();
        }
        Object root = t;
        int initialDepth = this.isRootNodeVisible() ? 1 : 0;
        return this.createNodes(root, this.alwaysVisibleSize(), 0.0, 1.0, initialDepth, true, (Function1)new Function1<T, List<? extends T>>(this){
            final /* synthetic */ DefaultFlameGraphModel<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final List<T> invoke(T it) {
                return this.this$0.getChildren(it);
            }
        }, createNodes.2.INSTANCE);
    }

    private final boolean isUnfoldedGroup(T content) {
        return content instanceof FoldingNodesGroup && !((FoldingNodesGroup)content).isFolded();
    }

    public boolean containsAsGroupEnd(T $this$containsAsGroupEnd, T node2) {
        return false;
    }

    public int groupSize(T $this$groupSize) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public FlameGraphNodes<T> create(@NotNull FlameGraphNode<T>[] alwaysVisible, @NotNull Map<T, FlameGraphNode<T>[]> visibleUnfolded) {
        Intrinsics.checkNotNullParameter(alwaysVisible, (String)"alwaysVisible");
        Intrinsics.checkNotNullParameter(visibleUnfolded, (String)"visibleUnfolded");
        return new FlameGraphNodes<T>(alwaysVisible);
    }

    @NotNull
    public List<T> getChildrenIgnoreGroups(T node2) {
        return this.getChildren(node2);
    }

    @NotNull
    public final FlameGraphNodes<T> createNodes(T root, int size2, double start2, double end, int depth, boolean includeRoot, @NotNull Function1<? super T, ? extends List<? extends T>> computeChildren, @NotNull Function1<? super T, Boolean> stop) {
        Intrinsics.checkNotNullParameter(computeChildren, (String)"computeChildren");
        Intrinsics.checkNotNullParameter(stop, (String)"stop");
        int alwaysVisibleSize2 = includeRoot ? size2 : size2 - 1;
        FlameGraphNode[] alwaysVisibleNodes = new FlameGraphNode[alwaysVisibleSize2];
        Map visibleUnfolded = new LinkedHashMap();
        Map visibleUnfoldedSizes = new LinkedHashMap();
        LinkedList<Pair<FlameGraphNode<T>, T>> queue = new LinkedList<Pair<FlameGraphNode<T>, T>>();
        FlameGraphNode<T> rootFlameGraphNode = this.doCreateFlameGraphNode(root, start2, end, depth);
        if (includeRoot) {
            queue.add(TuplesKt.to(rootFlameGraphNode, null));
        } else {
            DefaultFlameGraphModel.createNodes$addChildren(queue, stop, computeChildren, this, rootFlameGraphNode, null);
        }
        while (!((Collection)queue).isEmpty()) {
            ProgressManager.checkCanceled();
            Pair<FlameGraphNode<T>, T> pair = queue.removeFirst();
            FlameGraphNode current = (FlameGraphNode)pair.component1();
            Object group2 = pair.component2();
            if (group2 != null) {
                Integer n = visibleUnfoldedSizes.computeIfAbsent(group2, arg_0 -> DefaultFlameGraphModel.createNodes$lambda$6((Function1)new Function1<T, Integer>(this, group2){
                    final /* synthetic */ DefaultFlameGraphModel<T> this$0;
                    final /* synthetic */ T $group;
                    {
                        this.this$0 = $receiver;
                        this.$group = $group;
                        super(1);
                    }

                    @NotNull
                    public final Integer invoke(T it) {
                        return this.this$0.groupSize(this.$group) - 1;
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)n, (String)"computeIfAbsent(...)");
                int size3 = ((Number)n).intValue();
                Intrinsics.checkNotNullExpressionValue((Object)visibleUnfolded.computeIfAbsent(group2, arg_0 -> DefaultFlameGraphModel.createNodes$lambda$7((Function1)new Function1<T, FlameGraphNode<T>[]>(this, group2){
                    final /* synthetic */ DefaultFlameGraphModel<T> this$0;
                    final /* synthetic */ T $group;
                    {
                        this.this$0 = $receiver;
                        this.$group = $group;
                        super(1);
                    }

                    @NotNull
                    public final FlameGraphNode<T>[] invoke(T it) {
                        return new FlameGraphNode[this.this$0.groupSize(this.$group)];
                    }
                }, arg_0)), (String)"computeIfAbsent(...)");
                array[size3] = current;
                visibleUnfoldedSizes.put(group2, size3 - 1);
            } else {
                alwaysVisibleNodes[--alwaysVisibleSize2] = current;
            }
            Object content = current.getContent();
            if (((Boolean)stop.invoke(content)).booleanValue()) continue;
            DefaultFlameGraphModel.createNodes$addChildren(queue, stop, computeChildren, this, current, group2);
        }
        return this.create(alwaysVisibleNodes, TypeIntrinsics.asMutableMap((Object)visibleUnfolded));
    }

    private final int alwaysVisibleSize() {
        FilteredTraverserBase filteredTraverserBase = JBTreeTraverser.from(arg_0 -> DefaultFlameGraphModel.alwaysVisibleSize$lambda$8((Function1)new Function1<T, Iterable<? extends T>>(this){
            final /* synthetic */ DefaultFlameGraphModel<T> this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Iterable<T> invoke(T it) {
                return this.this$0.getChildrenIgnoreGroups(it);
            }
        }, arg_0)).withRoot(this.getRoot());
        Intrinsics.checkNotNullExpressionValue((Object)filteredTraverserBase, (String)"withRoot(...)");
        return CollectionsKt.count((Iterable)((Iterable)filteredTraverserBase));
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> void createNodes$checkDelta(double delta, double width, T parent, T child, Fraction fraction, List<? extends Pair<? extends T, Fraction>> childrenWithFraction) {
        if (!(0.0 <= delta ? delta <= width : false)) {
            long l;
            Iterable iterable = childrenWithFraction;
            long l2 = fraction.getDenominator();
            double d = delta / width;
            T t = child;
            T t2 = parent;
            long l3 = 0L;
            for (Object t3 : iterable) {
                void it;
                Pair pair = (Pair)t3;
                l = l3;
                boolean bl = false;
                long l4 = ((Fraction)it.getSecond()).getNumerator();
                l3 = l + l4;
            }
            l = l3;
            String message2 = StringsKt.trimIndent((String)("\n          Error creating children for node '" + t2 + "':\n          Invalid fraction of node '" + t + "': expected a value in interval [0, 1], got " + d + ".\n          Parent value: " + l2 + "\n          Total children value: " + l + "\n          Amount of children: " + childrenWithFraction.size() + "\n          Values: [" + CollectionsKt.joinToString$default((Iterable)childrenWithFraction, null, null, null, (int)0, null, (Function1)createNodes.checkDelta.message.2.INSTANCE, (int)31, null) + "]\n        "));
            throw new IllegalArgumentException(message2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> void createNodes$addChildren(LinkedList<Pair<FlameGraphNode<T>, T>> $this$createNodes_u24addChildren, Function1<? super T, Boolean> $stop, Function1<? super T, ? extends List<? extends T>> $computeChildren, DefaultFlameGraphModel<T> this$0, FlameGraphNode<T> current, T groupContent) {
        T childrenGroup;
        void $this$sortedByDescending$iv;
        Pair it;
        Iterable $this$mapTo$iv$iv;
        T content = current.getContent();
        if (((Boolean)$stop.invoke(content)).booleanValue()) {
            return;
        }
        double width = current.getEnd() - current.getStart();
        List children2 = (List)$computeChildren.invoke(content);
        if (children2.isEmpty()) {
            return;
        }
        Iterable $this$map$iv = children2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)it, (Object)this$0.getExactFractionOfParent((void)content, (void)it)));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$sortedByDescending = false;
        List childrenWithFraction = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair it = (Pair)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(((Fraction)it.getSecond()).getNumerator());
                it = (Pair)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(((Fraction)it.getSecond()).getNumerator()));
            }
        });
        $this$mapTo$iv$iv = childrenWithFraction;
        long l = 0L;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Pair)item$iv$iv;
            long l2 = l;
            boolean bl = false;
            long l3 = ((Fraction)it.getSecond()).getNumerator();
            l = l2 + l3;
        }
        long totalChildrenValue = l;
        long parentValue = ((Fraction)((Pair)CollectionsKt.first((List)childrenWithFraction)).getSecond()).getDenominator();
        if (totalChildrenValue > parentValue) {
            String message2 = StringsKt.trimIndent((String)("\n          Error creating children for node '" + current.getContent() + "':\n          Total children value should be less or equal than parent value (got children value " + totalChildrenValue + " against parent value " + parentValue + ").\n          Amount of children: " + childrenWithFraction.size() + "\n          Values: [" + CollectionsKt.joinToString$default((Iterable)childrenWithFraction, null, null, null, (int)0, null, (Function1)createNodes.addChildren.message.1.INSTANCE, (int)31, null) + "]\n        "));
            throw new IllegalArgumentException(message2);
        }
        T t = super.isUnfoldedGroup((void)content) ? content : (groupContent != null && !this$0.containsAsGroupEnd((void)groupContent, (void)content) ? groupContent : (childrenGroup = null));
        if (totalChildrenValue == parentValue) {
            double base = 0.0;
            base = current.getEnd();
            List newNodes2 = new ArrayList();
            Iterable $this$forEach$iv = CollectionsKt.asReversed((List)childrenWithFraction);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                Object child = pair.component1();
                Fraction fractionOfParent = (Fraction)pair.component2();
                double delta = width * fractionOfParent.asDouble();
                DefaultFlameGraphModel.createNodes$checkDelta(delta, width, current.getContent(), child, fractionOfParent, childrenWithFraction);
                double newBase = base - delta;
                newNodes2.add(TuplesKt.to(this$0.doCreateFlameGraphNode((void)child, Math.max(newBase, current.getStart()), base, current.getDepth() + 1), childrenGroup));
                base = newBase;
            }
            $this$createNodes_u24addChildren.addAll(CollectionsKt.asReversedMutable((List)newNodes2));
        } else {
            double base = 0.0;
            base = current.getStart();
            Iterable $this$forEach$iv = childrenWithFraction;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                Object child = pair.component1();
                Fraction fractionOfParent = (Fraction)pair.component2();
                double delta = width * fractionOfParent.asDouble();
                DefaultFlameGraphModel.createNodes$checkDelta(delta, width, current.getContent(), child, fractionOfParent, childrenWithFraction);
                $this$createNodes_u24addChildren.add(TuplesKt.to(this$0.doCreateFlameGraphNode((void)child, base, Math.min(base + delta, current.getEnd()), current.getDepth() + 1), childrenGroup));
                base += delta;
            }
        }
    }

    private static final Integer createNodes$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0);
    }

    private static final FlameGraphNode[] createNodes$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FlameGraphNode[])$tmp0.invoke(p0);
    }

    private static final Iterable alwaysVisibleSize$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Iterable)$tmp0.invoke(p0);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0004\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B%\u0012\u0006\u0010\u0003\u001a\u00028\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00028\u00010\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0016\u0010\u0003\u001a\u00028\u0001X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/ui/flamegraph/DefaultFlameGraphModel$SimpleFlameGraphNode;", "T", "Lcom/intellij/profiler/ui/flamegraph/FlameGraphNode;", "content", "start", "", "end", "depth", "", "(Ljava/lang/Object;DDI)V", "getContent", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getDepth", "()I", "getEnd", "()D", "getStart", "mapDepth", "transformDepth", "Ljava/util/function/IntUnaryOperator;", "intellij.profiler.common"})
    protected static final class SimpleFlameGraphNode<T>
    implements FlameGraphNode<T> {
        private final T content;
        private final double start;
        private final double end;
        private final int depth;

        public SimpleFlameGraphNode(T content, double start2, double end, int depth) {
            this.content = content;
            this.start = start2;
            this.end = end;
            this.depth = depth;
        }

        @Override
        public T getContent() {
            return this.content;
        }

        @Override
        public double getStart() {
            return this.start;
        }

        @Override
        public double getEnd() {
            return this.end;
        }

        @Override
        public int getDepth() {
            return this.depth;
        }

        @Override
        @NotNull
        public FlameGraphNode<T> mapDepth(@NotNull IntUnaryOperator transformDepth) {
            Intrinsics.checkNotNullParameter((Object)transformDepth, (String)"transformDepth");
            return new SimpleFlameGraphNode<T>(this.getContent(), this.getStart(), this.getEnd(), transformDepth.applyAsInt(this.getDepth()));
        }
    }
}

