/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.model.CallTreeNode;
import com.intellij.profiler.ui.flamechart.FlameChartColorScheme;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import com.intellij.profiler.ui.flamegraph.FlameChartColorsPreprocessor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import java.awt.FontMetrics;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000  2\u00020\u0001:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0004\u0012\u00020\u00100\u000e2\b\b\u0001\u0010\u0011\u001a\u00020\u00102\b\b\u0001\u0010\u0012\u001a\u00020\u0010H\u0004J\u0016\u0010\u0013\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0015\u0018\u00010\u0014H\u0016J \u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0017J\b\u0010\u001e\u001a\u00020\u001cH\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0006H\u0017\u00a8\u0006\""}, d2={"Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "", "()V", "appendStackElementInRenderer", "", "node", "Lcom/intellij/profiler/api/BaseCallStackElement;", "label", "Lcom/intellij/ui/SimpleColoredComponent;", "component", "Ljavax/swing/JComponent;", "selected", "", "classPartsAndMethod", "Lkotlin/Pair;", "", "", "text", "separator", "colorsPreprocessor", "Lcom/intellij/profiler/ui/flamegraph/FlameChartColorsPreprocessor;", "Lcom/intellij/profiler/model/CallTreeNode;", "fillTextInsideNode", "rect", "Ljava/awt/geom/Rectangle2D;", "fontMetrics", "Ljava/awt/FontMetrics;", "getColorScheme", "Lcom/intellij/profiler/ui/flamechart/FlameChartColorScheme;", "getCommentInfo", "getRootColorScheme", "getText", "Companion", "Empty", "intellij.profiler.common"})
public abstract class BaseCallStackElementRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int LEFT_MARGIN_PX = 0;
    public static final int GROUP_MARGIN_PX = 5;
    public static final int COMMENT_MARGIN_PX = 5;
    public static final int SHORTEST_LENGTH = 3;

    @NotNull
    public String fillTextInsideNode(@NotNull BaseCallStackElement node2, @NotNull Rectangle2D rect, @NotNull FontMetrics fontMetrics) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)fontMetrics, (String)"fontMetrics");
        String text2 = this.getText(node2);
        String trimmedText = StringsKt.take((String)text2, (int)3);
        if ((double)fontMetrics.stringWidth(trimmedText) < rect.getWidth() - 0.0) {
            return text2;
        }
        return "";
    }

    @NlsSafe
    @NotNull
    public String getText(@NotNull BaseCallStackElement node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return node2.fullName();
    }

    public void appendStackElementInRenderer(@NotNull BaseCallStackElement node2, @NotNull SimpleColoredComponent label, @NotNull JComponent component, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        SpeedSearchUtil.appendFragmentsForSpeedSearch((JComponent)component, (String)this.getText(node2), (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES, (boolean)selected, (SimpleColoredComponent)label);
    }

    @NotNull
    public FlameChartColorScheme getColorScheme(@NotNull BaseCallStackElement node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return FlameChartColors.DEFAULT.INSTANCE;
    }

    @NotNull
    public FlameChartColorScheme getRootColorScheme() {
        return FlameChartColors.PARENT.INSTANCE;
    }

    @Nls
    @Nullable
    public String getCommentInfo(@NotNull BaseCallStackElement node2) {
        Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
        return null;
    }

    @NotNull
    protected final Pair<List<String>, String> classPartsAndMethod(@NlsSafe @NotNull String text2, @NlsSafe @NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        String[] stringArray = new String[]{separator};
        List part = StringsKt.split$default((CharSequence)text2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        return new Pair((Object)CollectionsKt.dropLast((List)part, (int)1), CollectionsKt.last((List)part));
    }

    @Nullable
    public FlameChartColorsPreprocessor<CallTreeNode<BaseCallStackElement>> colorsPreprocessor() {
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/ui/BaseCallStackElementRenderer$Companion;", "", "()V", "COMMENT_MARGIN_PX", "", "GROUP_MARGIN_PX", "LEFT_MARGIN_PX", "SHORTEST_LENGTH", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lcom/intellij/profiler/ui/BaseCallStackElementRenderer$Empty;", "Lcom/intellij/profiler/ui/BaseCallStackElementRenderer;", "()V", "intellij.profiler.common"})
    public static final class Empty
    extends BaseCallStackElementRenderer {
        @NotNull
        public static final Empty INSTANCE = new Empty();

        private Empty() {
        }
    }
}

