/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.qodanaDotnet.coverage;

import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.coverage.lcov.LcovCoverageReport;
import com.intellij.coverage.lcov.LcovSerializationUtils;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpFileType;
import com.jetbrains.rider.languages.fileTypes.csharp.kotoparser.lexer.CSharpTokenType;
import com.jetbrains.rider.languages.fileTypes.csharp.psi.impl.CSharpElementTypes;
import com.jetbrains.rider.plugins.appender.qodanaDotnet.coverage.NetCoverageInspection;
import com.jetbrains.rider.plugins.appender.qodanaDotnet.coverage.NetCoverageInspectionKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageInspectionBase;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.UtilsKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaGlobalInspectionContext;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J6\u0010\u0017\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00100\u001b2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0010H\u0002JV\u0010\u001e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2$\u0010\u001f\u001a \u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00070 2\u001e\u0010\"\u001a\u001a\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00070#H\u0002J\u0010\u0010$\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010%\u001a\u00020!2\u0006\u0010\b\u001a\u00020\tH\u0016R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/plugins/appender/qodanaDotnet/coverage/NetCoverageInspection;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageInspectionBase;", "()V", "classTypes", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "checker", "", "file", "Lcom/intellij/psi/PsiFile;", "problemsHolder", "Lcom/intellij/codeInspection/ProblemsHolder;", "globalContext", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaGlobalInspectionContext;", "cleanup", "computeMethodNameFromData", "", "data", "Lcom/intellij/rt/coverage/data/ClassData;", "project", "Lcom/intellij/openapi/project/Project;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "computeName", "grandPa", "Lcom/intellij/lang/ASTNode;", "classes", "", "parent", "namespace", "kotoVisitor", "visitMethod", "Lkotlin/Function4;", "", "visitClass", "Lkotlin/Function3;", "loadCoverage", "validateFileType", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nNetCoverageInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NetCoverageInspection.kt\ncom/jetbrains/rider/plugins/appender/qodanaDotnet/coverage/NetCoverageInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,182:1\n1855#2,2:183\n13#3:185\n13#4:186\n*S KotlinDebug\n*F\n+ 1 NetCoverageInspection.kt\ncom/jetbrains/rider/plugins/appender/qodanaDotnet/coverage/NetCoverageInspection\n*L\n99#1:183,2\n33#1:185\n33#1:186\n*E\n"})
public final class NetCoverageInspection
extends CoverageInspectionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TokenSet classTypes;
    @NotNull
    private static final Logger logger;

    public NetCoverageInspection() {
        IElementType[] iElementTypeArray = new IElementType[]{CSharpElementTypes.INSTANCE.getDUMMY_TYPE_DECLARATION(), CSharpElementTypes.INSTANCE.getCLASS_DECLARATION(), CSharpElementTypes.INSTANCE.getATTRIBUTE_DECLARATION(), CSharpElementTypes.INSTANCE.getCLASSRECORD_DECLARATION(), CSharpElementTypes.INSTANCE.getDELEGATE_DECLARATION()};
        TokenSet tokenSet = TokenSet.create((IElementType[])iElementTypeArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"create(...)");
        this.classTypes = tokenSet;
    }

    public void loadCoverage(@NotNull QodanaGlobalInspectionContext globalContext) {
        Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
        globalContext.putUserData(NetCoverageInspectionKt.access$getLcov$p(), (Object)LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)((Function0)new Function0<ProjectData>(this, globalContext){
            final /* synthetic */ NetCoverageInspection this$0;
            final /* synthetic */ QodanaGlobalInspectionContext $globalContext;
            {
                this.this$0 = $receiver;
                this.$globalContext = $globalContext;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final ProjectData invoke() {
                List coverageFiles = NetCoverageInspection.access$provideCoverageFiles(this.this$0, this.$globalContext);
                NetCoverageInspection.access$getLogger$cp().info("Coverage for .NET - provided " + coverageFiles.size() + " files");
                Project project = this.$globalContext.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
                if (projectDir == null) {
                    NetCoverageInspection.access$getLogger$cp().error("Was not able to find project dir");
                    return null;
                }
                if (!((Collection)coverageFiles).isEmpty()) {
                    ProjectData projectData;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv = coverageFiles;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        File it = (File)element$iv$iv;
                        boolean bl = false;
                        String string = it.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                        if (!StringsKt.endsWith((String)string, (String)".info", (boolean)true)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List lcovs = (List)destination$iv$iv;
                    LcovCoverageReport lcovCoverageReport = LcovSerializationUtils.readLCOV((List)lcovs);
                    Intrinsics.checkNotNullExpressionValue((Object)lcovCoverageReport, (String)"readLCOV(...)");
                    LcovCoverageReport report = lcovCoverageReport;
                    String prefix = UtilsKt.findPathToRemap((Set)CollectionsKt.toSet((Iterable)report.getInfo().keySet()), (VirtualFile)projectDir);
                    if (prefix == null) {
                        NetCoverageInspection.access$getLogger$cp().error("Was not able to find prefix to remap");
                        projectData = null;
                    } else {
                        projectData = LcovSerializationUtils.convertToProjectData((LcovCoverageReport)report, arg_0 -> loadCoverage.1.invoke$lambda$1((Function1)new Function1<String, String>(prefix, projectDir){
                            final /* synthetic */ String $prefix;
                            final /* synthetic */ VirtualFile $projectDir;
                            {
                                this.$prefix = $prefix;
                                this.$projectDir = $projectDir;
                                super(1);
                            }

                            public final String invoke(String path) {
                                Intrinsics.checkNotNull((Object)path);
                                String string = this.$projectDir.getPath();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                                return StringsKt.replace$default((String)path, (String)this.$prefix, (String)string, (boolean)false, (int)4, null);
                            }
                        }, arg_0));
                    }
                    return projectData;
                }
                return null;
            }

            private static final String invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (String)$tmp0.invoke(p0);
            }
        })));
    }

    public void checker(@NotNull PsiFile file, @NotNull ProblemsHolder problemsHolder, @NotNull QodanaGlobalInspectionContext globalContext) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)problemsHolder, (String)"problemsHolder");
        Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
        Lazy lazy = (Lazy)globalContext.getUserData(NetCoverageInspectionKt.access$getLcov$p());
        if (lazy == null || (lazy = (ProjectData)lazy.getValue()) == null) {
            return;
        }
        Lazy report = lazy;
        String string = file.getVirtualFile().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        ClassData data = report.getClassData(UtilsKt.normalizeFilePath((String)string));
        if (data == null && !this.getWarnMissingCoverage()) {
            return;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
        UtilsKt.loadClassData((ClassData)data, (VirtualFile)virtualFile, (QodanaGlobalInspectionContext)globalContext);
        this.kotoVisitor(file, (Function4<? super String, ? super TextRange, ? super ASTNode, ? super Boolean, Unit>)((Function4)new Function4<String, TextRange, ASTNode, Boolean, Unit>(data, file, problemsHolder, this, globalContext){
            final /* synthetic */ ClassData $data;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ ProblemsHolder $problemsHolder;
            final /* synthetic */ NetCoverageInspection this$0;
            final /* synthetic */ QodanaGlobalInspectionContext $globalContext;
            {
                this.$data = $data;
                this.$file = $file;
                this.$problemsHolder = $problemsHolder;
                this.this$0 = $receiver;
                this.$globalContext = $globalContext;
                super(4);
            }

            public final void invoke(@NotNull String methodName, @NotNull TextRange coords, @NotNull ASTNode method, boolean isCtor) {
                Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                Project project = this.$problemsHolder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (UtilsKt.issueWithMethodCoverage((ClassData)this.$data, (PsiFile)this.$file, (TextRange)coords, (Project)project, (int)this.this$0.getMethodThreshold(), (boolean)this.this$0.getWarnMissingCoverage(), (QodanaGlobalInspectionContext)this.$globalContext)) {
                    String string;
                    CharSequence charSequence;
                    CharSequence charSequence2 = methodName;
                    Object object = this.this$0;
                    Object[] objectArray = this.$data;
                    ProblemsHolder problemsHolder = this.$problemsHolder;
                    PsiFile psiFile = this.$file;
                    if (charSequence2.length() == 0) {
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)objectArray);
                        Project project2 = problemsHolder.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
                        charSequence = NetCoverageInspection.access$computeMethodNameFromData(object, (ClassData)objectArray, project2, psiFile, coords);
                    } else {
                        charSequence = charSequence2;
                    }
                    String fqn = (String)charSequence;
                    if (!isCtor) {
                        objectArray = new Object[]{fqn, this.this$0.getMethodThreshold()};
                        string = QodanaBundle.message((String)"method.coverage.below.threshold", (Object[])objectArray);
                    } else {
                        objectArray = new Object[]{fqn, this.this$0.getMethodThreshold()};
                        string = QodanaBundle.message((String)"constructor.coverage.below.threshold", (Object[])objectArray);
                    }
                    object = string;
                    Intrinsics.checkNotNull((Object)object);
                    Object message = object;
                    PsiElement psiElement = method.getPsi();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                    UtilsKt.reportElement((ProblemsHolder)this.$problemsHolder, (PsiElement)NetCoverageInspection.access$highlightedElement(this.this$0, psiElement), (String)message);
                }
            }
        }), (Function3<? super String, ? super TextRange, ? super ASTNode, Unit>)((Function3)new Function3<String, TextRange, ASTNode, Unit>(data, file, problemsHolder, this){
            final /* synthetic */ ClassData $data;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ ProblemsHolder $problemsHolder;
            final /* synthetic */ NetCoverageInspection this$0;
            {
                this.$data = $data;
                this.$file = $file;
                this.$problemsHolder = $problemsHolder;
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(@NotNull String className, @NotNull TextRange coords, @NotNull ASTNode classdef) {
                Intrinsics.checkNotNullParameter((Object)className, (String)"className");
                Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                Intrinsics.checkNotNullParameter((Object)classdef, (String)"classdef");
                Project project = this.$problemsHolder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                if (UtilsKt.issueWithClassCoverage$default((ClassData)this.$data, (PsiFile)this.$file, (TextRange)coords, (Project)project, (int)this.this$0.getClassThreshold(), (boolean)this.this$0.getWarnMissingCoverage(), (boolean)false, (int)64, null)) {
                    PsiElement psiElement = classdef.getPsi();
                    Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getPsi(...)");
                    PsiElement psiElement2 = NetCoverageInspection.access$highlightedElement(this.this$0, psiElement);
                    Object[] objectArray = new Object[]{className, this.this$0.getClassThreshold()};
                    String string = QodanaBundle.message((String)"class.coverage.below.threshold", (Object[])objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    UtilsKt.reportElement((ProblemsHolder)this.$problemsHolder, (PsiElement)psiElement2, (String)string);
                }
            }
        }));
    }

    private final String computeMethodNameFromData(ClassData data, Project project, PsiFile file, TextRange textRange) {
        int startOffset;
        int startLineNumber;
        LineData lineData;
        Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(file);
        if (doc != null && (lineData = data.getLineData(startLineNumber = doc.getLineNumber(startOffset = textRange.getStartOffset()) + 1)) != null) {
            return lineData.getMethodSignature();
        }
        return null;
    }

    private final void kotoVisitor(PsiFile file, Function4<? super String, ? super TextRange, ? super ASTNode, ? super Boolean, Unit> visitMethod, Function3<? super String, ? super TextRange, ? super ASTNode, Unit> visitClass) {
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.astTraverser((ASTNode)((ASTNode)file.getNode()));
        Intrinsics.checkNotNullExpressionValue((Object)syntaxTraverser, (String)"astTraverser(...)");
        SyntaxTraverser astTraverser = syntaxTraverser;
        String namespace2 = null;
        namespace2 = "";
        Map classes = new LinkedHashMap();
        Iterable $this$forEach$iv = (Iterable)astTraverser;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ASTNode[] aSTNodeArray;
            ASTNode block;
            ASTNode grandPa;
            ASTNode parent;
            ASTNode element = (ASTNode)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)element.getElementType(), (Object)CSharpTokenType.IDENTIFIER)) continue;
            ASTNode aSTNode = parent = element.getTreeParent();
            if (!Intrinsics.areEqual((Object)(aSTNode != null ? aSTNode.getElementType() : null), (Object)CSharpElementTypes.INSTANCE.getDECLARATION_IDENTIFIER())) continue;
            ASTNode aSTNode2 = grandPa = parent.getTreeParent();
            Object object = aSTNode2 != null ? aSTNode2.getElementType() : null;
            if (Intrinsics.areEqual((Object)object, (Object)CSharpElementTypes.INSTANCE.getCTOR_DECLARATION()) ? true : Intrinsics.areEqual((Object)object, (Object)CSharpElementTypes.INSTANCE.getMETHOD_DECLARATION())) {
                ASTNode parentMethod = TreeUtil.findParent((ASTNode)grandPa, (IElementType)((IElementType)CSharpElementTypes.INSTANCE.getMETHOD_DECLARATION()));
                if (parentMethod != null) continue;
                String string = parent.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                TextRange textRange = grandPa.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                Intrinsics.checkNotNull((Object)grandPa);
                visitMethod.invoke((Object)string, (Object)textRange, (Object)grandPa, (Object)Intrinsics.areEqual((Object)grandPa.getElementType(), (Object)CSharpElementTypes.INSTANCE.getCTOR_DECLARATION()));
                continue;
            }
            if ((((Intrinsics.areEqual((Object)object, (Object)CSharpElementTypes.INSTANCE.getDUMMY_TYPE_DECLARATION()) ? true : Intrinsics.areEqual((Object)object, (Object)CSharpElementTypes.INSTANCE.getCLASS_DECLARATION())) ? true : Intrinsics.areEqual((Object)object, (Object)CSharpElementTypes.INSTANCE.getATTRIBUTE_DECLARATION())) ? true : Intrinsics.areEqual((Object)object, (Object)CSharpElementTypes.INSTANCE.getCLASSRECORD_DECLARATION())) ? true : Intrinsics.areEqual((Object)object, (Object)CSharpElementTypes.INSTANCE.getDELEGATE_DECLARATION())) {
                Intrinsics.checkNotNull((Object)parent);
                String className = this.computeName(grandPa, classes, parent, namespace2);
                Intrinsics.checkNotNull((Object)grandPa);
                classes.put(grandPa, className);
                TextRange textRange = grandPa.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                visitClass.invoke((Object)className, (Object)textRange, (Object)grandPa);
                continue;
            }
            if (Intrinsics.areEqual((Object)object, (Object)CSharpElementTypes.INSTANCE.getNAMESPACE_FILE_SCOPE_HEADER()) ? true : Intrinsics.areEqual((Object)object, (Object)CSharpElementTypes.INSTANCE.getNAMESPACE_DECLARATION())) {
                Intrinsics.checkNotNullExpressionValue((Object)element.getText(), (String)"getText(...)");
                continue;
            }
            if (!Intrinsics.areEqual((Object)object, (Object)CSharpElementTypes.INSTANCE.getPROPERTY_DECLARATION()) || (block = grandPa.findChildByType((IElementType)CSharpElementTypes.INSTANCE.getBLOCK_LIST())) == null) continue;
            ASTNode getter = null;
            ASTNode setter = null;
            Intrinsics.checkNotNullExpressionValue((Object)block.getChildren(null), (String)"getChildren(...)");
            for (ASTNode child : aSTNodeArray) {
                if (getter == null) {
                    getter = child.findChildByType((IElementType)CSharpTokenType.GET_KEYWORD);
                }
                if (setter == null) {
                    setter = child.findChildByType((IElementType)CSharpTokenType.SET_KEYWORD);
                }
                if (getter != null && setter != null) break;
            }
            if (getter != null) {
                String string = "get_" + parent.getText();
                TextRange textRange = getter.getTreeParent().getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                visitMethod.invoke((Object)string, (Object)textRange, (Object)getter, (Object)false);
            }
            if (setter == null) continue;
            String string = "set_" + parent.getText();
            TextRange textRange = setter.getTreeParent().getTextRange();
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
            visitMethod.invoke((Object)string, (Object)textRange, (Object)setter, (Object)false);
        }
    }

    private final String computeName(ASTNode grandPa, Map<ASTNode, String> classes, ASTNode parent, String namespace2) {
        Object object;
        ASTNode parentClass = TreeUtil.findParent((ASTNode)grandPa, (TokenSet)this.classTypes);
        if (parentClass != null) {
            String parentClassName = classes.get(parentClass);
            object = parentClassName + "." + parent.getText();
        } else {
            String string = Intrinsics.areEqual((Object)namespace2, (Object)"") ? parent.getText() : namespace2 + "." + parent.getText();
            Intrinsics.checkNotNull((Object)string);
            object = string;
        }
        return object;
    }

    public boolean validateFileType(@NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return Intrinsics.areEqual((Object)file.getFileType(), (Object)CSharpFileType.INSTANCE);
    }

    public void cleanup(@NotNull QodanaGlobalInspectionContext globalContext) {
        Intrinsics.checkNotNullParameter((Object)globalContext, (String)"globalContext");
        globalContext.putUserData(NetCoverageInspectionKt.access$getLcov$p(), null);
    }

    public static final /* synthetic */ List access$provideCoverageFiles(NetCoverageInspection $this, QodanaGlobalInspectionContext globalContext) {
        return $this.provideCoverageFiles(globalContext);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ PsiElement access$highlightedElement(NetCoverageInspection $this, PsiElement element) {
        return $this.highlightedElement(element);
    }

    public static final /* synthetic */ String access$computeMethodNameFromData(NetCoverageInspection $this, ClassData data, Project project, PsiFile file, TextRange textRange) {
        return $this.computeMethodNameFromData(data, project, file, textRange);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NetCoverageInspection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        NetCoverageInspection.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/plugins/appender/qodanaDotnet/coverage/NetCoverageInspection$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

