/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.llm.errorExplanation;

import com.intellij.ml.llm.errorExplanation.filters.ErrorExplainFilter;
import com.intellij.ml.llm.errorExplanation.filters.ExceptionRangePostprocessor;
import com.intellij.openapi.project.DumbAware;
import com.jetbrains.rider.plugins.appender.llm.errorExplanation.DotnetExceptionPostprocessor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/appender/llm/errorExplanation/DotnetExceptionLLMExplainFilter;", "Lcom/intellij/ml/llm/errorExplanation/filters/ErrorExplainFilter;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "exceptionPattern", "Lkotlin/text/Regex;", "getPostprocessor", "Lcom/intellij/ml/llm/errorExplanation/filters/ExceptionRangePostprocessor;", "isErrorBegin", "", "line", "", "entireLength", "", "isErrorEnd", "intellij.rider.plugins.appender"})
public final class DotnetExceptionLLMExplainFilter
extends ErrorExplainFilter
implements DumbAware {
    @NotNull
    private final Regex exceptionPattern = new Regex("([\\d\\p{L}]*)Exception\\s*:");

    public boolean isErrorBegin(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.getCurrentState() == ErrorExplainFilter.State.NO_EXCEPTION && this.exceptionPattern.containsMatchIn((CharSequence)line);
    }

    public boolean isErrorEnd(@NotNull String line, int entireLength) {
        Intrinsics.checkNotNullParameter((Object)line, (String)"line");
        return this.getCurrentState() == ErrorExplainFilter.State.COLLECTING;
    }

    @NotNull
    public ExceptionRangePostprocessor getPostprocessor() {
        return new DotnetExceptionPostprocessor();
    }
}

