/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.llm.docgen;

import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPrompt;
import com.intellij.ml.llm.core.chat.promptLibrary.core.systemPrompts.AISystemLibraryPromptService;
import com.intellij.ml.llm.core.grazieAPI.tasks.documentation.WdPromptCustomization;
import com.intellij.ml.llm.privacy.PSString;
import com.intellij.ml.llm.privacy.trustedStringBuilders.ConstantsKt;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.plugins.appender.base.llm.docgen.DocGenUtilKt;
import com.jetbrains.rider.plugins.appender.base.llm.docgen.RiderLLMDocumentationSupportBase;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\u0004H\u0016J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/plugins/appender/llm/docgen/CSharpLLMDocumentationSupport;", "Lcom/jetbrains/rider/plugins/appender/base/llm/docgen/RiderLLMDocumentationSupportBase;", "()V", "emptyDocumentation", "", "getEmptyDocumentation", "()Ljava/lang/String;", "parameterTag", "Lcom/intellij/ml/llm/privacy/PSString;", "getParameterTag", "()Lcom/intellij/ml/llm/privacy/PSString;", "returnTag", "getReturnTag", "buildDocFromSuggestion", "suggestion", "containsCompleteDoc", "", "promptCustomization", "Lcom/intellij/ml/llm/core/grazieAPI/tasks/documentation/WdPromptCustomization;", "project", "Lcom/intellij/openapi/project/Project;", "useChatCodeContextProvider", "intellij.rider.plugins.appender"})
public final class CSharpLLMDocumentationSupport
extends RiderLLMDocumentationSupportBase {
    @NotNull
    public String getEmptyDocumentation() {
        return "///";
    }

    @NotNull
    public PSString getParameterTag() {
        return ConstantsKt.getPrivacyConst((String)"<param>");
    }

    @NotNull
    public PSString getReturnTag() {
        return ConstantsKt.getPrivacyConst((String)"<return>");
    }

    @NotNull
    public String buildDocFromSuggestion(@NotNull String suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        return DocGenUtilKt.parseXmlCommentSuggestion(suggestion, this.getEmptyDocumentation()).getDocCode();
    }

    public boolean containsCompleteDoc(@NotNull String suggestion) {
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        return DocGenUtilKt.parseXmlCommentSuggestion(suggestion, this.getEmptyDocumentation()).isFinished();
    }

    public boolean useChatCodeContextProvider() {
        return true;
    }

    @Nullable
    public WdPromptCustomization promptCustomization(@NotNull Project project) {
        WdPromptCustomization.User user;
        PSString pSString;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AISystemLibraryPrompt aISystemLibraryPrompt = AISystemLibraryPromptService.Companion.getInstance(project).findPrompt("AIAssistant.WriteDocumentation.CSharp");
        if (aISystemLibraryPrompt != null && (pSString = aISystemLibraryPrompt.getContent()) != null) {
            PSString it = pSString;
            boolean bl = false;
            user = new WdPromptCustomization.User(it);
        } else {
            user = null;
        }
        return (WdPromptCustomization)user;
    }
}

