/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.lang;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapter;
import com.jetbrains.rdclient.daemon.FrontendMarkupAdapterListener;
import com.jetbrains.rdclient.daemon.FrontendMarkupContributor;
import com.jetbrains.rdclient.daemon.components.FrontendMarkupHost;
import com.jetbrains.rider.daemon.highlighters.injections.BackendInjectionInfo;
import com.jetbrains.rider.daemon.highlighters.injections.BackendInjectionInfoKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.intelliLang.inject.InjectedLanguage;
import org.intellij.plugins.intelliLang.inject.TemporaryPlacesRegistry;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/plugins/appender/lang/BackendInjectionManager;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createListener", "Lcom/jetbrains/rdclient/daemon/FrontendMarkupAdapterListener;", "findLanguageInjectionHost", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "injectionInfo", "Lcom/jetbrains/rider/daemon/highlighters/injections/BackendInjectionInfo;", "getBackendInjection", "editor", "Lcom/intellij/openapi/editor/Editor;", "isInjected", "", "registerDocument", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "document", "Lcom/intellij/openapi/editor/Document;", "registerInjection", "removeInjection", "updateInjection", "Companion", "intellij.rider.plugins.appender"})
public final class BackendInjectionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;

    public BackendInjectionManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final void registerDocument(@NotNull Lifetime lifetime, @NotNull Document document) {
        block0: {
            FrontendMarkupAdapter markupAdapter;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            FrontendMarkupContributor frontendMarkupContributor = FrontendMarkupHost.Companion.getMarkupContributor(this.project, document);
            FrontendMarkupAdapter frontendMarkupAdapter = markupAdapter = frontendMarkupContributor != null ? frontendMarkupContributor.getMarkupAdapter() : null;
            if (frontendMarkupAdapter == null) break block0;
            frontendMarkupAdapter.addListener(lifetime, this.createListener());
        }
    }

    public final boolean isInjected(@NotNull Editor editor2) {
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        return this.getBackendInjection(editor2) != null;
    }

    private final BackendInjectionInfo getBackendInjection(Editor editor2) {
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)editor2.getDocument(), (Project)this.project, (boolean)true);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx markupModel2 = (MarkupModelEx)markupModel;
        int offset = editor2.getCaretModel().getOffset();
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        markupModel2.processRangeHighlightersOverlappingWith(offset, offset, arg_0 -> BackendInjectionManager.getBackendInjection$lambda$0((Function1)new Function1<RangeHighlighterEx, Boolean>((Ref.ObjectRef<BackendInjectionInfo>)result2){
            final /* synthetic */ Ref.ObjectRef<BackendInjectionInfo> $result;
            {
                this.$result = $result;
                super(1);
            }

            @NotNull
            public final Boolean invoke(RangeHighlighterEx it) {
                Intrinsics.checkNotNull((Object)it);
                BackendInjectionInfo injectionInfo = BackendInjectionInfoKt.getInjectionInfo((RangeHighlighter)((RangeHighlighter)it));
                if (injectionInfo != null) {
                    this.$result.element = injectionInfo;
                }
                return this.$result.element == null;
            }
        }, arg_0));
        return (BackendInjectionInfo)result2.element;
    }

    public final void registerInjection(@NotNull BackendInjectionInfo injectionInfo) {
        Intrinsics.checkNotNullParameter((Object)injectionInfo, (String)"injectionInfo");
        if (!injectionInfo.isInjected()) {
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.findLanguageInjectionHost(injectionInfo);
            if (psiLanguageInjectionHost == null) {
                return;
            }
            PsiLanguageInjectionHost injectionHost = psiLanguageInjectionHost;
            Language language = injectionInfo.getLanguage();
            InjectedLanguage injectedLanguage = InjectedLanguage.create((String)(language != null ? language.getID() : null), (String)injectionInfo.getPrefix(), (String)injectionInfo.getSuffix(), (boolean)true);
            if (injectedLanguage == null) {
                return;
            }
            InjectedLanguage injectedLanguage2 = injectedLanguage;
            ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, injectionHost, injectedLanguage2){
                final /* synthetic */ BackendInjectionManager this$0;
                final /* synthetic */ PsiLanguageInjectionHost $injectionHost;
                final /* synthetic */ InjectedLanguage $injectedLanguage;
                {
                    this.this$0 = $receiver;
                    this.$injectionHost = $injectionHost;
                    this.$injectedLanguage = $injectedLanguage;
                    super(0);
                }

                public final void invoke() {
                    TemporaryPlacesRegistry.getInstance((Project)BackendInjectionManager.access$getProject$p(this.this$0)).addHost(this.$injectionHost, this.$injectedLanguage);
                }
            }), (int)1, null);
        }
    }

    public final void removeInjection(@NotNull BackendInjectionInfo injectionInfo) {
        Intrinsics.checkNotNullParameter((Object)injectionInfo, (String)"injectionInfo");
        if (!injectionInfo.isInjected()) {
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.findLanguageInjectionHost(injectionInfo);
            if (psiLanguageInjectionHost == null) {
                return;
            }
            PsiLanguageInjectionHost injectionHost = psiLanguageInjectionHost;
            ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, injectionHost){
                final /* synthetic */ BackendInjectionManager this$0;
                final /* synthetic */ PsiLanguageInjectionHost $injectionHost;
                {
                    this.this$0 = $receiver;
                    this.$injectionHost = $injectionHost;
                    super(0);
                }

                public final void invoke() {
                    TemporaryPlacesRegistry.getInstance((Project)BackendInjectionManager.access$getProject$p(this.this$0)).removeHost(this.$injectionHost);
                }
            }), (int)1, null);
        }
    }

    public final void updateInjection(@NotNull BackendInjectionInfo injectionInfo) {
        Intrinsics.checkNotNullParameter((Object)injectionInfo, (String)"injectionInfo");
        if (!injectionInfo.isInjected()) {
            PsiLanguageInjectionHost psiLanguageInjectionHost = this.findLanguageInjectionHost(injectionInfo);
            if (psiLanguageInjectionHost == null) {
                return;
            }
            PsiLanguageInjectionHost injectionHost = psiLanguageInjectionHost;
            Language language = injectionInfo.getLanguage();
            InjectedLanguage injectedLanguage = InjectedLanguage.create((String)(language != null ? language.getID() : null), (String)injectionInfo.getPrefix(), (String)injectionInfo.getSuffix(), (boolean)true);
            if (injectedLanguage == null) {
                return;
            }
            InjectedLanguage newInjectedLanguage = injectedLanguage;
            TemporaryPlacesRegistry temporaryPlacesRegistry = TemporaryPlacesRegistry.getInstance((Project)this.project);
            InjectedLanguage currentInjectedInfo = temporaryPlacesRegistry.getLanguageFor(injectionHost, injectionHost.getContainingFile());
            if (!(currentInjectedInfo != null && Intrinsics.areEqual((Object)currentInjectedInfo.getID(), (Object)newInjectedLanguage.getID()) && Intrinsics.areEqual((Object)currentInjectedInfo.getPrefix(), (Object)newInjectedLanguage.getPrefix()) && Intrinsics.areEqual((Object)currentInjectedInfo.getSuffix(), (Object)newInjectedLanguage.getSuffix()))) {
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(temporaryPlacesRegistry, injectionHost, newInjectedLanguage){
                    final /* synthetic */ TemporaryPlacesRegistry $temporaryPlacesRegistry;
                    final /* synthetic */ PsiLanguageInjectionHost $injectionHost;
                    final /* synthetic */ InjectedLanguage $newInjectedLanguage;
                    {
                        this.$temporaryPlacesRegistry = $temporaryPlacesRegistry;
                        this.$injectionHost = $injectionHost;
                        this.$newInjectedLanguage = $newInjectedLanguage;
                        super(0);
                    }

                    public final void invoke() {
                        this.$temporaryPlacesRegistry.addHost(this.$injectionHost, this.$newInjectedLanguage);
                    }
                }), (int)1, null);
            }
        }
    }

    private final PsiLanguageInjectionHost findLanguageInjectionHost(BackendInjectionInfo injectionInfo) {
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(injectionInfo.getDocument());
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        PsiLanguageInjectionHost psiLanguageInjectionHost = (PsiLanguageInjectionHost)PsiTreeUtil.findElementOfClassAtRange((PsiFile)psiFile2, (int)injectionInfo.getStartOffset(), (int)injectionInfo.getEndOffset(), PsiLanguageInjectionHost.class);
        if (psiLanguageInjectionHost == null) {
            return null;
        }
        PsiLanguageInjectionHost element = psiLanguageInjectionHost;
        if (Intrinsics.areEqual((Object)element.getTextRange(), (Object)injectionInfo.getTextRange())) {
            return element;
        }
        return null;
    }

    private final FrontendMarkupAdapterListener createListener() {
        return new FrontendMarkupAdapterListener(this){
            final /* synthetic */ BackendInjectionManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void afterAdded(@NotNull RangeHighlighterEx highlighter) {
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                BackendInjectionInfo backendInjectionInfo = BackendInjectionInfoKt.getInjectionInfo((RangeHighlighter)((RangeHighlighter)highlighter));
                if (backendInjectionInfo == null) {
                    return;
                }
                BackendInjectionInfo injectionInfo = backendInjectionInfo;
                if (injectionInfo.getLanguage() == null) {
                    this.this$0.removeInjection(injectionInfo);
                } else {
                    this.this$0.registerInjection(injectionInfo);
                }
            }

            public void beforeRemoved(@NotNull RangeHighlighterEx highlighter) {
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                BackendInjectionInfo backendInjectionInfo = BackendInjectionInfoKt.getInjectionInfo((RangeHighlighter)((RangeHighlighter)highlighter));
                if (backendInjectionInfo == null) {
                    return;
                }
                BackendInjectionInfo injectionInfo = backendInjectionInfo;
                this.this$0.removeInjection(injectionInfo);
            }

            public void afterUpdated(@NotNull RangeHighlighterEx highlighter) {
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                BackendInjectionInfo backendInjectionInfo = BackendInjectionInfoKt.getInjectionInfo((RangeHighlighter)((RangeHighlighter)highlighter));
                if (backendInjectionInfo == null) {
                    return;
                }
                BackendInjectionInfo injectionInfo = backendInjectionInfo;
                if (injectionInfo.getLanguage() == null) {
                    this.this$0.removeInjection(injectionInfo);
                } else {
                    this.this$0.updateInjection(injectionInfo);
                }
            }
        };
    }

    private static final boolean getBackendInjection$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Project access$getProject$p(BackendInjectionManager $this) {
        return $this.project;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/appender/lang/BackendInjectionManager$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/appender/lang/BackendInjectionManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.appender"})
    @SourceDebugExtension(value={"SMAP\nBackendInjectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendInjectionManager.kt\ncom/jetbrains/rider/plugins/appender/lang/BackendInjectionManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,141:1\n31#2,2:142\n*S KotlinDebug\n*F\n+ 1 BackendInjectionManager.kt\ncom/jetbrains/rider/plugins/appender/lang/BackendInjectionManager$Companion\n*L\n27#1:142,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BackendInjectionManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<BackendInjectionManager> serviceClass$iv = BackendInjectionManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (BackendInjectionManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

