/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.javascript.nodejs;

import com.intellij.javascript.nodejs.packageJson.notification.PackageJsonNotifierConfiguration;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.util.ApplicationKt;
import com.intellij.util.ThreeState;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rd.util.reactive.OptProperty;
import com.jetbrains.rd.util.reactive.SourceExKt;
import com.jetbrains.rider.plugins.appender.javascript.RiderProjectModelWebFilesCollector;
import com.jetbrains.rider.plugins.appender.javascript.nodejs.RiderPackageJsonConfigurator;
import com.jetbrains.rider.plugins.appender.javascript.nodejs.RiderPackageJsonConfiguratorHandler;
import com.jetbrains.rider.projectView.projectTemplates.utils.ExtensionsKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import com.jetbrains.rider.workspaceModel.WorkspaceUserModelUpdater;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\nH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rider/plugins/appender/javascript/nodejs/RiderPackageJsonConfigurator;", "Lcom/intellij/javascript/nodejs/packageJson/notification/PackageJsonNotifierConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "detectPackageJsonFiles", "Lorg/jetbrains/concurrency/Promise;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "findInDirectory", "file", "Ljava/io/File;", "findInProject", "projectEntity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "isEssential", "", "packageJson", "isNpmPackageJson", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nRiderPackageJsonConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderPackageJsonConfigurator.kt\ncom/jetbrains/rider/plugins/appender/javascript/nodejs/RiderPackageJsonConfigurator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1#2:95\n1747#3,3:96\n*S KotlinDebug\n*F\n+ 1 RiderPackageJsonConfigurator.kt\ncom/jetbrains/rider/plugins/appender/javascript/nodejs/RiderPackageJsonConfigurator\n*L\n82#1:96,3\n*E\n"})
public final class RiderPackageJsonConfigurator
implements PackageJsonNotifierConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final ExtensionPointName<RiderPackageJsonConfiguratorHandler> EP_NAME = ExtensionPointName.Companion.create("JavaScript.packageJson.configuration.handler");

    public RiderPackageJsonConfigurator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public Promise<List<VirtualFile>> detectPackageJsonFiles() {
        if (this.project.isDefault()) {
            return Promises.resolvedPromise((Object)CollectionsKt.emptyList());
        }
        AsyncPromise result2 = new AsyncPromise();
        ApplicationKt.getApplication().invokeLater(() -> RiderPackageJsonConfigurator.detectPackageJsonFiles$lambda$0(this, result2));
        return (Promise)result2;
    }

    private final VirtualFile findInDirectory(File file) {
        if (!file.isDirectory()) {
            return null;
        }
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile directory = virtualFile;
        while (!directory.is(VFileProperty.SYMLINK)) {
            VirtualFile[] virtualFileArray = directory.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            VirtualFile virtualFile2 = (VirtualFile)ArraysKt.singleOrNull((Object[])virtualFileArray);
            boolean bl = virtualFile2 != null ? virtualFile2.isDirectory() : false;
            if (!bl) break;
            Intrinsics.checkNotNullExpressionValue((Object)directory.getChildren()[0], (String)"get(...)");
        }
        return PackageJsonUtil.findChildPackageJsonFile((VirtualFile)directory);
    }

    private final VirtualFile findInProject(ProjectModelEntity projectEntity) {
        VirtualFile packageJsonInProject;
        boolean bl = ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)projectEntity);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-RiderPackageJsonConfigurator$findInProject$22 = false;
            String $i$a$-assert-RiderPackageJsonConfigurator$findInProject$22 = "Entity should be a project entity";
            throw new AssertionError((Object)$i$a$-assert-RiderPackageJsonConfigurator$findInProject$22);
        }
        VirtualFile virtualFile = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)projectEntity);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile directory = virtualFile;
        VirtualFile virtualFile2 = packageJsonInProject = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)directory);
        if (virtualFile2 != null) {
            return virtualFile2;
        }
        return PackageJsonUtil.findChildPackageJsonFile((VirtualFile)directory.findChild("ClientApp"));
    }

    public boolean isEssential(@NotNull VirtualFile packageJson) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
            if (this.project.isDefault()) {
                return false;
            }
            ProjectModelEntity projectModelEntity = (ProjectModelEntity)CollectionsKt.firstOrNull((List)WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.project), (VirtualFile)packageJson, (Project)this.project));
            if (projectModelEntity == null) {
                return false;
            }
            ProjectModelEntity fileNode = projectModelEntity;
            ProjectModelEntity projectNode2 = ExtensionsKt.findParent((ProjectModelEntity)fileNode, (Function1)isEssential.projectNode.1.INSTANCE);
            if (projectNode2 != null && Intrinsics.areEqual((Object)this.findInProject(projectNode2), (Object)packageJson)) {
                return true;
            }
            WorkspaceUserModelUpdater store = WorkspaceUserModelUpdater.Companion.getInstance(this.project);
            Iterable $this$any$iv = store.getExplicitIncludes();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    File it = (File)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)packageJson, (Object)this.findInDirectory(it))) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean isNpmPackageJson(@NotNull VirtualFile packageJson) {
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        if (this.project.isDefault()) {
            return false;
        }
        for (RiderPackageJsonConfiguratorHandler handler : EP_NAME.getExtensionList((AreaInstance)this.project)) {
            ThreeState isPackageNpmJson = handler.isNpmPackageJson(packageJson);
            if (isPackageNpmJson == ThreeState.UNSURE) continue;
            return isPackageNpmJson.toBoolean();
        }
        return true;
    }

    private static final void detectPackageJsonFiles$lambda$0(RiderPackageJsonConfigurator this$0, AsyncPromise $result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        if (this$0.project.isDisposed()) {
            $result.setResult((Object)CollectionsKt.emptyList());
            return;
        }
        WorkspaceUserModelUpdater store = WorkspaceUserModelUpdater.Companion.getInstance(this$0.project);
        RiderProjectModelWebFilesCollector visitor2 = new RiderProjectModelWebFilesCollector(this$0.project, store);
        OptProperty<List<VirtualFile>> trigger2 = visitor2.collectAllFiles((Function1<? super File, ? extends VirtualFile>)((Function1)new Function1<File, VirtualFile>((Object)this$0){

            @Nullable
            public final VirtualFile invoke(@NotNull File p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RiderPackageJsonConfigurator.access$findInDirectory((RiderPackageJsonConfigurator)this.receiver, p0);
            }
        }), (Function1<? super ProjectModelEntity, ? extends VirtualFile>)((Function1)new Function1<ProjectModelEntity, VirtualFile>((Object)this$0){

            @Nullable
            public final VirtualFile invoke(@NotNull ProjectModelEntity p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return RiderPackageJsonConfigurator.access$findInProject((RiderPackageJsonConfigurator)this.receiver, p0);
            }
        }));
        SourceExKt.adviseOnce((ISource)((ISource)trigger2), (Lifetime)ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this$0.project)), (Function1)((Function1)new Function1<List<? extends VirtualFile>, Unit>((AsyncPromise<List<VirtualFile>>)$result){
            final /* synthetic */ AsyncPromise<List<VirtualFile>> $result;
            {
                this.$result = $result;
                super(1);
            }

            public final void invoke(@NotNull List<? extends VirtualFile> it) {
                Intrinsics.checkNotNullParameter(it, (String)"it");
                this.$result.setResult(it);
            }
        }));
    }

    public static final /* synthetic */ VirtualFile access$findInDirectory(RiderPackageJsonConfigurator $this, File file) {
        return $this.findInDirectory(file);
    }

    public static final /* synthetic */ VirtualFile access$findInProject(RiderPackageJsonConfigurator $this, ProjectModelEntity projectEntity) {
        return $this.findInProject(projectEntity);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rider/plugins/appender/javascript/nodejs/RiderPackageJsonConfigurator$Companion;", "", "()V", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/rider/plugins/appender/javascript/nodejs/RiderPackageJsonConfiguratorHandler;", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

