/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.javascript;

import com.intellij.javascript.nodejs.library.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.rd.platform.util.idea.LifetimedService;
import com.jetbrains.rider.ideaInterop.vfs.VfsIterator;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.model.RdProjectType;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelEvents;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutorService;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u0002J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/rider/plugins/appender/javascript/NodeModulesCollector;", "Lcom/jetbrains/rd/platform/util/idea/LifetimedService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "executor", "Ljava/util/concurrent/ExecutorService;", "Lorg/jetbrains/annotations/NotNull;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "visitedNodeModuleDirs", "Ljava/util/HashSet;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lkotlin/collections/HashSet;", "visitedProjectRoots", "processCreatedDirectory", "", "dir", "processProject", "entity", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "processSolution", "tryAddNodeModules", "", "file", "tryAddYarnFile", "Activity", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nNodeModulesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeModulesCollector.kt\ncom/jetbrains/rider/plugins/appender/javascript/NodeModulesCollector\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n13#2:133\n13#3:134\n1855#4,2:135\n*S KotlinDebug\n*F\n+ 1 NodeModulesCollector.kt\ncom/jetbrains/rider/plugins/appender/javascript/NodeModulesCollector\n*L\n35#1:133\n35#1:134\n54#1:135,2\n*E\n"})
public final class NodeModulesCollector
extends LifetimedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final HashSet<VirtualFile> visitedProjectRoots;
    @NotNull
    private final HashSet<VirtualFile> visitedNodeModuleDirs;
    @NotNull
    private final Logger logger;
    @NotNull
    private final ExecutorService executor;

    public NodeModulesCollector(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.visitedProjectRoots = new HashSet();
        this.visitedNodeModuleDirs = new HashSet();
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NodeModulesCollector.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        ExecutorService executorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"NodeModulesCollector", (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"createBoundedApplicationPoolExecutor(...)");
        this.executor = executorService;
        WorkspaceModelEvents.Companion.getInstance(this.project).getAddSignal().advise(this.getServiceLifetime(), (Function1)new Function1<WorkspaceModelEvents.AddEntityEvent, Unit>(){

            public final void invoke(@NotNull WorkspaceModelEvents.AddEntityEvent addEntityEvent) {
                Intrinsics.checkNotNullParameter((Object)addEntityEvent, (String)"<name for destructuring parameter 0>");
                ProjectModelEntity entity = addEntityEvent.component2();
                if (ProjectModelEntityExtensionsKt.isSolution((ProjectModelEntity)entity)) {
                    this.processSolution(entity);
                }
                if (ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)entity)) {
                    this.processProject(entity);
                }
                if (ProjectModelEntityExtensionsKt.isProjectFile((ProjectModelEntity)entity) && YarnPnpManager.isPnpJsFileName((CharSequence)entity.getName())) {
                    VirtualFile virtualFile;
                    VirtualFileUrl virtualFileUrl = entity.getUrl();
                    Object object = virtualFile = virtualFileUrl != null ? VirtualFileUrls.getVirtualFile((VirtualFileUrl)virtualFileUrl) : null;
                    if (virtualFile != null) {
                        this.tryAddYarnFile(virtualFile);
                    }
                }
            }
        });
        ProjectModelEntity projectModelEntity = WorkspaceModelExtensionsKt.getSolutionEntity((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.project));
        if (projectModelEntity != null) {
            ProjectModelEntity it = projectModelEntity;
            boolean bl = false;
            this.processSolution(it);
        }
        Iterable $this$forEach$iv = WorkspaceModelExtensionsKt.findProjects((WorkspaceModel)WorkspaceModel.Companion.getInstance(this.project));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProjectModelEntity it = (ProjectModelEntity)element$iv;
            boolean bl = false;
            this.processProject(it);
        }
        VirtualFileManager.getInstance().addAsyncFileListener(arg_0 -> NodeModulesCollector._init_$lambda$2(this, arg_0), (Disposable)this);
    }

    public final void processSolution(@NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        boolean bl = ProjectModelEntityExtensionsKt.isSolution((ProjectModelEntity)entity);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        VirtualFile virtualFile = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)entity);
        if (virtualFile == null) {
            return;
        }
        VirtualFile root = virtualFile;
        this.executor.submit(() -> NodeModulesCollector.processSolution$lambda$3(root, this));
    }

    public final void processProject(@NotNull ProjectModelEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        boolean bl = ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)entity);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = entity.getDescriptor();
        Intrinsics.checkNotNull((Object)rdProjectModelItemDescriptor, (String)"null cannot be cast to non-null type com.jetbrains.rider.model.RdProjectDescriptor");
        if (((RdProjectDescriptor)rdProjectModelItemDescriptor).getSpecificType() != RdProjectType.Web) {
            return;
        }
        VirtualFile virtualFile = ProjectModelEntityExtensionsKt.getVirtualFileAsContentRoot((ProjectModelEntity)entity);
        if (virtualFile == null) {
            return;
        }
        VirtualFile root = virtualFile;
        if (!this.visitedProjectRoots.add(root)) {
            return;
        }
        this.executor.submit(() -> NodeModulesCollector.processProject$lambda$6(this, root));
    }

    private final void processCreatedDirectory(VirtualFile dir) {
        if (dir == null) {
            return;
        }
        if (!Companion.isNodeModules(dir)) {
            return;
        }
        if (BaseProjectDirectories.Companion.getInstance(this.project).contains(dir)) {
            this.tryAddNodeModules(dir);
        }
    }

    private final boolean tryAddNodeModules(VirtualFile file) {
        if (!Companion.isNodeModules(file)) {
            return false;
        }
        if (this.visitedNodeModuleDirs.add(file)) {
            this.logger.info("Register node_modules folder: " + file);
            NodeModulesDirectoryManager.Companion.getInstance(this.project).addNodeModulesDirs(CollectionsKt.listOf((Object)file), new NodeModulesDirectoryManager.Options(true));
        }
        return true;
    }

    private final boolean tryAddYarnFile(VirtualFile file) {
        if (YarnPnpManager.isPnpJsFile((VirtualFile)file)) {
            this.logger.info("Register yarn pnp file: " + file);
            YarnPnpManager.getInstance((Project)this.project).addPnpJsFile(file);
            return true;
        }
        return false;
    }

    private static final AsyncFileListener.ChangeApplier _init_$lambda$2(NodeModulesCollector this$0, List events) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)events, (String)"events");
        return new AsyncFileListener.ChangeApplier(events, this$0){
            final /* synthetic */ List<? extends VFileEvent> $events;
            final /* synthetic */ NodeModulesCollector this$0;
            {
                this.$events = $events;
                this.this$0 = $receiver;
            }

            public void afterVfsChange() {
                for (VFileEvent vFileEvent : this.$events) {
                    if (!(vFileEvent instanceof VFileCreateEvent) || !((VFileCreateEvent)vFileEvent).isDirectory()) continue;
                    try {
                        NodeModulesCollector.access$processCreatedDirectory(this.this$0, ((VFileCreateEvent)vFileEvent).getFile());
                    }
                    catch (Exception ex) {
                        NodeModulesCollector.access$getLogger$p(this.this$0).error((Throwable)ex);
                    }
                }
            }
        };
    }

    private static final void processSolution$lambda$3(VirtualFile $root, NodeModulesCollector this$0) {
        Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        VirtualFile[] virtualFileArray = $root.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
        for (VirtualFile child : virtualFileArray) {
            Intrinsics.checkNotNull((Object)child);
            this$0.tryAddNodeModules(child);
            this$0.tryAddYarnFile(child);
        }
    }

    private static final boolean processProject$lambda$6$lambda$4(NodeModulesCollector this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.tryAddYarnFile(it);
    }

    private static final boolean processProject$lambda$6$lambda$5(NodeModulesCollector this$0, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !this$0.tryAddNodeModules(it);
    }

    private static final void processProject$lambda$6(NodeModulesCollector this$0, VirtualFile $root) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$root, (String)"$root");
            VfsIterator vfsIterator = VfsIterator.Companion.create(this$0.project);
            if (vfsIterator == null) break block0;
            vfsIterator.visitChildrenRecursively($root, arg_0 -> NodeModulesCollector.processProject$lambda$6$lambda$4(this$0, arg_0), arg_0 -> NodeModulesCollector.processProject$lambda$6$lambda$5(this$0, arg_0));
        }
    }

    public static final /* synthetic */ void access$processCreatedDirectory(NodeModulesCollector $this, VirtualFile dir) {
        $this.processCreatedDirectory(dir);
    }

    public static final /* synthetic */ Logger access$getLogger$p(NodeModulesCollector $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/appender/javascript/NodeModulesCollector$Activity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider.plugins.appender"})
    @SourceDebugExtension(value={"SMAP\nNodeModulesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeModulesCollector.kt\ncom/jetbrains/rider/plugins/appender/javascript/NodeModulesCollector$Activity\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,132:1\n31#2,2:133\n*S KotlinDebug\n*F\n+ 1 NodeModulesCollector.kt\ncom/jetbrains/rider/plugins/appender/javascript/NodeModulesCollector$Activity\n*L\n129#1:133,2\n*E\n"})
    public static final class Activity
    implements ProjectActivity,
    DumbAware {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<NodeModulesCollector> serviceClass$iv = NodeModulesCollector.class;
            if ($this$service$iv.getService(serviceClass$iv) == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/appender/javascript/NodeModulesCollector$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/appender/javascript/NodeModulesCollector;", "project", "Lcom/intellij/openapi/project/Project;", "isNodeModules", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.rider.plugins.appender"})
    @SourceDebugExtension(value={"SMAP\nNodeModulesCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeModulesCollector.kt\ncom/jetbrains/rider/plugins/appender/javascript/NodeModulesCollector$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,132:1\n31#2,2:133\n*S KotlinDebug\n*F\n+ 1 NodeModulesCollector.kt\ncom/jetbrains/rider/plugins/appender/javascript/NodeModulesCollector$Companion\n*L\n29#1:133,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final NodeModulesCollector getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<NodeModulesCollector> serviceClass$iv = NodeModulesCollector.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (NodeModulesCollector)((Object)object);
        }

        public final boolean isNodeModules(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return file.isDirectory() && StringsKt.equals((String)file.getName(), (String)"node_modules", (boolean)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

