/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.javascript;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationProducer;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.execution.ParametersListUtil;
import com.jetbrains.rider.model.Key;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.run.AutoGeneratedRunConfigurationManager;
import com.jetbrains.rider.run.ExternalRunConfigurationGeneratorExtension;
import com.jetbrains.rider.run.configurations.RunConfigurationHelper;
import com.jetbrains.rider.run.configurations.RunnableProjectKinds;
import com.jetbrains.rider.run.configurations.project.RunnableProjectExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J8\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/appender/javascript/EcmaScriptProjectRunConfigurationGenerator;", "Lcom/jetbrains/rider/run/ExternalRunConfigurationGeneratorExtension;", "()V", "generateConfigurationForProject", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "runManager", "Lcom/intellij/execution/RunManager;", "generateConfigurations", "", "Lkotlin/Pair;", "runnableProjects", "autoGeneratedRunConfigurationManager", "Lcom/jetbrains/rider/run/AutoGeneratedRunConfigurationManager;", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nEcmaScriptProjectRunConfigurationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcmaScriptProjectRunConfigurationGenerator.kt\ncom/jetbrains/rider/plugins/appender/javascript/EcmaScriptProjectRunConfigurationGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,81:1\n766#2:82\n857#2,2:83\n1603#2,9:85\n1855#2:94\n1856#2:96\n1612#2:97\n1#3:95\n23#4:98\n23#4:99\n23#4:100\n*S KotlinDebug\n*F\n+ 1 EcmaScriptProjectRunConfigurationGenerator.kt\ncom/jetbrains/rider/plugins/appender/javascript/EcmaScriptProjectRunConfigurationGenerator\n*L\n26#1:82\n26#1:83,2\n32#1:85,9\n32#1:94\n32#1:96\n32#1:97\n32#1:95\n43#1:98\n49#1:99\n57#1:100\n*E\n"})
public final class EcmaScriptProjectRunConfigurationGenerator
implements ExternalRunConfigurationGeneratorExtension {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Pair<RunnableProject, RunnerAndConfigurationSettings>> generateConfigurations(@NotNull List<RunnableProject> runnableProjects, @NotNull AutoGeneratedRunConfigurationManager autoGeneratedRunConfigurationManager, @NotNull RunManager runManager) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(runnableProjects, (String)"runnableProjects");
        Intrinsics.checkNotNullParameter((Object)autoGeneratedRunConfigurationManager, (String)"autoGeneratedRunConfigurationManager");
        Intrinsics.checkNotNullParameter((Object)runManager, (String)"runManager");
        Iterable $this$filter$iv = runnableProjects;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RunnableProject it = (RunnableProject)element$iv$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)it.getKind(), (Object)RunnableProjectKinds.INSTANCE.getEcmaScript()) && !RunConfigurationHelper.INSTANCE.hasConfigurationForNameAndTypeId(runManager, it.getName(), NpmConfigurationType.getInstance().getId()) && !autoGeneratedRunConfigurationManager.hasRunConfigurationEverBeenGenerated(it.getProjectFilePath(), it.getKind());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List applicableProjects = (List)destination$iv$iv;
        Iterable $this$mapNotNull$iv = applicableProjects;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RunnableProject it = (RunnableProject)element$iv$iv;
            boolean bl3 = false;
            if (this.generateConfigurationForProject(it, runManager) == null) {
                pair = null;
            } else {
                RunnerAndConfigurationSettings generatedConfiguration;
                runManager.addConfiguration(generatedConfiguration);
                autoGeneratedRunConfigurationManager.markProjectAsAutoGenerated(it.getProjectFilePath(), it.getKind());
                pair = TuplesKt.to((Object)it, (Object)generatedConfiguration);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final RunnerAndConfigurationSettings generateConfigurationForProject(RunnableProject runnableProject, RunManager runManager) {
        RunnerAndConfigurationSettings runnerAndConfigurationSettings;
        NpmCommand npmCommand;
        String string = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.StartupCommand);
        if (string == null) {
            return null;
        }
        String startupCommand = string;
        if (!StringsKt.startsWith((String)startupCommand, (String)"npm", (boolean)true)) {
            EcmaScriptProjectRunConfigurationGenerator $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(EcmaScriptProjectRunConfigurationGenerator.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug(runnableProject.getName() + ": startup command should start with `npm`");
            return null;
        }
        List list2 = ParametersListUtil.parse((String)startupCommand);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parse(...)");
        List parameters = list2;
        if (parameters.size() == 1) {
            EcmaScriptProjectRunConfigurationGenerator $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(EcmaScriptProjectRunConfigurationGenerator.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug(runnableProject.getName() + ": unable to find command");
            return null;
        }
        String $i$f$thisLogger = StringUtil.toLowerCase((String)((String)parameters.get(1)));
        if (Intrinsics.areEqual((Object)$i$f$thisLogger, (Object)"start")) {
            npmCommand = NpmCommand.START;
        } else if (Intrinsics.areEqual((Object)$i$f$thisLogger, (Object)"run")) {
            npmCommand = NpmCommand.RUN_SCRIPT;
        } else {
            EcmaScriptProjectRunConfigurationGenerator $this$thisLogger$iv = this;
            boolean $i$f$thisLogger2 = false;
            Logger logger = Logger.getInstance(EcmaScriptProjectRunConfigurationGenerator.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug(runnableProject.getName() + ": npm command " + parameters.get(1) + " isn't supported");
            return null;
        }
        NpmCommand npmCommand2 = npmCommand;
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(runnableProject.getProjectFilePath());
        VirtualFile virtualFile2 = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)(virtualFile != null ? virtualFile.getParent() : null));
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile packageJson = virtualFile2;
        String string2 = runnableProject.getName();
        NpmConfigurationType npmConfigurationType = NpmConfigurationType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)npmConfigurationType, (String)"getInstance(...)");
        RunnerAndConfigurationSettings $this$generateConfigurationForProject_u24lambda_u242 = runnerAndConfigurationSettings = runManager.createConfiguration(string2, (ConfigurationFactory)npmConfigurationType);
        boolean bl = false;
        RunConfiguration runConfiguration = $this$generateConfigurationForProject_u24lambda_u242.getConfiguration();
        Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration");
        NpmRunConfiguration runConfiguration2 = (NpmRunConfiguration)runConfiguration;
        NpmRunSettings.Builder builder = runConfiguration2.getRunSettings().toBuilder().setPackageJsonPath(packageJson.getPath()).setCommand(npmCommand2);
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"setCommand(...)");
        NpmRunSettings.Builder builder2 = builder;
        if (parameters.size() > 2) {
            builder2.setScriptNames(parameters.subList(2, parameters.size()));
        }
        NpmRunConfigurationProducer.setupConfigurationFromSettings((NpmRunConfiguration)runConfiguration2, (NpmRunSettings)builder2.build());
        RunnerAndConfigurationSettings defaultConfiguration = runnerAndConfigurationSettings;
        defaultConfiguration.setName(runnableProject.getName() + ": " + npmCommand2.getCliOption());
        return defaultConfiguration;
    }
}

