/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.featuretrainer.lessons;

import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.jetbrains.rider.plugins.appender.featuretrainer.RiderLessonsBundle;
import com.jetbrains.rider.plugins.appender.featuretrainer.lessons.CSharpRenameLesson;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.LessonContext;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.dsl.LessonUtil;
import training.dsl.LessonUtilKt;
import training.dsl.TaskContext;
import training.dsl.TaskRuntimeContext;
import training.dsl.TaskTestContext;
import training.learn.LessonsBundle;
import training.learn.course.KLesson;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005H\u0002R \u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R%\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rider/plugins/appender/featuretrainer/lessons/CSharpRenameLesson;", "Ltraining/learn/course/KLesson;", "()V", "helpLinks", "", "", "getHelpLinks", "()Ljava/util/Map;", "initialName", "lessonContent", "Lkotlin/Function1;", "Ltraining/dsl/LessonContext;", "", "Lkotlin/ExtensionFunctionType;", "getLessonContent", "()Lkotlin/jvm/functions/Function1;", "sample", "Ltraining/dsl/LessonSample;", "template", "replaceTemplate", "name", "intellij.rider.plugins.appender"})
public final class CSharpRenameLesson
extends KLesson {
    @NotNull
    private final String initialName;
    @NotNull
    private final String template;
    @NotNull
    private final LessonSample sample;
    @NotNull
    private final Function1<LessonContext, Unit> lessonContent;

    public CSharpRenameLesson() {
        super("Refactorings.Rename", LessonsBundle.INSTANCE.message("rename.lesson.name", new Object[0]));
        this.initialName = "Name";
        this.template = "// ReSharper disable CheckNamespace\n// ReSharper disable UnusedType.Global\n// ReSharper disable ClassNeverInstantiated.Local\n// ReSharper disable UnusedAutoPropertyAccessor.Local\n#pragma warning disable CS8618\n\nusing System;\n\ninternal class Sample\n{\n    private Sample(Person person, Car car)\n    {\n        Console.WriteLine($\"Look, {person.Name} has a new {car.<caret><name>}.\");\n    }\n\n    private class Person\n    {\n        public string Name { get; set; }\n    }\n\n    private class Car\n    {\n        public string <name> { get; set; }\n    }\n}    \n";
        this.sample = LessonSampleKt.parseLessonSample((String)this.replaceTemplate(this.initialName));
        this.lessonContent = (Function1)new Function1<LessonContext, Unit>(this){
            final /* synthetic */ CSharpRenameLesson this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull LessonContext $this$null) {
                Intrinsics.checkNotNullParameter((Object)$this$null, (String)"$this$null");
                String newNameExample = "BrandName";
                LessonContext.prepareSample$default((LessonContext)$this$null, (LessonSample)CSharpRenameLesson.access$getSample$p(this.this$0), (boolean)false, (int)2, null);
                LessonUtilKt.showWarningIfInplaceRefactoringsDisabled((LessonContext)$this$null);
                Ref.ObjectRef startId = new Ref.ObjectRef();
                $this$null.task("RenameElement", (Function2)new Function2<TaskContext, String, Unit>((Ref.ObjectRef<TaskContext.TaskId>)startId, this.this$0){
                    final /* synthetic */ Ref.ObjectRef<TaskContext.TaskId> $startId;
                    final /* synthetic */ CSharpRenameLesson this$0;
                    {
                        this.$startId = $startId;
                        this.this$0 = $receiver;
                        super(2);
                    }

                    public final void invoke(@NotNull TaskContext $this$task, @NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$startId.element = $this$task.getTaskId();
                        Object[] objectArray = new Object[]{$this$task.action(it), $this$task.code(CSharpRenameLesson.access$getInitialName$p(this.this$0))};
                        TaskContext.text$default((TaskContext)$this$task, (String)RiderLessonsBundle.INSTANCE.message("rename.press.rename", objectArray), null, (int)2, null);
                        objectArray = new String[]{it};
                        $this$task.triggers((String[])objectArray);
                        $this$task.proposeRestore((Function1)new Function1<TaskRuntimeContext, TaskContext.RestoreNotification>(this.this$0){
                            final /* synthetic */ CSharpRenameLesson this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @Nullable
                            public final TaskContext.RestoreNotification invoke(@NotNull TaskRuntimeContext $this$proposeRestore) {
                                Intrinsics.checkNotNullParameter((Object)$this$proposeRestore, (String)"$this$proposeRestore");
                                return LessonUtil.checkExpectedStateOfEditor$default((LessonUtil)LessonUtil.INSTANCE, (TaskRuntimeContext)$this$proposeRestore, (LessonSample)CSharpRenameLesson.access$getSample$p(this.this$0), (boolean)false, null, (int)4, null);
                            }
                        });
                        TaskContext.test$default((TaskContext)$this$task, (boolean)false, (Function1)((Function1)new Function1<TaskTestContext, Unit>(it){
                            final /* synthetic */ String $it;
                            {
                                this.$it = $it;
                                super(1);
                            }

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
                                String[] stringArray = new String[]{this.$it};
                                $this$test.actions(stringArray);
                            }
                        }), (int)1, null);
                    }
                });
                $this$null.task((Function1)lessonContent.2.INSTANCE);
                $this$null.task((Function1)new Function1<TaskContext, Unit>(newNameExample, (Ref.ObjectRef<TaskContext.TaskId>)startId, this.this$0){
                    final /* synthetic */ String $newNameExample;
                    final /* synthetic */ Ref.ObjectRef<TaskContext.TaskId> $startId;
                    final /* synthetic */ CSharpRenameLesson this$0;
                    {
                        this.$newNameExample = $newNameExample;
                        this.$startId = $startId;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull TaskContext $this$task) {
                        TaskContext.TaskId taskId;
                        Intrinsics.checkNotNullParameter((Object)$this$task, (String)"$this$task");
                        $this$task.stateCheck((Function1)new Function1<TaskRuntimeContext, Boolean>(this.this$0){
                            final /* synthetic */ CSharpRenameLesson this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$stateCheck) {
                                Intrinsics.checkNotNullParameter((Object)$this$stateCheck, (String)"$this$stateCheck");
                                return $this$stateCheck.getFocusOwner() instanceof EditorComponentImpl && !Intrinsics.areEqual((Object)$this$stateCheck.getEditor().getDocument().getText(), (Object)CSharpRenameLesson.access$getSample$p(this.this$0).getText());
                            }
                        });
                        Object[] objectArray = new Object[]{$this$task.code(this.$newNameExample), LessonUtil.INSTANCE.rawEnter()};
                        TaskContext.text$default((TaskContext)$this$task, (String)RiderLessonsBundle.INSTANCE.message("rename.type.new.name", objectArray), null, (int)2, null);
                        if (this.$startId.element == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"startId");
                            taskId = null;
                        } else {
                            taskId = (TaskContext.TaskId)this.$startId.element;
                        }
                        LessonUtilKt.restoreAfterStateBecomeFalse((TaskContext)$this$task, (TaskContext.TaskId)taskId, (Function1)((Function1)new Function1<TaskRuntimeContext, Boolean>(this.this$0){
                            final /* synthetic */ CSharpRenameLesson this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull TaskRuntimeContext $this$restoreAfterStateBecomeFalse) {
                                Intrinsics.checkNotNullParameter((Object)$this$restoreAfterStateBecomeFalse, (String)"$this$restoreAfterStateBecomeFalse");
                                return $this$restoreAfterStateBecomeFalse.getFocusOwner() instanceof EditorComponentImpl && Intrinsics.areEqual((Object)$this$restoreAfterStateBecomeFalse.getEditor().getDocument().getText(), (Object)CSharpRenameLesson.access$getSample$p(this.this$0).getText());
                            }
                        }));
                        $this$task.test(false, (Function1)new Function1<TaskTestContext, Unit>(this.$newNameExample){
                            final /* synthetic */ String $newNameExample;
                            {
                                this.$newNameExample = $newNameExample;
                                super(1);
                            }

                            public final void invoke(@NotNull TaskTestContext $this$test) {
                                Intrinsics.checkNotNullParameter((Object)$this$test, (String)"$this$test");
                                $this$test.type(this.$newNameExample);
                            }
                        });
                    }
                });
                $this$null.text(RiderLessonsBundle.INSTANCE.message("rename.epilogue", new Object[0]));
                LessonUtilKt.restoreRefactoringOptionsInformer((LessonContext)$this$null);
            }
        };
    }

    private final String replaceTemplate(String name) {
        return StringsKt.replace$default((String)StringsKt.replace$default((String)this.template, (String)"<name>", (String)name, (boolean)false, (int)4, null), (String)"<name2>", (String)StringsKt.capitalize((String)name), (boolean)false, (int)4, null);
    }

    @NotNull
    protected Function1<LessonContext, Unit> getLessonContent() {
        return this.lessonContent;
    }

    @NotNull
    public Map<String, String> getHelpLinks() {
        return MapsKt.mapOf((Pair)new Pair((Object)LessonsBundle.INSTANCE.message("rename.help.link", new Object[0]), (Object)LessonUtil.INSTANCE.getHelpLink("Refactorings__Rename.html")));
    }

    public static final /* synthetic */ LessonSample access$getSample$p(CSharpRenameLesson $this) {
        return $this.sample;
    }

    public static final /* synthetic */ String access$getInitialName$p(CSharpRenameLesson $this) {
        return $this.initialName;
    }
}

