/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.utils;

import java.nio.file.Path;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u001a\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"convertToWindowsPath", "Ljava/nio/file/Path;", "wslPath", "convertToWslPath", "windowsPath", "intellij.rider.plugins.appender"})
public final class WslUtilsKt {
    @Nullable
    public static final Path convertToWindowsPath(@NotNull Path wslPath) {
        Intrinsics.checkNotNullParameter((Object)wslPath, (String)"wslPath");
        if (CollectionsKt.count((Iterable)wslPath) < 3) {
            return null;
        }
        Path path = wslPath.subpath(1, 2);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"subpath(...)");
        String drive = ((Object)path).toString();
        if (drive.length() != 1) {
            return null;
        }
        Path tail = wslPath.subpath(2, CollectionsKt.count((Iterable)wslPath));
        String string = drive.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        return Path.of(string + ":\\", new String[0]).resolve(tail);
    }

    @Nullable
    public static final Path convertToWslPath(@NotNull Path windowsPath) {
        Intrinsics.checkNotNullParameter((Object)windowsPath, (String)"windowsPath");
        if (!windowsPath.isAbsolute()) {
            return null;
        }
        Path path = windowsPath.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getRoot(...)");
        String string = String.valueOf(((Object)path).toString().charAt(0));
        Intrinsics.checkNotNull((Object)string, (String)"null cannot be cast to non-null type java.lang.String");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String drive = string2;
        Path tail = windowsPath.subpath(0, CollectionsKt.count((Iterable)windowsPath));
        return Path.of("/mnt/" + drive, new String[0]).resolve(tail);
    }
}

