/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.utils;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.plugins.appender.docker.utils.RiderDockerPortsInformation;
import com.jetbrains.rider.util.NetUtils;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\r\u001a\u00020\u00012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0001\u001a=\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00010\u00122\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\u0015\u001a\u0006\u0010\u0016\u001a\u00020\u0001\u001a\"\u0010\u0017\u001a\u00020\u00182\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f\u001a\u0006\u0010\u001a\u001a\u00020\u0001\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"BASE_BACKEND_TO_DEBUGGER_PORT", "", "BASE_DEBUGGER_TO_BACKEND_PORT", "BASE_DEBUGGER_TO_FRONTEND_PORT", "BASE_FRONTEND_TO_DEBUGGER_PORT", "PERIOD_LENGTH", "currentBackendToDebuggerFreePort", "currentFrontendToDebuggerFreePort", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "portsObtainingLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getAvailableContainerPort", "containerPortsInUse", "", "basePort", "getAvailableContainerPorts", "Lkotlin/Pair;", "baseToFrontendPort", "baseToBackendPort", "(Ljava/util/Set;Ljava/lang/Integer;Ljava/lang/Integer;)Lkotlin/Pair;", "getNextBackendToDebuggerPort", "getNextDockerPortsInformation", "Lcom/jetbrains/rider/plugins/appender/docker/utils/RiderDockerPortsInformation;", "hostPortsInUse", "getNextFrontendToDebuggerPort", "intellij.rider.plugins.appender"})
public final class RiderDockerPortsUtilKt {
    @NotNull
    private static final Logger logger;
    private static final int BASE_FRONTEND_TO_DEBUGGER_PORT = 57000;
    private static final int BASE_DEBUGGER_TO_FRONTEND_PORT = 57100;
    private static final int BASE_BACKEND_TO_DEBUGGER_PORT = 57200;
    private static final int BASE_DEBUGGER_TO_BACKEND_PORT = 57300;
    private static final int PERIOD_LENGTH = 100;
    private static int currentFrontendToDebuggerFreePort;
    private static int currentBackendToDebuggerFreePort;
    @NotNull
    private static final ReentrantLock portsObtainingLock;

    public static final int getNextFrontendToDebuggerPort() {
        int n = currentFrontendToDebuggerFreePort;
        currentFrontendToDebuggerFreePort = n + 1;
        int port2 = n;
        if (currentFrontendToDebuggerFreePort >= 57100) {
            currentFrontendToDebuggerFreePort = 57000;
        }
        return port2;
    }

    public static final int getNextBackendToDebuggerPort() {
        int n = currentBackendToDebuggerFreePort;
        currentBackendToDebuggerFreePort = n + 1;
        int port2 = n;
        if (currentBackendToDebuggerFreePort >= 57300) {
            currentBackendToDebuggerFreePort = 57200;
        }
        return port2;
    }

    public static final int getAvailableContainerPort(@NotNull Set<Integer> containerPortsInUse, int basePort) {
        Intrinsics.checkNotNullParameter(containerPortsInUse, (String)"containerPortsInUse");
        int port2 = basePort;
        while (containerPortsInUse.contains(port2)) {
            ++port2;
        }
        return port2;
    }

    @NotNull
    public static final Pair<Integer, Integer> getAvailableContainerPorts(@NotNull Set<Integer> containerPortsInUse, @Nullable Integer baseToFrontendPort, @Nullable Integer baseToBackendPort) {
        int toBackendPort;
        int toFrontendPort;
        Intrinsics.checkNotNullParameter(containerPortsInUse, (String)"containerPortsInUse");
        Integer n = baseToFrontendPort;
        int n2 = toFrontendPort = n != null ? n : 57100;
        while (containerPortsInUse.contains(toFrontendPort)) {
            ++toFrontendPort;
        }
        Integer n3 = baseToBackendPort;
        int n4 = toBackendPort = n3 != null ? n3 : 57300;
        while (containerPortsInUse.contains(toBackendPort) || toFrontendPort == toBackendPort) {
            ++toBackendPort;
        }
        return new Pair((Object)toFrontendPort, (Object)toBackendPort);
    }

    public static /* synthetic */ Pair getAvailableContainerPorts$default(Set set, Integer n, Integer n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = null;
        }
        if ((n3 & 4) != 0) {
            n2 = null;
        }
        return RiderDockerPortsUtilKt.getAvailableContainerPorts(set, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final RiderDockerPortsInformation getNextDockerPortsInformation(@NotNull Set<Integer> containerPortsInUse, @NotNull Set<Integer> hostPortsInUse) {
        RiderDockerPortsInformation riderDockerPortsInformation;
        Intrinsics.checkNotNullParameter(containerPortsInUse, (String)"containerPortsInUse");
        Intrinsics.checkNotNullParameter(hostPortsInUse, (String)"hostPortsInUse");
        logger.info("Obtaining Docker debugging ports information");
        Lock lock = portsObtainingLock;
        lock.lock();
        try {
            boolean bl = false;
            logger.trace("Ports information: Inside critical section");
            Pair hostPorts = NetUtils.INSTANCE.findFreePorts(RiderDockerPortsUtilKt.getNextFrontendToDebuggerPort(), RiderDockerPortsUtilKt.getNextBackendToDebuggerPort(), hostPortsInUse);
            Pair containerPorts = RiderDockerPortsUtilKt.getAvailableContainerPorts$default(containerPortsInUse, null, null, 6, null);
            logger.trace("Ports information: leaving critical section");
            riderDockerPortsInformation = new RiderDockerPortsInformation(((Number)hostPorts.getFirst()).intValue(), ((Number)containerPorts.getFirst()).intValue(), ((Number)hostPorts.getSecond()).intValue(), ((Number)containerPorts.getSecond()).intValue());
        }
        finally {
            lock.unlock();
        }
        RiderDockerPortsInformation portsInformation = riderDockerPortsInformation;
        logger.info("Ports for debugging: " + portsInformation);
        return portsInformation;
    }

    static {
        Logger logger = Logger.getInstance((String)"RiderDockerPortsUtil");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderDockerPortsUtilKt.logger = logger;
        currentFrontendToDebuggerFreePort = 57000;
        currentBackendToDebuggerFreePort = 57200;
        portsObtainingLock = new ReentrantLock();
    }
}

