/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.utils;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.util.text.UniqueNameGenerator;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\u001a\u000e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0010\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0001H\u0002\u001a\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\n\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u000b\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\f\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\r\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u001a\u0014\u0010\u000e\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u000f"}, d2={"createDefaultDockerServer", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "generateUniqueDockerServerName", "", "getDefaultOrWslDockerServer", "getOrCreateLocalServer", "isDefaultDockerServer", "", "server", "isLocalDockerServer", "isLocalTcpServer", "isSshDockerServer", "isWslDockerServer", "useUnixSocketsOrNamedPipes", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDockerServerUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerServerUtils.kt\ncom/jetbrains/rider/plugins/appender/docker/utils/DockerServerUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n288#2,2:83\n288#2,2:85\n288#2,2:87\n*S KotlinDebug\n*F\n+ 1 DockerServerUtils.kt\ncom/jetbrains/rider/plugins/appender/docker/utils/DockerServerUtilsKt\n*L\n56#1:83,2\n57#1:85,2\n58#1:87,2\n*E\n"})
public final class DockerServerUtilsKt {
    public static final boolean isLocalDockerServer(@NotNull RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        return DockerServerUtilsKt.isDefaultDockerServer(server) || DockerServerUtilsKt.useUnixSocketsOrNamedPipes(server) || DockerServerUtilsKt.isWslDockerServer(server) || DockerServerUtilsKt.isLocalTcpServer(server);
    }

    public static final boolean isDefaultDockerServer(@NotNull RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        return Intrinsics.areEqual((Object)((DockerCloudConfiguration)server.getConfiguration()).getCustomConfiguratorId(), (Object)"DockerDefaultConnectionConfigurator");
    }

    public static final boolean isWslDockerServer(@NotNull RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        return SystemInfo.isWindows && Intrinsics.areEqual((Object)((DockerCloudConfiguration)server.getConfiguration()).getCustomConfiguratorId(), (Object)"DockerWslConnectionConfigurator");
    }

    public static final boolean isLocalTcpServer(@NotNull RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        if (!Intrinsics.areEqual((Object)((DockerCloudConfiguration)server.getConfiguration()).getCustomConfiguratorId(), (Object)"DockerTcpConnectionConfigurator")) {
            return false;
        }
        if (StringsKt.startsWith$default((String)((DockerCloudConfiguration)server.getConfiguration()).getApiUrl(), (String)"unix", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((DockerCloudConfiguration)server.getConfiguration()).getApiUrl(), (String)"npipe", (boolean)false, (int)2, null)) {
            return true;
        }
        try {
            URI uri = new URI(((DockerCloudConfiguration)server.getConfiguration()).getApiUrl());
            if (Intrinsics.areEqual((Object)uri.getHost(), (Object)"localhost") || Intrinsics.areEqual((Object)uri.getHost(), (Object)"127.0.0.1")) {
                return true;
            }
        }
        catch (URISyntaxException e) {
            return false;
        }
        return false;
    }

    public static final boolean useUnixSocketsOrNamedPipes(@NotNull RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        return StringsKt.startsWith$default((String)((DockerCloudConfiguration)server.getConfiguration()).getApiUrl(), (String)"unix", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)((DockerCloudConfiguration)server.getConfiguration()).getApiUrl(), (String)"npipe", (boolean)false, (int)2, null);
    }

    public static final boolean isSshDockerServer(@NotNull RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter(server, (String)"server");
        return Intrinsics.areEqual((Object)((DockerCloudConfiguration)server.getConfiguration()).getCustomConfiguratorId(), (Object)"DockerSshConnectionConfigurator");
    }

    @NotNull
    public static final RemoteServer<DockerCloudConfiguration> getOrCreateLocalServer() {
        RemoteServer<DockerCloudConfiguration> existingServer = DockerServerUtilsKt.getDefaultOrWslDockerServer();
        if (existingServer != null) {
            return existingServer;
        }
        return DockerServerUtilsKt.createDefaultDockerServer();
    }

    private static final RemoteServer<DockerCloudConfiguration> getDefaultOrWslDockerServer() {
        RemoteServer remoteServer;
        Object v0;
        List servers;
        block6: {
            servers = DockerUtils.getDockerServers();
            if (servers.isEmpty()) {
                return null;
            }
            Iterable $this$firstOrNull$iv = servers;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                RemoteServer it = (RemoteServer)element$iv;
                boolean bl = false;
                if (!DockerServerUtilsKt.isDefaultDockerServer((RemoteServer<DockerCloudConfiguration>)it)) continue;
                v0 = element$iv;
                break block6;
            }
            v0 = null;
        }
        if ((remoteServer = (RemoteServer)v0) == null) {
            Object v2;
            boolean $i$f$firstOrNull;
            Iterable $this$firstOrNull$iv;
            block7: {
                $this$firstOrNull$iv = servers;
                $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    RemoteServer it = (RemoteServer)element$iv;
                    boolean bl = false;
                    if (!DockerServerUtilsKt.isWslDockerServer((RemoteServer<DockerCloudConfiguration>)it)) continue;
                    v2 = element$iv;
                    break block7;
                }
                v2 = null;
            }
            if ((remoteServer = (RemoteServer)v2) == null) {
                Object v3;
                block8: {
                    $this$firstOrNull$iv = servers;
                    $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        RemoteServer it = (RemoteServer)element$iv;
                        boolean bl = false;
                        if (!DockerServerUtilsKt.isLocalTcpServer((RemoteServer<DockerCloudConfiguration>)it)) continue;
                        v3 = element$iv;
                        break block8;
                    }
                    v3 = null;
                }
                remoteServer = v3;
            }
        }
        return remoteServer;
    }

    private static final RemoteServer<DockerCloudConfiguration> createDefaultDockerServer() {
        RemoteServersManager serversManager = RemoteServersManager.getInstance();
        DockerCloudType dockerCloudType = DockerCloudType.getInstance();
        RemoteServer remoteServer = serversManager.createServer((ServerType)dockerCloudType);
        Intrinsics.checkNotNullExpressionValue((Object)remoteServer, (String)"createServer(...)");
        RemoteServer server = remoteServer;
        serversManager.addServer(server);
        return server;
    }

    @NotNull
    public static final String generateUniqueDockerServerName() {
        DockerCloudType type = DockerCloudType.getInstance();
        List list2 = RemoteServersManager.getInstance().getServers((ServerType)type);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getServers(...)");
        Set servers = CollectionsKt.toSet((Iterable)list2);
        String string = UniqueNameGenerator.generateUniqueName((String)type.getPresentableName(), arg_0 -> DockerServerUtilsKt.generateUniqueDockerServerName$lambda$3((Function1)new Function1<String, Boolean>((Set<? extends RemoteServer<DockerCloudConfiguration>>)servers){
            final /* synthetic */ Set<RemoteServer<DockerCloudConfiguration>> $servers;
            {
                this.$servers = $servers;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                for (RemoteServer<DockerCloudConfiguration> server : this.$servers) {
                    if (!Intrinsics.areEqual((Object)server.getName(), (Object)s)) continue;
                    return false;
                }
                return true;
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"generateUniqueName(...)");
        return string;
    }

    private static final boolean generateUniqueDockerServerName$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

