/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.utils;

import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.agent.compose.beans.DockerComposeCommand;
import com.intellij.docker.agent.compose.beans.DockerComposeServiceBase;
import com.intellij.docker.agent.compose.beans.v1.DockerComposeServiceV1;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeBuildV2;
import com.intellij.docker.agent.compose.beans.v2.DockerComposeServiceV2;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.rider.plugins.appender.docker.RiderDockerBundle;
import com.jetbrains.rider.plugins.appender.docker.utils.WslUtilsKt;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001!B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001f\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0002\u00a2\u0006\u0002\u0010\u0007J&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0013H\u0002J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0005*\u00020\u0015H\u0002J\f\u0010\u0016\u001a\u0004\u0018\u00010\r*\u00020\u0015J\u0017\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\u0015\u00a2\u0006\u0002\u0010\u0018J\u0019\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0019\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ(\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\t*\u00020\u00152\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0017\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\u0015\u00a2\u0006\u0002\u0010\u0018J\u0019\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\u0019H\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0019\u0010\u001e\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004*\u00020\u001bH\u0002\u00a2\u0006\u0002\u0010\u001cJ\n\u0010\u001f\u001a\u00020 *\u00020\u0015\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/utils/ComposeParsingUtil;", "", "()V", "convertCommand", "", "", "command", "(Ljava/lang/Object;)[Ljava/lang/String;", "getEnvsFromConfig", "", "configuration", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "buildInfo", "Lcom/jetbrains/rider/plugins/appender/docker/utils/ComposeParsingUtil$ComposeBuildInfo;", "processEnvFile", "", "envFilePath", "Ljava/io/File;", "envs", "", "getBuildContext", "Lcom/intellij/docker/agent/compose/beans/DockerComposeServiceBase;", "getBuildInfo", "getCmd", "(Lcom/intellij/docker/agent/compose/beans/DockerComposeServiceBase;)[Ljava/lang/String;", "Lcom/intellij/docker/agent/compose/beans/v1/DockerComposeServiceV1;", "(Lcom/intellij/docker/agent/compose/beans/v1/DockerComposeServiceV1;)[Ljava/lang/String;", "Lcom/intellij/docker/agent/compose/beans/v2/DockerComposeServiceV2;", "(Lcom/intellij/docker/agent/compose/beans/v2/DockerComposeServiceV2;)[Ljava/lang/String;", "getEnvs", "getExecutionCommand", "hasBuild", "", "ComposeBuildInfo", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nComposeParsingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeParsingUtil.kt\ncom/jetbrains/rider/plugins/appender/docker/utils/ComposeParsingUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n23#2:177\n23#2:178\n23#2:194\n23#2:195\n23#2:196\n23#2:203\n23#2:204\n37#3,2:179\n37#3,2:192\n800#4,11:181\n1179#4,2:197\n1253#4,4:199\n*S KotlinDebug\n*F\n+ 1 ComposeParsingUtil.kt\ncom/jetbrains/rider/plugins/appender/docker/utils/ComposeParsingUtil\n*L\n20#1:177\n26#1:178\n45#1:194\n57#1:195\n63#1:196\n149#1:203\n166#1:204\n42#1:179,2\n43#1:192,2\n43#1:181,11\n138#1:197,2\n138#1:199,4\n*E\n"})
public final class ComposeParsingUtil {
    @NotNull
    public static final ComposeParsingUtil INSTANCE = new ComposeParsingUtil();

    private ComposeParsingUtil() {
    }

    @Nullable
    public final String[] getExecutionCommand(@NotNull DockerComposeServiceBase $this$getExecutionCommand) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)$this$getExecutionCommand, (String)"<this>");
        try {
            String[] stringArray2;
            stringArray = $this$getExecutionCommand;
            if (stringArray instanceof DockerComposeServiceV1) {
                stringArray2 = this.getExecutionCommand((DockerComposeServiceV1)$this$getExecutionCommand);
            } else if (stringArray instanceof DockerComposeServiceV2) {
                stringArray2 = this.getExecutionCommand((DockerComposeServiceV2)$this$getExecutionCommand);
            } else {
                String[] $this$thisLogger$iv = $this$getExecutionCommand;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(DockerComposeServiceBase.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Unknown service type: " + $this$getExecutionCommand.getClass());
                stringArray2 = null;
            }
            stringArray = stringArray2;
        }
        catch (Throwable t) {
            String[] $this$thisLogger$iv = $this$getExecutionCommand;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DockerComposeServiceBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(t);
            stringArray = null;
        }
        return stringArray;
    }

    private final String[] getExecutionCommand(DockerComposeServiceV1 $this$getExecutionCommand) {
        DockerComposeCommand dockerComposeCommand = $this$getExecutionCommand.getEntrypoint();
        return this.convertCommand(dockerComposeCommand != null ? dockerComposeCommand.getCommand() : null);
    }

    private final String[] getExecutionCommand(DockerComposeServiceV2 $this$getExecutionCommand) {
        DockerComposeCommand dockerComposeCommand = $this$getExecutionCommand.getEntrypoint();
        return this.convertCommand(dockerComposeCommand != null ? dockerComposeCommand.getCommand() : null);
    }

    /*
     * WARNING - void declaration
     */
    private final String[] convertCommand(Object command) {
        String[] stringArray;
        if (command == null) {
            return null;
        }
        Object object = command;
        if (object instanceof String) {
            String[] stringArray2 = new String[]{" "};
            Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((CharSequence)command), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else if (object instanceof List) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = (Iterable)command;
            boolean $i$f$filterIsInstance = false;
            Iterable thisCollection$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof String)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            stringArray = thisCollection$iv.toArray(new String[0]);
        } else {
            ComposeParsingUtil $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(ComposeParsingUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Unknown entrypoint command type: " + command.getClass());
            stringArray = null;
        }
        return stringArray;
    }

    @Nullable
    public final String[] getCmd(@NotNull DockerComposeServiceBase $this$getCmd) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)$this$getCmd, (String)"<this>");
        try {
            String[] stringArray2;
            stringArray = $this$getCmd;
            if (stringArray instanceof DockerComposeServiceV1) {
                stringArray2 = this.getCmd((DockerComposeServiceV1)$this$getCmd);
            } else if (stringArray instanceof DockerComposeServiceV2) {
                stringArray2 = this.getCmd((DockerComposeServiceV2)$this$getCmd);
            } else {
                String[] $this$thisLogger$iv = $this$getCmd;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(DockerComposeServiceBase.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Unknown service type: " + $this$getCmd.getClass());
                stringArray2 = null;
            }
            stringArray = stringArray2;
        }
        catch (Throwable t) {
            String[] $this$thisLogger$iv = $this$getCmd;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(DockerComposeServiceBase.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(t);
            stringArray = null;
        }
        return stringArray;
    }

    private final String[] getCmd(DockerComposeServiceV1 $this$getCmd) {
        DockerComposeCommand dockerComposeCommand = $this$getCmd.getCommand();
        return this.convertCommand(dockerComposeCommand != null ? dockerComposeCommand.getCommand() : null);
    }

    private final String[] getCmd(DockerComposeServiceV2 $this$getCmd) {
        DockerComposeCommand dockerComposeCommand = $this$getCmd.getCommand();
        return this.convertCommand(dockerComposeCommand != null ? dockerComposeCommand.getCommand() : null);
    }

    @Nullable
    public final ComposeBuildInfo getBuildInfo(@NotNull DockerComposeServiceBase $this$getBuildInfo) {
        ComposeBuildInfo composeBuildInfo;
        Intrinsics.checkNotNullParameter((Object)$this$getBuildInfo, (String)"<this>");
        String string = this.getBuildContext($this$getBuildInfo);
        if (string == null) {
            return null;
        }
        String context = string;
        DockerComposeServiceBase dockerComposeServiceBase = $this$getBuildInfo;
        if (dockerComposeServiceBase instanceof DockerComposeServiceV1) {
            composeBuildInfo = new ComposeBuildInfo(context, null, MapsKt.emptyMap(), null);
        } else if (dockerComposeServiceBase instanceof DockerComposeServiceV2) {
            DockerComposeBuildV2 dockerComposeBuildV2 = ((DockerComposeServiceV2)$this$getBuildInfo).getBuild();
            String string2 = dockerComposeBuildV2 != null ? dockerComposeBuildV2.getDockerfile() : null;
            DockerComposeBuildV2 dockerComposeBuildV22 = ((DockerComposeServiceV2)$this$getBuildInfo).getBuild();
            Map map2 = dockerComposeBuildV22 != null ? dockerComposeBuildV22.getArguments() : null;
            if (map2 == null) {
                map2 = MapsKt.emptyMap();
            }
            DockerComposeBuildV2 dockerComposeBuildV23 = ((DockerComposeServiceV2)$this$getBuildInfo).getBuild();
            composeBuildInfo = new ComposeBuildInfo(context, string2, map2, dockerComposeBuildV23 != null ? dockerComposeBuildV23.getTarget() : null);
        } else {
            Object[] objectArray = new Object[]{$this$getBuildInfo.getClass()};
            throw new IllegalStateException(RiderDockerBundle.Companion.message("rider.docker.unknown.compose.service.class", objectArray));
        }
        return composeBuildInfo;
    }

    private final String getBuildContext(DockerComposeServiceBase $this$getBuildContext) {
        String string;
        DockerComposeServiceBase dockerComposeServiceBase = $this$getBuildContext;
        if (dockerComposeServiceBase instanceof DockerComposeServiceV1) {
            string = ((DockerComposeServiceV1)$this$getBuildContext).getBuild();
        } else if (dockerComposeServiceBase instanceof DockerComposeServiceV2) {
            DockerComposeBuildV2 dockerComposeBuildV2 = ((DockerComposeServiceV2)$this$getBuildContext).getBuild();
            string = dockerComposeBuildV2 != null ? dockerComposeBuildV2.getContext() : null;
        } else {
            string = null;
        }
        return string;
    }

    public final boolean hasBuild(@NotNull DockerComposeServiceBase $this$hasBuild) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)$this$hasBuild, (String)"<this>");
        DockerComposeServiceBase dockerComposeServiceBase = $this$hasBuild;
        return dockerComposeServiceBase instanceof DockerComposeServiceV1 ? !((charSequence = (CharSequence)((DockerComposeServiceV1)$this$hasBuild).getBuild()) == null || charSequence.length() == 0) : (dockerComposeServiceBase instanceof DockerComposeServiceV2 ? ((DockerComposeServiceV2)$this$hasBuild).getBuild() != null : false);
    }

    @NotNull
    public final Map<String, String> getEnvs(@NotNull DockerComposeServiceBase $this$getEnvs, @NotNull DockerDeploymentConfiguration configuration, @Nullable ComposeBuildInfo buildInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$getEnvs, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Object object = $this$getEnvs.getEnvironment();
        if (object == null || (object = object.getEnvs()) == null || (object = MapsKt.toMutableMap((Map)object)) == null) {
            object = new LinkedHashMap();
        }
        Object envs = object;
        for (Map.Entry<String, String> configEnv : this.getEnvsFromConfig(configuration, buildInfo).entrySet()) {
            envs.put(configEnv.getKey(), configEnv.getValue());
        }
        return envs;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> getEnvsFromConfig(DockerDeploymentConfiguration configuration, ComposeBuildInfo buildInfo) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = configuration.getEnvVars();
        boolean $i$f$associate22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            DockerEnvVarImpl it = (DockerEnvVarImpl)element$iv$iv;
            boolean bl = false;
            Pair pair = new Pair((Object)it.getName(), (Object)it.getValue());
            map2.put(pair.getFirst(), pair.getSecond());
        }
        Map envs = MapsKt.toMutableMap((Map)destination$iv$iv);
        String envFilePathString = configuration.getEnvFilePath();
        CharSequence $i$f$associate22 = envFilePathString;
        if (!($i$f$associate22 == null || $i$f$associate22.length() == 0)) {
            File envFilePath = new File(envFilePathString);
            if (!envFilePath.isAbsolute()) {
                Object object = buildInfo;
                if (object == null || (object = ((ComposeBuildInfo)object).getContext()) == null) {
                    object = "";
                }
                Object context = object;
                envFilePath = new File((String)context, envFilePathString);
            }
            if (!envFilePath.isFile()) {
                ComposeParsingUtil $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ComposeParsingUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("Can't find env file for string " + envFilePathString);
                return envs;
            }
            this.processEnvFile(envFilePath, envs);
        }
        return envs;
    }

    private final void processEnvFile(File envFilePath, Map<String, String> envs) {
        for (String line : FilesKt.readLines$default((File)envFilePath, null, (int)1, null)) {
            if (StringsKt.isBlank((CharSequence)line) || StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)line)).toString(), (String)"#", (boolean)false, (int)2, null)) continue;
            int equalityCharIndex = StringsKt.indexOf$default((CharSequence)line, (String)"=", (int)0, (boolean)false, (int)6, null);
            if (equalityCharIndex < 0) {
                ComposeParsingUtil $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(ComposeParsingUtil.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn("File " + envFilePath + " contains invalid line: " + line);
                continue;
            }
            String string = line.substring(0, equalityCharIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String name = ((Object)StringsKt.trim((CharSequence)string)).toString();
            String string2 = line.substring(equalityCharIndex + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String value2 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            envs.put(name, value2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J\u0015\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003JA\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\u0014\b\u0002\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/utils/ComposeParsingUtil$ComposeBuildInfo;", "", "context", "", "dockerFile", "arguments", "", "buildTarget", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Ljava/lang/String;)V", "getArguments", "()Ljava/util/Map;", "getBuildTarget", "()Ljava/lang/String;", "getContext", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "getDockerfile", "Ljava/io/File;", "composeFilePath", "Ljava/nio/file/Path;", "hashCode", "", "toString", "intellij.rider.plugins.appender"})
    public static final class ComposeBuildInfo {
        @NotNull
        private final String context;
        @Nullable
        private final String dockerFile;
        @NotNull
        private final Map<String, String> arguments;
        @Nullable
        private final String buildTarget;

        public ComposeBuildInfo(@NotNull String context, @Nullable String dockerFile, @NotNull Map<String, String> arguments, @Nullable String buildTarget) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            this.context = context;
            this.dockerFile = dockerFile;
            this.arguments = arguments;
            this.buildTarget = buildTarget;
        }

        @NotNull
        public final String getContext() {
            return this.context;
        }

        @NotNull
        public final Map<String, String> getArguments() {
            return this.arguments;
        }

        @Nullable
        public final String getBuildTarget() {
            return this.buildTarget;
        }

        @Nullable
        public final File getDockerfile(@NotNull Path composeFilePath) {
            Path dockerfilePath;
            Intrinsics.checkNotNullParameter((Object)composeFilePath, (String)"composeFilePath");
            String string = this.dockerFile;
            if (string == null) {
                string = "Dockerfile";
            }
            if ((dockerfilePath = Path.of(string, new String[0])).isAbsolute()) {
                return dockerfilePath.toFile();
            }
            if (SystemInfo.isWindows && dockerfilePath.startsWith("/mnt/")) {
                Intrinsics.checkNotNull((Object)dockerfilePath);
                Path path = WslUtilsKt.convertToWindowsPath(dockerfilePath);
                return path != null ? path.toFile() : null;
            }
            Path dockerfileWithContextPath = Path.of(this.context, new String[0]).resolve(dockerfilePath);
            if (dockerfileWithContextPath.isAbsolute()) {
                return dockerfileWithContextPath.toFile();
            }
            if (SystemInfo.isWindows && dockerfileWithContextPath.startsWith("/mnt/")) {
                Intrinsics.checkNotNull((Object)dockerfileWithContextPath);
                Path path = WslUtilsKt.convertToWindowsPath(dockerfileWithContextPath);
                return path != null ? path.toFile() : null;
            }
            return composeFilePath.resolve(dockerfileWithContextPath).toFile();
        }

        @NotNull
        public final String component1() {
            return this.context;
        }

        private final String component2() {
            return this.dockerFile;
        }

        @NotNull
        public final Map<String, String> component3() {
            return this.arguments;
        }

        @Nullable
        public final String component4() {
            return this.buildTarget;
        }

        @NotNull
        public final ComposeBuildInfo copy(@NotNull String context, @Nullable String dockerFile, @NotNull Map<String, String> arguments, @Nullable String buildTarget) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
            return new ComposeBuildInfo(context, dockerFile, arguments, buildTarget);
        }

        public static /* synthetic */ ComposeBuildInfo copy$default(ComposeBuildInfo composeBuildInfo, String string, String string2, Map map2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = composeBuildInfo.context;
            }
            if ((n & 2) != 0) {
                string2 = composeBuildInfo.dockerFile;
            }
            if ((n & 4) != 0) {
                map2 = composeBuildInfo.arguments;
            }
            if ((n & 8) != 0) {
                string3 = composeBuildInfo.buildTarget;
            }
            return composeBuildInfo.copy(string, string2, map2, string3);
        }

        @NotNull
        public String toString() {
            return "ComposeBuildInfo(context=" + this.context + ", dockerFile=" + this.dockerFile + ", arguments=" + this.arguments + ", buildTarget=" + this.buildTarget + ")";
        }

        public int hashCode() {
            int result2 = this.context.hashCode();
            result2 = result2 * 31 + (this.dockerFile == null ? 0 : this.dockerFile.hashCode());
            result2 = result2 * 31 + ((Object)this.arguments).hashCode();
            result2 = result2 * 31 + (this.buildTarget == null ? 0 : this.buildTarget.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ComposeBuildInfo)) {
                return false;
            }
            ComposeBuildInfo composeBuildInfo = (ComposeBuildInfo)other;
            if (!Intrinsics.areEqual((Object)this.context, (Object)composeBuildInfo.context)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dockerFile, (Object)composeBuildInfo.dockerFile)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.arguments, composeBuildInfo.arguments)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.buildTarget, (Object)composeBuildInfo.buildTarget);
        }
    }
}

