/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.runConfiguration;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.deploymentSource.DockerFileDeploymentSourceType;
import com.intellij.docker.deploymentSource.DockerSingletonDeploymentSourceType;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.deployment.DeploymentConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.jetbrains.rider.plugins.appender.docker.fastMode.RiderDockerFastModeConfigurationExtensionKt;
import com.jetbrains.rider.plugins.appender.docker.utils.DockerServerUtilsKt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerfileRunConfigurationService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createRunConfiguration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "parameters", "Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerfileRunConfigurationService$DockerfileRunConfigurationParameters;", "modifyConfiguration", "", "deploymentConfiguration", "Lcom/intellij/docker/DockerDeploymentConfiguration;", "Companion", "DockerfileRunConfigurationParameters", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDockerfileRunConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerfileRunConfigurationService.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerfileRunConfigurationService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,119:1\n13#2:120\n*S KotlinDebug\n*F\n+ 1 DockerfileRunConfigurationService.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerfileRunConfigurationService\n*L\n24#1:120\n*E\n"})
public final class DockerfileRunConfigurationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public DockerfileRunConfigurationService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @Nullable
    public final RunnerAndConfigurationSettings createRunConfiguration(@NotNull DockerfileRunConfigurationParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        LOG.info("Creating Dockerfile run configuration");
        VirtualFile dockerfile = VfsUtil.findFile((Path)Path.of(parameters.getDockerfilePath(), new String[0]), (boolean)true);
        if (dockerfile == null) {
            LOG.warn("Unable to find Dockerfile by path " + parameters.getDockerfilePath());
            return null;
        }
        DockerRunConfigurationCreator configurationCreator = new DockerRunConfigurationCreator(this.project);
        RemoteServer<DockerCloudConfiguration> server = DockerServerUtilsKt.getOrCreateLocalServer();
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = configurationCreator.createConfiguration((DockerSingletonDeploymentSourceType)DockerFileDeploymentSourceType.getInstance(), dockerfile, server);
        Intrinsics.checkNotNullExpressionValue((Object)runnerAndConfigurationSettings, (String)"createConfiguration(...)");
        RunnerAndConfigurationSettings configuration = runnerAndConfigurationSettings;
        RunConfiguration runConfiguration = configuration.getConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
        RunConfiguration deployToServerConfiguration = runConfiguration;
        if (!(deployToServerConfiguration instanceof DeployToServerRunConfiguration)) {
            return null;
        }
        DeploymentConfiguration deploymentConfiguration = ((DeployToServerRunConfiguration)deployToServerConfiguration).getDeploymentConfiguration();
        if (!(deploymentConfiguration instanceof DockerDeploymentConfiguration)) {
            return null;
        }
        this.modifyConfiguration((DockerDeploymentConfiguration)deploymentConfiguration, parameters);
        configuration.setTemporary(false);
        return configuration;
    }

    /*
     * WARNING - void declaration
     */
    private final void modifyConfiguration(DockerDeploymentConfiguration deploymentConfiguration, DockerfileRunConfigurationParameters parameters) {
        DockerPortBindingImpl $this$modifyConfiguration_u24lambda_u240;
        List list2;
        DockerPortBindingImpl dockerPortBindingImpl;
        if (parameters.getDockerfileContext() != null) {
            deploymentConfiguration.setContextFolderPath(parameters.getDockerfileContext());
        }
        if (parameters.getDockerfileBuildArgs() != null) {
            deploymentConfiguration.setBuildCliOptions(parameters.getDockerfileBuildArgs());
        }
        if (parameters.getDockerfileRunArgs() != null) {
            deploymentConfiguration.setRunCliOptions(parameters.getDockerfileRunArgs());
        }
        if (parameters.getDockerfileTag() != null) {
            deploymentConfiguration.setAllImageTagsJoined(parameters.getDockerfileTag());
        }
        if (parameters.getDockerfileContainerName() != null) {
            deploymentConfiguration.setContainerName(parameters.getDockerfileContainerName());
        }
        if (Intrinsics.areEqual((Object)parameters.getPublishAllPorts(), (Object)true)) {
            deploymentConfiguration.setPublishAllPorts(true);
        }
        if (parameters.getHttpPort() != null) {
            DockerPortBindingImpl dockerPortBindingImpl2 = dockerPortBindingImpl = new DockerPortBindingImpl();
            list2 = deploymentConfiguration.getPortBindings();
            boolean bl = false;
            $this$modifyConfiguration_u24lambda_u240.setHostIp("127.0.0.1");
            $this$modifyConfiguration_u24lambda_u240.setHostPort(parameters.getHttpPort());
            $this$modifyConfiguration_u24lambda_u240.setContainerPort(Intrinsics.areEqual((Object)parameters.isRootless(), (Object)true) ? 8080 : 80);
            list2.add(dockerPortBindingImpl);
        }
        if (parameters.getSslPort() != null) {
            void $this$modifyConfiguration_u24lambda_u241;
            $this$modifyConfiguration_u24lambda_u240 = dockerPortBindingImpl = new DockerPortBindingImpl();
            list2 = deploymentConfiguration.getPortBindings();
            boolean bl = false;
            $this$modifyConfiguration_u24lambda_u241.setHostIp("127.0.0.1");
            $this$modifyConfiguration_u24lambda_u241.setHostPort(parameters.getSslPort());
            $this$modifyConfiguration_u24lambda_u241.setContainerPort(Intrinsics.areEqual((Object)parameters.isRootless(), (Object)true) ? 8081 : 443);
            list2.add(dockerPortBindingImpl);
        }
        if (Intrinsics.areEqual((Object)parameters.isRegularModeEnabled(), (Object)true)) {
            RiderDockerFastModeConfigurationExtensionKt.setFastModeEnabled(deploymentConfiguration, false);
        }
        if (Intrinsics.areEqual((Object)parameters.isSslEnabled(), (Object)true) || parameters.getSslPort() != null) {
            RiderDockerFastModeConfigurationExtensionKt.setSslEnabled(deploymentConfiguration, true);
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerfileRunConfigurationService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerfileRunConfigurationService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerfileRunConfigurationService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.appender"})
    @SourceDebugExtension(value={"SMAP\nDockerfileRunConfigurationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerfileRunConfigurationService.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerfileRunConfigurationService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,119:1\n31#2,2:120\n*S KotlinDebug\n*F\n+ 1 DockerfileRunConfigurationService.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerfileRunConfigurationService$Companion\n*L\n22#1:120,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DockerfileRunConfigurationService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DockerfileRunConfigurationService> serviceClass$iv = DockerfileRunConfigurationService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DockerfileRunConfigurationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b&\b\u0086\b\u0018\u00002\u00020\u0001B{\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0011J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010!\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\"\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010#\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001cJ\u000b\u0010$\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010'\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010(\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0010\u0010)\u001a\u0004\u0018\u00010\nH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010*\u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010+\u001a\u0004\u0018\u00010\fH\u00c6\u0003\u00a2\u0006\u0002\u0010\u001aJ\u009c\u0001\u0010,\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\n2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\nH\u00c6\u0001\u00a2\u0006\u0002\u0010-J\u0013\u0010.\u001a\u00020\n2\b\u0010/\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00100\u001a\u00020\fH\u00d6\u0001J\t\u00101\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u0019\u0010\u001aR\u0015\u0010\u000e\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u000e\u0010\u001cR\u0015\u0010\u0010\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u0010\u0010\u001cR\u0015\u0010\u000f\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u000f\u0010\u001cR\u0015\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001e\u0010\u001cR\u0015\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u0010\u001b\u001a\u0004\b\u001f\u0010\u001a\u00a8\u00062"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerfileRunConfigurationService$DockerfileRunConfigurationParameters;", "", "dockerfilePath", "", "dockerfileContext", "dockerfileBuildArgs", "dockerfileRunArgs", "dockerfileTag", "dockerfileContainerName", "publishAllPorts", "", "httpPort", "", "sslPort", "isRegularModeEnabled", "isSslEnabled", "isRootless", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)V", "getDockerfileBuildArgs", "()Ljava/lang/String;", "getDockerfileContainerName", "getDockerfileContext", "getDockerfilePath", "getDockerfileRunArgs", "getDockerfileTag", "getHttpPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "getPublishAllPorts", "getSslPort", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerfileRunConfigurationService$DockerfileRunConfigurationParameters;", "equals", "other", "hashCode", "toString", "intellij.rider.plugins.appender"})
    public static final class DockerfileRunConfigurationParameters {
        @NotNull
        private final String dockerfilePath;
        @Nullable
        private final String dockerfileContext;
        @Nullable
        private final String dockerfileBuildArgs;
        @Nullable
        private final String dockerfileRunArgs;
        @Nullable
        private final String dockerfileTag;
        @Nullable
        private final String dockerfileContainerName;
        @Nullable
        private final Boolean publishAllPorts;
        @Nullable
        private final Integer httpPort;
        @Nullable
        private final Integer sslPort;
        @Nullable
        private final Boolean isRegularModeEnabled;
        @Nullable
        private final Boolean isSslEnabled;
        @Nullable
        private final Boolean isRootless;

        public DockerfileRunConfigurationParameters(@NotNull String dockerfilePath, @Nullable String dockerfileContext, @Nullable String dockerfileBuildArgs, @Nullable String dockerfileRunArgs, @Nullable String dockerfileTag, @Nullable String dockerfileContainerName, @Nullable Boolean publishAllPorts, @Nullable Integer httpPort, @Nullable Integer sslPort, @Nullable Boolean isRegularModeEnabled, @Nullable Boolean isSslEnabled, @Nullable Boolean isRootless) {
            Intrinsics.checkNotNullParameter((Object)dockerfilePath, (String)"dockerfilePath");
            this.dockerfilePath = dockerfilePath;
            this.dockerfileContext = dockerfileContext;
            this.dockerfileBuildArgs = dockerfileBuildArgs;
            this.dockerfileRunArgs = dockerfileRunArgs;
            this.dockerfileTag = dockerfileTag;
            this.dockerfileContainerName = dockerfileContainerName;
            this.publishAllPorts = publishAllPorts;
            this.httpPort = httpPort;
            this.sslPort = sslPort;
            this.isRegularModeEnabled = isRegularModeEnabled;
            this.isSslEnabled = isSslEnabled;
            this.isRootless = isRootless;
        }

        @NotNull
        public final String getDockerfilePath() {
            return this.dockerfilePath;
        }

        @Nullable
        public final String getDockerfileContext() {
            return this.dockerfileContext;
        }

        @Nullable
        public final String getDockerfileBuildArgs() {
            return this.dockerfileBuildArgs;
        }

        @Nullable
        public final String getDockerfileRunArgs() {
            return this.dockerfileRunArgs;
        }

        @Nullable
        public final String getDockerfileTag() {
            return this.dockerfileTag;
        }

        @Nullable
        public final String getDockerfileContainerName() {
            return this.dockerfileContainerName;
        }

        @Nullable
        public final Boolean getPublishAllPorts() {
            return this.publishAllPorts;
        }

        @Nullable
        public final Integer getHttpPort() {
            return this.httpPort;
        }

        @Nullable
        public final Integer getSslPort() {
            return this.sslPort;
        }

        @Nullable
        public final Boolean isRegularModeEnabled() {
            return this.isRegularModeEnabled;
        }

        @Nullable
        public final Boolean isSslEnabled() {
            return this.isSslEnabled;
        }

        @Nullable
        public final Boolean isRootless() {
            return this.isRootless;
        }

        @NotNull
        public final String component1() {
            return this.dockerfilePath;
        }

        @Nullable
        public final String component2() {
            return this.dockerfileContext;
        }

        @Nullable
        public final String component3() {
            return this.dockerfileBuildArgs;
        }

        @Nullable
        public final String component4() {
            return this.dockerfileRunArgs;
        }

        @Nullable
        public final String component5() {
            return this.dockerfileTag;
        }

        @Nullable
        public final String component6() {
            return this.dockerfileContainerName;
        }

        @Nullable
        public final Boolean component7() {
            return this.publishAllPorts;
        }

        @Nullable
        public final Integer component8() {
            return this.httpPort;
        }

        @Nullable
        public final Integer component9() {
            return this.sslPort;
        }

        @Nullable
        public final Boolean component10() {
            return this.isRegularModeEnabled;
        }

        @Nullable
        public final Boolean component11() {
            return this.isSslEnabled;
        }

        @Nullable
        public final Boolean component12() {
            return this.isRootless;
        }

        @NotNull
        public final DockerfileRunConfigurationParameters copy(@NotNull String dockerfilePath, @Nullable String dockerfileContext, @Nullable String dockerfileBuildArgs, @Nullable String dockerfileRunArgs, @Nullable String dockerfileTag, @Nullable String dockerfileContainerName, @Nullable Boolean publishAllPorts, @Nullable Integer httpPort, @Nullable Integer sslPort, @Nullable Boolean isRegularModeEnabled, @Nullable Boolean isSslEnabled, @Nullable Boolean isRootless) {
            Intrinsics.checkNotNullParameter((Object)dockerfilePath, (String)"dockerfilePath");
            return new DockerfileRunConfigurationParameters(dockerfilePath, dockerfileContext, dockerfileBuildArgs, dockerfileRunArgs, dockerfileTag, dockerfileContainerName, publishAllPorts, httpPort, sslPort, isRegularModeEnabled, isSslEnabled, isRootless);
        }

        public static /* synthetic */ DockerfileRunConfigurationParameters copy$default(DockerfileRunConfigurationParameters dockerfileRunConfigurationParameters, String string, String string2, String string3, String string4, String string5, String string6, Boolean bl, Integer n, Integer n2, Boolean bl2, Boolean bl3, Boolean bl4, int n3, Object object) {
            if ((n3 & 1) != 0) {
                string = dockerfileRunConfigurationParameters.dockerfilePath;
            }
            if ((n3 & 2) != 0) {
                string2 = dockerfileRunConfigurationParameters.dockerfileContext;
            }
            if ((n3 & 4) != 0) {
                string3 = dockerfileRunConfigurationParameters.dockerfileBuildArgs;
            }
            if ((n3 & 8) != 0) {
                string4 = dockerfileRunConfigurationParameters.dockerfileRunArgs;
            }
            if ((n3 & 0x10) != 0) {
                string5 = dockerfileRunConfigurationParameters.dockerfileTag;
            }
            if ((n3 & 0x20) != 0) {
                string6 = dockerfileRunConfigurationParameters.dockerfileContainerName;
            }
            if ((n3 & 0x40) != 0) {
                bl = dockerfileRunConfigurationParameters.publishAllPorts;
            }
            if ((n3 & 0x80) != 0) {
                n = dockerfileRunConfigurationParameters.httpPort;
            }
            if ((n3 & 0x100) != 0) {
                n2 = dockerfileRunConfigurationParameters.sslPort;
            }
            if ((n3 & 0x200) != 0) {
                bl2 = dockerfileRunConfigurationParameters.isRegularModeEnabled;
            }
            if ((n3 & 0x400) != 0) {
                bl3 = dockerfileRunConfigurationParameters.isSslEnabled;
            }
            if ((n3 & 0x800) != 0) {
                bl4 = dockerfileRunConfigurationParameters.isRootless;
            }
            return dockerfileRunConfigurationParameters.copy(string, string2, string3, string4, string5, string6, bl, n, n2, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "DockerfileRunConfigurationParameters(dockerfilePath=" + this.dockerfilePath + ", dockerfileContext=" + this.dockerfileContext + ", dockerfileBuildArgs=" + this.dockerfileBuildArgs + ", dockerfileRunArgs=" + this.dockerfileRunArgs + ", dockerfileTag=" + this.dockerfileTag + ", dockerfileContainerName=" + this.dockerfileContainerName + ", publishAllPorts=" + this.publishAllPorts + ", httpPort=" + this.httpPort + ", sslPort=" + this.sslPort + ", isRegularModeEnabled=" + this.isRegularModeEnabled + ", isSslEnabled=" + this.isSslEnabled + ", isRootless=" + this.isRootless + ")";
        }

        public int hashCode() {
            int result2 = this.dockerfilePath.hashCode();
            result2 = result2 * 31 + (this.dockerfileContext == null ? 0 : this.dockerfileContext.hashCode());
            result2 = result2 * 31 + (this.dockerfileBuildArgs == null ? 0 : this.dockerfileBuildArgs.hashCode());
            result2 = result2 * 31 + (this.dockerfileRunArgs == null ? 0 : this.dockerfileRunArgs.hashCode());
            result2 = result2 * 31 + (this.dockerfileTag == null ? 0 : this.dockerfileTag.hashCode());
            result2 = result2 * 31 + (this.dockerfileContainerName == null ? 0 : this.dockerfileContainerName.hashCode());
            result2 = result2 * 31 + (this.publishAllPorts == null ? 0 : ((Object)this.publishAllPorts).hashCode());
            result2 = result2 * 31 + (this.httpPort == null ? 0 : ((Object)this.httpPort).hashCode());
            result2 = result2 * 31 + (this.sslPort == null ? 0 : ((Object)this.sslPort).hashCode());
            result2 = result2 * 31 + (this.isRegularModeEnabled == null ? 0 : ((Object)this.isRegularModeEnabled).hashCode());
            result2 = result2 * 31 + (this.isSslEnabled == null ? 0 : ((Object)this.isSslEnabled).hashCode());
            result2 = result2 * 31 + (this.isRootless == null ? 0 : ((Object)this.isRootless).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DockerfileRunConfigurationParameters)) {
                return false;
            }
            DockerfileRunConfigurationParameters dockerfileRunConfigurationParameters = (DockerfileRunConfigurationParameters)other;
            if (!Intrinsics.areEqual((Object)this.dockerfilePath, (Object)dockerfileRunConfigurationParameters.dockerfilePath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dockerfileContext, (Object)dockerfileRunConfigurationParameters.dockerfileContext)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dockerfileBuildArgs, (Object)dockerfileRunConfigurationParameters.dockerfileBuildArgs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dockerfileRunArgs, (Object)dockerfileRunConfigurationParameters.dockerfileRunArgs)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dockerfileTag, (Object)dockerfileRunConfigurationParameters.dockerfileTag)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dockerfileContainerName, (Object)dockerfileRunConfigurationParameters.dockerfileContainerName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.publishAllPorts, (Object)dockerfileRunConfigurationParameters.publishAllPorts)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.httpPort, (Object)dockerfileRunConfigurationParameters.httpPort)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sslPort, (Object)dockerfileRunConfigurationParameters.sslPort)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.isRegularModeEnabled, (Object)dockerfileRunConfigurationParameters.isRegularModeEnabled)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.isSslEnabled, (Object)dockerfileRunConfigurationParameters.isSslEnabled)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.isRootless, (Object)dockerfileRunConfigurationParameters.isRootless);
        }
    }
}

