/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.runConfiguration;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.rd.protocol.SolutionExtListener;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.DockerModel;
import com.jetbrains.rider.model.RdDockerComposeProperties;
import com.jetbrains.rider.model.RdDockerfileProjectProperties;
import com.jetbrains.rider.plugins.appender.docker.runConfiguration.DockerComposeRunConfigurationService;
import com.jetbrains.rider.plugins.appender.docker.runConfiguration.DockerfileRunConfigurationService;
import com.jetbrains.rider.plugins.appender.docker.runConfiguration.RunManagerExtensionsKt;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0016B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0016J\u0018\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerRunConfigurationProtocolListener;", "Lcom/jetbrains/rd/protocol/SolutionExtListener;", "Lcom/jetbrains/rider/model/DockerModel;", "()V", "dockerComposeCreated", "", "dockerComposeProperties", "Lcom/jetbrains/rider/model/RdDockerComposeProperties;", "project", "Lcom/intellij/openapi/project/Project;", "dockerComposeUpdated", "dockerfileCreated", "dockerfileProjectProperties", "Lcom/jetbrains/rider/model/RdDockerfileProjectProperties;", "extensionCreated", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "model", "generateComposeRunConfiguration", "generateDockerfileRunConfiguration", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDockerRunConfigurationProtocolListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerRunConfigurationProtocolListener.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerRunConfigurationProtocolListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,132:1\n13#2:133\n*S KotlinDebug\n*F\n+ 1 DockerRunConfigurationProtocolListener.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerRunConfigurationProtocolListener\n*L\n20#1:133\n*E\n"})
public final class DockerRunConfigurationProtocolListener
implements SolutionExtListener<DockerModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    public void extensionCreated(@NotNull Lifetime lifetime, @NotNull ClientProjectSession session, @NotNull DockerModel model) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        model.getDockerfileCreated().advise(lifetime, (Function1)new Function1<RdDockerfileProjectProperties, Unit>(this, session){
            final /* synthetic */ DockerRunConfigurationProtocolListener this$0;
            final /* synthetic */ ClientProjectSession $session;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                super(1);
            }

            public final void invoke(@NotNull RdDockerfileProjectProperties it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DockerRunConfigurationProtocolListener.access$dockerfileCreated(this.this$0, it, this.$session.getProject());
            }
        });
        model.getDockerComposeCreated().advise(lifetime, (Function1)new Function1<RdDockerComposeProperties, Unit>(this, session){
            final /* synthetic */ DockerRunConfigurationProtocolListener this$0;
            final /* synthetic */ ClientProjectSession $session;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                super(1);
            }

            public final void invoke(@NotNull RdDockerComposeProperties it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DockerRunConfigurationProtocolListener.access$dockerComposeCreated(this.this$0, it, this.$session.getProject());
            }
        });
        model.getDockerComposeUpdated().advise(lifetime, (Function1)new Function1<RdDockerComposeProperties, Unit>(this, session){
            final /* synthetic */ DockerRunConfigurationProtocolListener this$0;
            final /* synthetic */ ClientProjectSession $session;
            {
                this.this$0 = $receiver;
                this.$session = $session;
                super(1);
            }

            public final void invoke(@NotNull RdDockerComposeProperties it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DockerRunConfigurationProtocolListener.access$dockerComposeUpdated(this.this$0, it, this.$session.getProject());
            }
        });
    }

    private final void dockerfileCreated(RdDockerfileProjectProperties dockerfileProjectProperties, Project project) {
        if (dockerfileProjectProperties.getShouldGenerateRunConfiguration()) {
            this.generateDockerfileRunConfiguration(dockerfileProjectProperties, project);
        }
        if (dockerfileProjectProperties.getShouldOpenFile()) {
            VirtualFile dockerfile = VfsUtil.findFile((Path)Path.of(dockerfileProjectProperties.getDockerfilePath(), new String[0]), (boolean)true);
            if (dockerfile == null) {
                LOG.warn("Unable to find Dockerfile");
                return;
            }
            FileEditorManager.getInstance((Project)project).openFile(dockerfile, true);
        }
    }

    private final void generateDockerfileRunConfiguration(RdDockerfileProjectProperties dockerfileProjectProperties, Project project) {
        String string;
        RunManager runManager = RunManager.Companion.getInstance(project);
        List<String> existingDeploymentSourcePaths = RunManagerExtensionsKt.getDockerDeploymentSourceFilePaths(runManager, project);
        if (existingDeploymentSourcePaths.contains(dockerfileProjectProperties.getDockerfilePath())) {
            return;
        }
        LOG.trace("Generating run configuration for the created Dockerfile (" + dockerfileProjectProperties.getDockerfilePath() + ")");
        DockerfileRunConfigurationService runConfigurationService = DockerfileRunConfigurationService.Companion.getInstance(project);
        String string2 = dockerfileProjectProperties.getDockerfilePath();
        String string3 = dockerfileProjectProperties.getDockerfileContextPath();
        String string4 = dockerfileProjectProperties.getDockerfileBuildArguments();
        String string5 = dockerfileProjectProperties.getDockerfileRunArguments();
        String string6 = dockerfileProjectProperties.getDockerfileTag();
        String string7 = dockerfileProjectProperties.getDockerfileContainerName();
        Boolean bl = false;
        Integer n = dockerfileProjectProperties.isAspNetProject() ? Integer.valueOf(8080) : null;
        String string8 = dockerfileProjectProperties.getContainerDevelopmentMode();
        if (string8 != null) {
            String string9 = string8.toLowerCase(Locale.ROOT);
            string = string9;
            Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        DockerfileRunConfigurationService.DockerfileRunConfigurationParameters parameters = new DockerfileRunConfigurationService.DockerfileRunConfigurationParameters(string2, string3, string4, string5, string6, string7, bl, n, null, Intrinsics.areEqual((Object)string, (Object)"regular"), false, dockerfileProjectProperties.isRootless());
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runConfigurationService.createRunConfiguration(parameters);
        if (runnerAndConfigurationSettings == null) {
            return;
        }
        RunnerAndConfigurationSettings configuration = runnerAndConfigurationSettings;
        LOG.trace("Adding new run configuration for Dockerfile (" + dockerfileProjectProperties.getDockerfilePath() + ")");
        runManager.addConfiguration(configuration);
    }

    private final void dockerComposeCreated(RdDockerComposeProperties dockerComposeProperties, Project project) {
        if (dockerComposeProperties.getShouldGenerateRunConfiguration()) {
            this.generateComposeRunConfiguration(dockerComposeProperties, project);
        }
        if (dockerComposeProperties.getShouldOpenFile()) {
            VirtualFile composeFile = VfsUtil.findFile((Path)Path.of(dockerComposeProperties.getPath(), new String[0]), (boolean)true);
            if (composeFile == null) {
                LOG.warn("Unable to find Docker Compose file");
                return;
            }
            FileEditorManager.getInstance((Project)project).openFile(composeFile, true);
        }
    }

    private final void dockerComposeUpdated(RdDockerComposeProperties dockerComposeProperties, Project project) {
        VirtualFile composeFile = VfsUtil.findFile((Path)Path.of(dockerComposeProperties.getPath(), new String[0]), (boolean)true);
        if (composeFile == null) {
            LOG.warn("Unable to find Docker Compose file");
            return;
        }
        VirtualFile[] virtualFileArray = new VirtualFile[]{composeFile};
        VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])virtualFileArray);
        if (dockerComposeProperties.getShouldGenerateRunConfiguration()) {
            this.generateComposeRunConfiguration(dockerComposeProperties, project);
        }
        if (dockerComposeProperties.getShouldOpenFile()) {
            FileEditorManager.getInstance((Project)project).openFile(composeFile, true);
        }
    }

    private final void generateComposeRunConfiguration(RdDockerComposeProperties dockerComposeProperties, Project project) {
        RunManager runManager = RunManager.Companion.getInstance(project);
        List<String> existingDeploymentSourcePaths = RunManagerExtensionsKt.getDockerDeploymentSourceFilePaths(runManager, project);
        if (existingDeploymentSourcePaths.contains(dockerComposeProperties.getPath())) {
            return;
        }
        LOG.trace("Generating run configuration for the created Docker Compose (" + dockerComposeProperties.getPath() + ")");
        DockerComposeRunConfigurationService runConfigurationService = DockerComposeRunConfigurationService.Companion.getInstance(project);
        DockerComposeRunConfigurationService.DockerComposeRunConfigurationParameters parameters = new DockerComposeRunConfigurationService.DockerComposeRunConfigurationParameters(dockerComposeProperties.getPath(), null, null, null, false, false);
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runConfigurationService.createRunConfiguration(parameters);
        if (runnerAndConfigurationSettings == null) {
            return;
        }
        RunnerAndConfigurationSettings configuration = runnerAndConfigurationSettings;
        LOG.trace("Adding new run configuration for Docker Compose file (" + dockerComposeProperties.getPath() + ")");
        runManager.addConfiguration(configuration);
    }

    public static final /* synthetic */ void access$dockerfileCreated(DockerRunConfigurationProtocolListener $this, RdDockerfileProjectProperties dockerfileProjectProperties, Project project) {
        $this.dockerfileCreated(dockerfileProjectProperties, project);
    }

    public static final /* synthetic */ void access$dockerComposeCreated(DockerRunConfigurationProtocolListener $this, RdDockerComposeProperties dockerComposeProperties, Project project) {
        $this.dockerComposeCreated(dockerComposeProperties, project);
    }

    public static final /* synthetic */ void access$dockerComposeUpdated(DockerRunConfigurationProtocolListener $this, RdDockerComposeProperties dockerComposeProperties, Project project) {
        $this.dockerComposeUpdated(dockerComposeProperties, project);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerRunConfigurationProtocolListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerRunConfigurationProtocolListener$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

