/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.runConfiguration;

import com.intellij.docker.DockerCloudType;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.model.Key;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.plugins.appender.docker.runConfiguration.DockerfileRunConfigurationService;
import com.jetbrains.rider.plugins.appender.docker.runConfiguration.RunManagerExtensionsKt;
import com.jetbrains.rider.plugins.appender.docker.statistics.RiderDockerStatisticsCollector;
import com.jetbrains.rider.run.AutoGeneratedRunConfigurationManager;
import com.jetbrains.rider.run.ExternalRunConfigurationGeneratorExtension;
import com.jetbrains.rider.run.configurations.RunConfigurationHelper;
import com.jetbrains.rider.run.configurations.RunnableProjectKinds;
import com.jetbrains.rider.run.configurations.project.RunnableProjectExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002J8\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00060\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerProjectRunConfigurationGenerator;", "Lcom/jetbrains/rider/run/ExternalRunConfigurationGeneratorExtension;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "generateConfigurationForProject", "Lkotlin/Pair;", "", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "existingConfigPaths", "", "generateConfigurations", "runnableProjects", "autoGeneratedRunConfigurationManager", "Lcom/jetbrains/rider/run/AutoGeneratedRunConfigurationManager;", "runManager", "Lcom/intellij/execution/RunManager;", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDockerProjectRunConfigurationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerProjectRunConfigurationGenerator.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerProjectRunConfigurationGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,75:1\n766#2:76\n857#2,2:77\n1603#2,9:79\n1855#2:88\n1856#2:90\n1612#2:91\n1#3:89\n13#4:92\n*S KotlinDebug\n*F\n+ 1 DockerProjectRunConfigurationGenerator.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerProjectRunConfigurationGenerator\n*L\n28#1:76\n28#1:77,2\n36#1:79,9\n36#1:88\n36#1:90\n36#1:91\n36#1:89\n20#1:92\n*E\n"})
public final class DockerProjectRunConfigurationGenerator
implements ExternalRunConfigurationGeneratorExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public DockerProjectRunConfigurationGenerator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Pair<RunnableProject, RunnerAndConfigurationSettings>> generateConfigurations(@NotNull List<RunnableProject> runnableProjects, @NotNull AutoGeneratedRunConfigurationManager autoGeneratedRunConfigurationManager, @NotNull RunManager runManager) {
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(runnableProjects, (String)"runnableProjects");
        Intrinsics.checkNotNullParameter((Object)autoGeneratedRunConfigurationManager, (String)"autoGeneratedRunConfigurationManager");
        Intrinsics.checkNotNullParameter((Object)runManager, (String)"runManager");
        Iterable $this$filter$iv = runnableProjects;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RunnableProject it = (RunnableProject)element$iv$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)it.getKind(), (Object)RunnableProjectKinds.INSTANCE.getDocker()) && !RunConfigurationHelper.INSTANCE.hasConfigurationForNameAndTypeId(runManager, it.getName(), DockerCloudType.getRunConfigurationType().getId()) && !autoGeneratedRunConfigurationManager.hasRunConfigurationEverBeenGenerated(it.getProjectFilePath(), it.getKind());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List applicableProjects = (List)destination$iv$iv;
        List existingConfigPaths = CollectionsKt.toMutableList((Collection)RunManagerExtensionsKt.getDockerDeploymentSourceFilePaths(runManager, this.project));
        Iterable $this$mapNotNull$iv = applicableProjects;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RunnableProject it = (RunnableProject)element$iv$iv;
            boolean bl3 = false;
            if (this.generateConfigurationForProject(it, existingConfigPaths) == null) {
                pair = null;
            } else {
                Pair<String, RunnerAndConfigurationSettings> pair2;
                String dockerfileFilePath = (String)pair2.component1();
                RunnerAndConfigurationSettings configuration = (RunnerAndConfigurationSettings)pair2.component2();
                runManager.addConfiguration(configuration);
                existingConfigPaths.add(dockerfileFilePath);
                autoGeneratedRunConfigurationManager.markProjectAsAutoGenerated(it.getProjectFilePath(), it.getKind());
                pair = TuplesKt.to((Object)it, (Object)configuration);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final Pair<String, RunnerAndConfigurationSettings> generateConfigurationForProject(RunnableProject runnableProject, List<String> existingConfigPaths) {
        String string;
        String string2;
        String string3;
        String string4;
        String string5 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerfileFilePath);
        if (string5 == null) {
            return null;
        }
        String dockerfileFilePath = string5;
        if (existingConfigPaths.contains(dockerfileFilePath)) {
            return null;
        }
        LOG.trace("Generating run configuration for the runnable project " + runnableProject.getProjectFilePath());
        DockerfileRunConfigurationService runConfigurationService = DockerfileRunConfigurationService.Companion.getInstance(this.project);
        String string6 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerfileContext);
        String string7 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerfileBuildArguments);
        String string8 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerfileRunArguments);
        String string9 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerfileTag);
        String string10 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerfileContainerName);
        String string11 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerfilePublishAllPorts);
        if (string11 != null) {
            String string12 = string11.toLowerCase(Locale.ROOT);
            string4 = string12;
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"toLowerCase(...)");
        } else {
            string4 = null;
        }
        Boolean bl = Intrinsics.areEqual((Object)string4, (Object)"true");
        String string13 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerfileHttpPort);
        Integer n = string13 != null ? StringsKt.toIntOrNull((String)string13) : null;
        String string14 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerfileSslPort);
        Integer n2 = string14 != null ? StringsKt.toIntOrNull((String)string14) : null;
        String string15 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerDevelopmentMode);
        if (string15 != null) {
            String string16 = string15.toLowerCase(Locale.ROOT);
            string3 = string16;
            Intrinsics.checkNotNullExpressionValue((Object)string16, (String)"toLowerCase(...)");
        } else {
            string3 = null;
        }
        Boolean bl2 = Intrinsics.areEqual((Object)string3, (Object)"regular");
        String string17 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerUseSsl);
        if (string17 != null) {
            String string18 = string17.toLowerCase(Locale.ROOT);
            string2 = string18;
            Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"toLowerCase(...)");
        } else {
            string2 = null;
        }
        Boolean bl3 = Intrinsics.areEqual((Object)string2, (Object)"true");
        String string19 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerRootless);
        if (string19 != null) {
            String string20 = string19.toLowerCase(Locale.ROOT);
            string = string20;
            Intrinsics.checkNotNullExpressionValue((Object)string20, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        DockerfileRunConfigurationService.DockerfileRunConfigurationParameters parameters = new DockerfileRunConfigurationService.DockerfileRunConfigurationParameters(dockerfileFilePath, string6, string7, string8, string9, string10, bl, n, n2, bl2, bl3, Intrinsics.areEqual((Object)string, (Object)"true"));
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runConfigurationService.createRunConfiguration(parameters);
        if (runnerAndConfigurationSettings == null) {
            return null;
        }
        RunnerAndConfigurationSettings configuration = runnerAndConfigurationSettings;
        RiderDockerStatisticsCollector.INSTANCE.configFromCsprojCreated();
        return TuplesKt.to((Object)dockerfileFilePath, (Object)configuration);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerProjectRunConfigurationGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerProjectRunConfigurationGenerator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

