/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.runConfiguration;

import com.intellij.docker.DockerCloudType;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.jetbrains.rider.model.Key;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.plugins.appender.docker.runConfiguration.DockerComposeRunConfigurationService;
import com.jetbrains.rider.plugins.appender.docker.runConfiguration.RunManagerExtensionsKt;
import com.jetbrains.rider.plugins.appender.docker.statistics.RiderDockerStatisticsCollector;
import com.jetbrains.rider.run.AutoGeneratedRunConfigurationManager;
import com.jetbrains.rider.run.ExternalRunConfigurationGeneratorExtension;
import com.jetbrains.rider.run.configurations.RunConfigurationHelper;
import com.jetbrains.rider.run.configurations.RunnableProjectKinds;
import com.jetbrains.rider.run.configurations.project.RunnableProjectExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\fH\u0002J8\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\u00060\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeProjectRunConfigurationGenerator;", "Lcom/jetbrains/rider/run/ExternalRunConfigurationGeneratorExtension;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "generateConfigurationForProject", "Lkotlin/Pair;", "", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runnableProject", "Lcom/jetbrains/rider/model/RunnableProject;", "existingConfigPaths", "", "generateConfigurations", "runnableProjects", "autoGeneratedRunConfigurationManager", "Lcom/jetbrains/rider/run/AutoGeneratedRunConfigurationManager;", "runManager", "Lcom/intellij/execution/RunManager;", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDockerComposeProjectRunConfigurationGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeProjectRunConfigurationGenerator.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeProjectRunConfigurationGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,69:1\n766#2:70\n857#2,2:71\n1603#2,9:73\n1855#2:82\n1856#2:84\n1612#2:85\n1#3:83\n13#4:86\n*S KotlinDebug\n*F\n+ 1 DockerComposeProjectRunConfigurationGenerator.kt\ncom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeProjectRunConfigurationGenerator\n*L\n28#1:70\n28#1:71,2\n36#1:73,9\n36#1:82\n36#1:84\n36#1:85\n36#1:83\n20#1:86\n*E\n"})
public final class DockerComposeProjectRunConfigurationGenerator
implements ExternalRunConfigurationGeneratorExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private static final Logger LOG;

    public DockerComposeProjectRunConfigurationGenerator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Pair<RunnableProject, RunnerAndConfigurationSettings>> generateConfigurations(@NotNull List<RunnableProject> runnableProjects, @NotNull AutoGeneratedRunConfigurationManager autoGeneratedRunConfigurationManager, @NotNull RunManager runManager) {
        void $this$mapNotNullTo$iv$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(runnableProjects, (String)"runnableProjects");
        Intrinsics.checkNotNullParameter((Object)autoGeneratedRunConfigurationManager, (String)"autoGeneratedRunConfigurationManager");
        Intrinsics.checkNotNullParameter((Object)runManager, (String)"runManager");
        Iterable $this$filter$iv = runnableProjects;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            RunnableProject it = (RunnableProject)element$iv$iv;
            boolean bl = false;
            boolean bl2 = Intrinsics.areEqual((Object)it.getKind(), (Object)RunnableProjectKinds.INSTANCE.getDockerCompose()) && !RunConfigurationHelper.INSTANCE.hasConfigurationForNameAndTypeId(runManager, it.getName(), DockerCloudType.getRunConfigurationType().getId()) && !autoGeneratedRunConfigurationManager.hasRunConfigurationEverBeenGenerated(it.getProjectFilePath(), it.getKind());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List applicableProjects = (List)destination$iv$iv;
        List existingConfigPaths = CollectionsKt.toMutableList((Collection)RunManagerExtensionsKt.getDockerDeploymentSourceFilePaths(runManager, this.project));
        Iterable $this$mapNotNull$iv = applicableProjects;
        boolean $i$f$mapNotNull = false;
        destination$iv$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            RunnableProject it = (RunnableProject)element$iv$iv;
            boolean bl3 = false;
            if (this.generateConfigurationForProject(it, existingConfigPaths) == null) {
                pair = null;
            } else {
                Pair<String, RunnerAndConfigurationSettings> pair2;
                String composeFilePath = (String)pair2.component1();
                RunnerAndConfigurationSettings configuration = (RunnerAndConfigurationSettings)pair2.component2();
                runManager.addConfiguration(configuration);
                existingConfigPaths.add(composeFilePath);
                autoGeneratedRunConfigurationManager.markProjectAsAutoGenerated(it.getProjectFilePath(), it.getKind());
                pair = TuplesKt.to((Object)it, (Object)configuration);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        return (List)destination$iv$iv2;
    }

    private final Pair<String, RunnerAndConfigurationSettings> generateConfigurationForProject(RunnableProject runnableProject, List<String> existingConfigPaths) {
        String string;
        String string2;
        List list2;
        String string3 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.ComposeFilePath);
        if (string3 == null) {
            return null;
        }
        String composeFilePath = string3;
        if (existingConfigPaths.contains(composeFilePath)) {
            return null;
        }
        LOG.trace("Generating run configuration for the runnable project " + runnableProject.getProjectFilePath());
        DockerComposeRunConfigurationService runConfigurationService = DockerComposeRunConfigurationService.Companion.getInstance(this.project);
        String string4 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.ComposeOverrideFilePath);
        String string5 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.ComposeAdditionalFilePaths);
        if (string5 != null) {
            char[] cArray = new char[]{';'};
            list2 = StringsKt.split$default((CharSequence)string5, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        } else {
            list2 = null;
        }
        String string6 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.ComposeProjectName);
        String string7 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerDevelopmentMode);
        if (string7 != null) {
            String string8 = string7.toLowerCase(Locale.ROOT);
            string2 = string8;
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
        } else {
            string2 = null;
        }
        Boolean bl = Intrinsics.areEqual((Object)string2, (Object)"regular");
        String string9 = RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerUseSsl);
        if (string9 != null) {
            String string10 = string9.toLowerCase(Locale.ROOT);
            string = string10;
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        DockerComposeRunConfigurationService.DockerComposeRunConfigurationParameters parameters = new DockerComposeRunConfigurationService.DockerComposeRunConfigurationParameters(composeFilePath, string4, list2, string6, bl, Intrinsics.areEqual((Object)string, (Object)"true"));
        RunnerAndConfigurationSettings runnerAndConfigurationSettings = runConfigurationService.createRunConfiguration(parameters);
        if (runnerAndConfigurationSettings == null) {
            return null;
        }
        RunnerAndConfigurationSettings configuration = runnerAndConfigurationSettings;
        RiderDockerStatisticsCollector.INSTANCE.configFromDcprojCreated();
        return TuplesKt.to((Object)composeFilePath, (Object)configuration);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DockerComposeProjectRunConfigurationGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/runConfiguration/DockerComposeProjectRunConfigurationGenerator$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

