/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.debug.providers;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.model.TfmInfo;
import com.jetbrains.rider.model.debuggerWorker.DebuggerStartInfoBase;
import com.jetbrains.rider.model.debuggerWorker.DotNetCoreExeStartInfo;
import com.jetbrains.rider.model.debuggerWorker.DotNetCoreInfo;
import com.jetbrains.rider.plugins.appender.docker.RiderDockerBundle;
import com.jetbrains.rider.plugins.appender.docker.common.DockerContainerType;
import com.jetbrains.rider.plugins.appender.docker.common.DockerExecutionInstruction;
import com.jetbrains.rider.plugins.appender.docker.common.RiderDockerConfigurationInfo;
import com.jetbrains.rider.plugins.appender.docker.debug.RiderDockerFileParsingUtil;
import com.jetbrains.rider.plugins.appender.docker.debug.providers.IRiderDockerDebugProvider;
import com.jetbrains.rider.plugins.appender.docker.debug.providers.RiderDockerDebugTargetType;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\b\u0010\u0007\u001a\u00020\u0006H\u0016J-\u0010\b\u001a\u0004\u0018\u00010\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0018\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0016H\u0002J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u0016H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/DotNetCoreDockerDebugProvider;", "Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/IRiderDockerDebugProvider;", "()V", "checkPossibleDotNetRuntimes", "", "cmdName", "", "getDebuggerKey", "getDebuggerStartInfo", "Lcom/jetbrains/rider/model/debuggerWorker/DebuggerStartInfoBase;", "commandToRun", "", "workingDir", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "([Ljava/lang/String;Ljava/lang/String;Lcom/intellij/execution/runners/ExecutionEnvironment;)Lcom/jetbrains/rider/model/debuggerWorker/DebuggerStartInfoBase;", "getPriority", "", "getTargetType", "Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/RiderDockerDebugTargetType;", "isApplicable", "startInfo", "Lcom/jetbrains/rider/plugins/appender/docker/common/RiderDockerConfigurationInfo;", "isExe", "configurationInfo", "isLooksLikeAsIsExe", "isNetCore", "dockerConfigurationInfo", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDotNetCoreDockerDebugProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DotNetCoreDockerDebugProvider.kt\ncom/jetbrains/rider/plugins/appender/docker/debug/providers/DotNetCoreDockerDebugProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,118:1\n766#2:119\n857#2,2:120\n350#2,7:122\n13#3:129\n13#4:130\n*S KotlinDebug\n*F\n+ 1 DotNetCoreDockerDebugProvider.kt\ncom/jetbrains/rider/plugins/appender/docker/debug/providers/DotNetCoreDockerDebugProvider\n*L\n47#1:119\n47#1:120,2\n57#1:122,7\n20#1:129\n20#1:130\n*E\n"})
public final class DotNetCoreDockerDebugProvider
implements IRiderDockerDebugProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @Override
    public int getPriority() {
        return 0;
    }

    @Override
    public boolean isApplicable(@NotNull RiderDockerConfigurationInfo startInfo) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)startInfo, (String)"startInfo");
        DockerExecutionInstruction<String> dockerExecutionInstruction = startInfo.getEntrypoint();
        if ((dockerExecutionInstruction == null || (dockerExecutionInstruction = dockerExecutionInstruction.getCommand()) == null || (dockerExecutionInstruction = (String)CollectionsKt.firstOrNull((List)((Object)dockerExecutionInstruction))) == null) && ((object = startInfo.getCmd()) != null && (object = ((DockerExecutionInstruction)object).getCommand()) != null ? (String)CollectionsKt.firstOrNull((List)object) : (dockerExecutionInstruction = null)) == null) {
            return false;
        }
        DockerExecutionInstruction<String> possibleDotnetCmdShortName = dockerExecutionInstruction;
        return this.checkPossibleDotNetRuntimes((String)((Object)possibleDotnetCmdShortName)) || this.isLooksLikeAsIsExe((String)((Object)possibleDotnetCmdShortName), startInfo);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public DebuggerStartInfoBase getDebuggerStartInfo(@NotNull String[] commandToRun, @NotNull String workingDir, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)commandToRun, (String)"commandToRun");
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        logger.info("Getting appropriate start info model for command [" + ArraysKt.joinToString$default((Object[])commandToRun, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + "]");
        String executable = (String)ArraysKt.first((Object[])commandToRun);
        List commandTail = ArraysKt.drop((Object[])commandToRun, (int)1);
        String runtimeArguments = null;
        String targetArguments = null;
        String targetExe = null;
        boolean executeAsIs = false;
        if (this.checkPossibleDotNetRuntimes(executable)) {
            int indexOfExecutable;
            List arguments;
            block7: {
                int n;
                void $this$filterTo$iv$iv;
                executeAsIs = false;
                Iterable $this$filter$iv = commandTail;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    String it = (String)element$iv$iv;
                    boolean bl = false;
                    boolean bl2 = !StringsKt.isBlank((CharSequence)it);
                    if (!bl2) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                arguments = (List)destination$iv$iv;
                if (arguments.isEmpty()) {
                    ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)new ExecutionException(RiderDockerBundle.Companion.message("rider.docker.container.entrypoint.error", new Object[0])));
                    return null;
                }
                List $this$indexOfFirst$iv = arguments;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    String it = (String)item$iv;
                    boolean bl = false;
                    if (StringsKt.endsWith((String)it, (String)".dll", (boolean)true) || StringsKt.endsWith((String)it, (String)".exe", (boolean)true)) {
                        n = index$iv;
                        break block7;
                    }
                    ++index$iv;
                }
                n = indexOfExecutable = -1;
            }
            if (indexOfExecutable < 0) {
                Object[] objectArray = new Object[]{ArraysKt.joinToString$default((Object[])commandToRun, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)};
                ExecutionUtil.handleExecutionError((ExecutionEnvironment)environment, (ExecutionException)new ExecutionException(RiderDockerBundle.Companion.message("rider.docker.can.not.find.target.executable", objectArray)));
                return null;
            }
            targetExe = (String)arguments.get(indexOfExecutable);
            runtimeArguments = CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)0, (int)indexOfExecutable)), (CharSequence)" ", null, null, (int)0, null, (Function1)((Function1)new Function1<Integer, CharSequence>((List<String>)arguments){
                final /* synthetic */ List<String> $arguments;
                {
                    this.$arguments = $arguments;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(int it) {
                    return this.$arguments.get(it);
                }
            }), (int)30, null);
            targetArguments = CollectionsKt.joinToString$default((Iterable)((Iterable)RangesKt.until((int)(indexOfExecutable + 1), (int)arguments.size())), (CharSequence)" ", null, null, (int)0, null, (Function1)((Function1)new Function1<Integer, CharSequence>((List<String>)arguments){
                final /* synthetic */ List<String> $arguments;
                {
                    this.$arguments = $arguments;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(int it) {
                    return this.$arguments.get(it);
                }
            }), (int)30, null);
        } else {
            targetExe = executable;
            executeAsIs = true;
            runtimeArguments = null;
            targetArguments = CollectionsKt.joinToString$default((Iterable)commandTail, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        }
        return (DebuggerStartInfoBase)new DotNetCoreExeStartInfo(new DotNetCoreInfo(null), null, targetExe, workingDir, targetArguments, CollectionsKt.emptyList(), runtimeArguments, executeAsIs, false);
    }

    @Override
    @NotNull
    public RiderDockerDebugTargetType getTargetType() {
        return RiderDockerDebugTargetType.NET_CORE;
    }

    @Override
    @NotNull
    public String getDebuggerKey() {
        return "netcore";
    }

    private final boolean isLooksLikeAsIsExe(String cmdName, RiderDockerConfigurationInfo configurationInfo) {
        return this.isExe(cmdName, configurationInfo) && this.isNetCore(configurationInfo);
    }

    private final boolean isNetCore(RiderDockerConfigurationInfo dockerConfigurationInfo) {
        TfmInfo tfmInfo = RiderDockerFileParsingUtil.INSTANCE.getTargetFramework(dockerConfigurationInfo);
        return tfmInfo != null ? tfmInfo.isCore() : false;
    }

    private final boolean isExe(String cmdName, RiderDockerConfigurationInfo configurationInfo) {
        DockerContainerType containerOs = configurationInfo.getLaunchLayerOrThrow().getContainerType();
        return containerOs == DockerContainerType.Windows ? StringsKt.endsWith((String)cmdName, (String)".exe", (boolean)true) : !StringsKt.endsWith((String)cmdName, (String)".exe", (boolean)true) && !StringsKt.endsWith((String)cmdName, (String)".dll", (boolean)true);
    }

    private final boolean checkPossibleDotNetRuntimes(String cmdName) {
        return DotNetCoreRuntime.Companion.getPossibleDotNetCoreExecutables().contains(new File(cmdName).getName());
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DotNetCoreDockerDebugProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        DotNetCoreDockerDebugProvider.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/debug/providers/DotNetCoreDockerDebugProvider$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.rider.plugins.appender"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

