/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.debug;

import com.intellij.execution.Platform;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.rd.util.UserDataHolderKt;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.Version;
import com.jetbrains.rd.framework.IProtocol;
import com.jetbrains.rd.framework.IRdCall;
import com.jetbrains.rd.framework.IRdDynamic;
import com.jetbrains.rd.framework.InterfacesKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdclient.util.idea.ExtensionsKt;
import com.jetbrains.rider.model.DebuggerDockerHelperHost;
import com.jetbrains.rider.model.DotnetProjectProperties;
import com.jetbrains.rider.model.TfmInfo;
import com.jetbrains.rider.plugins.appender.docker.RiderDockerBundle;
import com.jetbrains.rider.plugins.appender.docker.common.DockerExecutionInstruction;
import com.jetbrains.rider.plugins.appender.docker.common.RiderDockerConfigurationInfo;
import com.jetbrains.rider.plugins.appender.docker.common.RiderDockerfileLayer;
import com.jetbrains.rider.plugins.appender.docker.debug.DebuggerDockerHelperHostUtilKt;
import com.jetbrains.rider.plugins.appender.docker.debug.RiderDockerFileParsingUtil;
import com.jetbrains.rider.runtime.dotNetCore.DotNetCoreRuntime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\f\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\rR\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/debug/RiderDockerFileParsingUtil;", "", "()V", "dotnetCommandPartMarkers", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "frameworkParameterKeys", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getProjectName", "dockerStartInfo", "Lcom/jetbrains/rider/plugins/appender/docker/common/RiderDockerConfigurationInfo;", "isTfmCore", "", "version", "getTargetFramework", "Lcom/jetbrains/rider/model/TfmInfo;", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nRiderDockerFileParsingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDockerFileParsingUtil.kt\ncom/jetbrains/rider/plugins/appender/docker/debug/RiderDockerFileParsingUtil\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,117:1\n9972#2:118\n10394#2,5:119\n1627#2,2:126\n1629#2,4:131\n1735#2,6:139\n766#3:124\n857#3:125\n1747#3,3:128\n1747#3,3:135\n858#3:138\n1603#3,9:145\n1855#3:154\n1747#3,3:155\n1856#3:159\n1612#3:160\n1#4:158\n23#5:161\n13#5:163\n13#6:162\n*S KotlinDebug\n*F\n+ 1 RiderDockerFileParsingUtil.kt\ncom/jetbrains/rider/plugins/appender/docker/debug/RiderDockerFileParsingUtil\n*L\n36#1:118\n36#1:119,5\n38#1:126,2\n38#1:131,4\n60#1:139,6\n37#1:124\n37#1:125\n39#1:128,3\n46#1:135,3\n37#1:138\n77#1:145,9\n77#1:154\n78#1:155,3\n77#1:159\n77#1:160\n77#1:158\n95#1:161\n19#1:163\n19#1:162\n*E\n"})
public final class RiderDockerFileParsingUtil {
    @NotNull
    public static final RiderDockerFileParsingUtil INSTANCE = new RiderDockerFileParsingUtil();
    @NotNull
    private static final HashSet<String> dotnetCommandPartMarkers;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final List<String> frameworkParameterKeys;

    private RiderDockerFileParsingUtil() {
    }

    private final boolean isTfmCore(String version) {
        if (StringsKt.startsWith$default((String)version, (String)"netcoreapp", (boolean)false, (int)2, null)) {
            return true;
        }
        if (!StringsKt.startsWith$default((String)version, (String)"net", (boolean)false, (int)2, null)) {
            return false;
        }
        String numberSuffix = StringsKt.removePrefix((String)version, (CharSequence)"net");
        Version version2 = Version.parseVersion((String)numberSuffix);
        if (version2 == null) {
            return false;
        }
        Version parseVersion = version2;
        return parseVersion.major < 10;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final TfmInfo getTargetFramework(@NotNull RiderDockerConfigurationInfo $this$getTargetFramework) {
        int indexOfFramework;
        String[] lastCommand;
        block20: {
            int n;
            void $this$filterTo$iv$iv;
            Iterable $this$flatMapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$this$getTargetFramework, (String)"<this>");
            RiderDockerfileLayer[] $this$flatMap$iv = $this$getTargetFramework.getLayers();
            boolean $i$f$flatMap = false;
            RiderDockerfileLayer[] riderDockerfileLayerArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            int n2 = ((void)$this$flatMapTo$iv$iv).length;
            for (int i = 0; i < n2; ++i) {
                void element$iv$iv;
                void layer = element$iv$iv = $this$flatMapTo$iv$iv[i];
                boolean bl = false;
                Iterable list$iv$iv = ArraysKt.toList((Object[])((Object[])layer.getRunCommands()));
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$flatMapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block19: {
                    int dotnetCommand;
                    Object[] runCommandParts;
                    block18: {
                        int n3;
                        runCommandParts = (String[])element$iv$iv;
                        boolean bl2 = false;
                        Object[] $this$indexOfFirst$iv = runCommandParts;
                        boolean $i$f$indexOfFirst = false;
                        int n4 = $this$indexOfFirst$iv.length;
                        for (int index$iv = 0; index$iv < n4; ++index$iv) {
                            boolean bl3;
                            block17: {
                                String part = $this$indexOfFirst$iv[index$iv];
                                boolean bl4 = false;
                                Iterable $this$any$iv = DotNetCoreRuntime.Companion.getPossibleDotNetCoreExecutables();
                                boolean $i$f$any = false;
                                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                    bl3 = false;
                                } else {
                                    for (Object element$iv : $this$any$iv) {
                                        String it = (String)element$iv;
                                        boolean bl5 = false;
                                        if (!StringsKt.endsWith((String)part, (String)it, (boolean)true)) continue;
                                        bl3 = true;
                                        break block17;
                                    }
                                    bl3 = false;
                                }
                            }
                            if (!bl3) continue;
                            n3 = index$iv;
                            break block18;
                        }
                        n3 = dotnetCommand = -1;
                    }
                    if (dotnetCommand < 0) {
                        bl = false;
                    } else {
                        Iterable $this$any$iv = ArraysKt.drop((Object[])runCommandParts, (int)(dotnetCommand + 1));
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                String it = (String)element$iv;
                                boolean bl6 = false;
                                String string = it.toLowerCase(Locale.ROOT);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                                if (!dotnetCommandPartMarkers.contains(string)) continue;
                                bl = true;
                                break block19;
                            }
                            bl = false;
                        }
                    }
                }
                if (!bl) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List dotnetCommands = (List)destination$iv$iv;
            logger.info("Validating project file target framework");
            String string = System.lineSeparator();
            Iterable iterable = dotnetCommands;
            String string2 = System.lineSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lineSeparator(...)");
            logger.info("Found several run commands: " + string + CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string2, null, null, (int)0, null, (Function1)getTargetFramework.1.INSTANCE, (int)30, null));
            String[] stringArray = (String[])CollectionsKt.lastOrNull((List)dotnetCommands);
            if (stringArray == null) {
                return null;
            }
            String[] $this$indexOfLast$iv = lastCommand = stringArray;
            boolean $i$f$indexOfLast = false;
            int n5 = $this$indexOfLast$iv.length + -1;
            if (0 <= n5) {
                do {
                    int index$iv = n5--;
                    String it = $this$indexOfLast$iv[index$iv];
                    boolean bl = false;
                    if (!frameworkParameterKeys.contains(it)) continue;
                    n = index$iv;
                    break block20;
                } while (0 <= n5);
            }
            n = indexOfFramework = -1;
        }
        if (indexOfFramework >= 0) {
            if (lastCommand.length > indexOfFramework + 1) {
                String tfm = lastCommand[indexOfFramework + 1];
                return new TfmInfo(tfm, this.isTfmCore(tfm));
            }
            logger.warn("Framework parameter key is the last");
        }
        String string = this.getProjectName($this$getTargetFramework);
        if (string == null) {
            return null;
        }
        String projectName = string;
        DebuggerDockerHelperHost debuggerDockerHelper = DebuggerDockerHelperHostUtilKt.getDebuggerDockerHelper($this$getTargetFramework.getProject());
        return (TfmInfo)ExtensionsKt.callSynchronously$default((IRdCall)((IRdCall)debuggerDockerHelper.getGetTfm()), (Object)new DotnetProjectProperties(projectName, null), (IProtocol)InterfacesKt.getProtocolOrThrow((IRdDynamic)((IRdDynamic)debuggerDockerHelper)), (Lifetime)UserDataHolderKt.getLifetime((UserDataHolder)((UserDataHolder)$this$getTargetFramework.getProject())), null, null, (int)24, null);
    }

    @Nullable
    public final String getProjectName(@NotNull RiderDockerConfigurationInfo dockerStartInfo) {
        List<String> cmd;
        List<String> entrypoint;
        Intrinsics.checkNotNullParameter((Object)dockerStartInfo, (String)"dockerStartInfo");
        String possibleProjectName = null;
        DockerExecutionInstruction<String> dockerExecutionInstruction = dockerStartInfo.getEntrypoint();
        List<String> list2 = entrypoint = dockerExecutionInstruction != null ? dockerExecutionInstruction.getCommand() : null;
        if (entrypoint != null) {
            possibleProjectName = RiderDockerFileParsingUtil.getProjectName$tryGetProjectNameFromExecutableCommandLine(entrypoint);
        }
        DockerExecutionInstruction<String> dockerExecutionInstruction2 = dockerStartInfo.getCmd();
        List<String> list3 = cmd = dockerExecutionInstruction2 != null ? dockerExecutionInstruction2.getCommand() : null;
        if (possibleProjectName == null && cmd != null) {
            possibleProjectName = RiderDockerFileParsingUtil.getProjectName$tryGetProjectNameFromExecutableCommandLine(cmd);
        }
        if (possibleProjectName == null) {
            logger.warn(RiderDockerBundle.Companion.message("rider.docker.can.not.determine.the.project", new Object[0]));
            return null;
        }
        return possibleProjectName;
    }

    /*
     * WARNING - void declaration
     */
    private static final String getProjectName$tryGetProjectNameFromExecutableCommandLine(List<String> parameters) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = parameters;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            boolean bl;
            String it;
            block13: {
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                it = (String)element$iv$iv;
                boolean bl3 = false;
                Iterable $this$any$iv = DotNetCoreRuntime.Companion.getPossibleDotNetCoreExecutables();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String exec = (String)element$iv;
                        boolean bl4 = false;
                        if (!StringsKt.endsWith((String)it, (String)exec, (boolean)true)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                string = null;
            } else if (StringsKt.endsWith$default((String)it, (String)".dll", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)it, (String)".exe", (boolean)false, (int)2, null)) {
                Object object = new char[1];
                object[0] = 46;
                if ((String)CollectionsKt.lastOrNull((List)CollectionsKt.dropLast((List)StringsKt.split$default((CharSequence)it, (char[])object, (boolean)false, (int)0, (int)6, null), (int)1)) == null) {
                    string = null;
                } else {
                    String withoutExtension;
                    boolean isPathToExecutable;
                    boolean bl5 = isPathToExecutable = StringsKt.contains$default((CharSequence)withoutExtension, (char)Platform.WINDOWS.fileSeparator, (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)withoutExtension, (char)Platform.UNIX.fileSeparator, (boolean)false, (int)2, null);
                    if (isPathToExecutable) {
                        object = new char[2];
                        object[0] = Platform.WINDOWS.fileSeparator;
                        object[1] = Platform.UNIX.fileSeparator;
                        string = (String)CollectionsKt.last((List)StringsKt.split$default((CharSequence)withoutExtension, (char[])object, (boolean)false, (int)0, (int)6, null));
                    } else {
                        string = withoutExtension;
                    }
                }
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List dllOrExeToExecute = (List)destination$iv$iv;
        if (dllOrExeToExecute.size() > 1) {
            RiderDockerFileParsingUtil $this$thisLogger$iv = INSTANCE;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(RiderDockerFileParsingUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("There are several candidates among executable files to be parsed as project name: " + CollectionsKt.joinToString$default((Iterable)dllOrExeToExecute, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
        }
        return (String)CollectionsKt.firstOrNull((List)dllOrExeToExecute);
    }

    static {
        Object[] objectArray = new String[]{"restore", "build", "publish"};
        dotnetCommandPartMarkers = SetsKt.hashSetOf((Object[])objectArray);
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderDockerFileParsingUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderDockerFileParsingUtil.logger = logger;
        Object[] objectArray2 = new String[]{"-f", "--fx-version"};
        frameworkParameterKeys = CollectionsKt.listOf((Object[])objectArray2);
    }
}

