/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.debug;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.docker.DockerIcons;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rider.plugins.appender.docker.RiderDockerBundle;
import com.jetbrains.rider.plugins.appender.docker.debug.RiderAllowedRootsState;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/debug/RiderDockerAllowedRootsUtil;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "checkRiderRootIsAllowed", "Lcom/jetbrains/rider/plugins/appender/docker/debug/RiderAllowedRootsState;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nRiderDockerAllowedRootsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDockerAllowedRootsUtil.kt\ncom/jetbrains/rider/plugins/appender/docker/debug/RiderDockerAllowedRootsUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,111:1\n1549#2:112\n1620#2,3:113\n1747#2,3:116\n1747#2,3:119\n766#2:122\n857#2,2:123\n13#3:125\n13#4:126\n*S KotlinDebug\n*F\n+ 1 RiderDockerAllowedRootsUtil.kt\ncom/jetbrains/rider/plugins/appender/docker/debug/RiderDockerAllowedRootsUtil\n*L\n63#1:112\n63#1:113,3\n64#1:116,3\n66#1:119,3\n78#1:122\n78#1:123,2\n27#1:125\n27#1:126\n*E\n"})
public final class RiderDockerAllowedRootsUtil {
    @NotNull
    public static final RiderDockerAllowedRootsUtil INSTANCE = new RiderDockerAllowedRootsUtil();
    @NotNull
    private static final Logger logger;

    private RiderDockerAllowedRootsUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final RiderAllowedRootsState checkRiderRootIsAllowed(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        try {
            void $this$filterTo$iv$iv;
            boolean bl;
            boolean isLogsDirShared;
            JsonArray fileSharingDirectoriesElement;
            JsonObject settingsElement;
            File settingsFile;
            File installationDir;
            block19: {
                File it;
                boolean bl2;
                boolean $i$f$any;
                Iterable $this$any$iv;
                List roots;
                block18: {
                    void $this$mapTo$iv$iv;
                    if (!SystemInfo.isMac) {
                        return RiderAllowedRootsState.Companion.getUnknown();
                    }
                    installationDir = new File(PathManager.getHomePath());
                    File logsDir = new File(PathManager.getLogPath());
                    String homeDirectory = System.getProperty("user.home");
                    File dockerSettingsDir = new File(homeDirectory + "/Library/Group Containers/group.com.docker");
                    if (!dockerSettingsDir.exists()) {
                        logger.warn("Unable to get Docker setting dir ('" + dockerSettingsDir + "')");
                        return RiderAllowedRootsState.Companion.getUnknown();
                    }
                    settingsFile = new File(dockerSettingsDir, "settings.json");
                    if (!settingsFile.exists()) {
                        logger.warn("Unable to get Docker settings file ('" + settingsFile + "')");
                        return RiderAllowedRootsState.Companion.getUnknown();
                    }
                    File file = settingsFile;
                    Charset charset = Charsets.UTF_8;
                    JsonElement jsonElement = JsonParser.parseReader((Reader)new InputStreamReader((InputStream)new FileInputStream(file), charset));
                    JsonObject jsonObject = settingsElement = jsonElement instanceof JsonObject ? (JsonObject)jsonElement : null;
                    if (settingsElement == null) {
                        logger.warn("Settings root is not an " + JsonObject.class.getName());
                        return RiderAllowedRootsState.Companion.getUnknown();
                    }
                    file = settingsElement.get("filesharingDirectories");
                    JsonArray jsonArray = fileSharingDirectoriesElement = file instanceof JsonArray ? (JsonArray)file : null;
                    if (fileSharingDirectoriesElement == null) {
                        logger.warn("Can't find file sharing directories setting");
                        return RiderAllowedRootsState.Companion.getUnknown();
                    }
                    Iterable $this$map$iv = (Iterable)fileSharingDirectoriesElement;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Iterator destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it2;
                        JsonElement jsonElement2 = (JsonElement)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl3 = false;
                        collection.add(new File(it2.getAsJsonPrimitive().getAsString()));
                    }
                    roots = (List)((Object)destination$iv$iv);
                    $this$any$iv = roots;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (File)element$iv;
                            boolean bl4 = false;
                            if (!FilesKt.startsWith((File)logsDir, (File)it)) continue;
                            bl2 = true;
                            break block18;
                        }
                        bl2 = false;
                    }
                }
                isLogsDirShared = bl2;
                $this$any$iv = roots;
                $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (File)element$iv;
                        boolean bl5 = false;
                        if (!FilesKt.startsWith((File)installationDir, (File)it)) continue;
                        bl = true;
                        break block19;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return new RiderAllowedRootsState(true, isLogsDirShared);
            }
            if (!settingsFile.canWrite()) {
                logger.warn("Can't write to settings file");
                return new RiderAllowedRootsState(true, isLogsDirShared);
            }
            Ref.BooleanRef userAllowed = new Ref.BooleanRef();
            String message = RiderDockerBundle.Companion.message("rider.docker.allowed.dirs.update.message", new Object[0]);
            char[] element$iv = new char[]{'%'};
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)message, (char[])element$iv, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter = false;
            Iterable bl5 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl6 = false;
                boolean bl7 = ((CharSequence)it).length() > 0;
                if (!bl7) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List messageParts = (List)destination$iv$iv;
            String usualText = (String)messageParts.get(0);
            String linkText = (String)messageParts.get(1);
            ApplicationKt.getApplication().invokeAndWait(() -> RiderDockerAllowedRootsUtil.checkRiderRootIsAllowed$lambda$4(usualText, linkText, userAllowed, project));
            if (!userAllowed.element) {
                return new RiderAllowedRootsState(false, isLogsDirShared);
            }
            fileSharingDirectoriesElement.add(installationDir.getAbsolutePath());
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String string = gson.toJson((JsonElement)settingsElement);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(...)");
            FilesKt.writeText$default((File)settingsFile, (String)string, null, (int)2, null);
            return new RiderAllowedRootsState(true, isLogsDirShared);
        }
        catch (Throwable t) {
            logger.error(t);
            return RiderAllowedRootsState.Companion.getUnknown();
        }
    }

    private static final void checkRiderRootIsAllowed$lambda$4(String $usualText, String $linkText, Ref.BooleanRef $userAllowed, Project $project) {
        Intrinsics.checkNotNullParameter((Object)$usualText, (String)"$usualText");
        Intrinsics.checkNotNullParameter((Object)$linkText, (String)"$linkText");
        Intrinsics.checkNotNullParameter((Object)$userAllowed, (String)"$userAllowed");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        String string = RiderDockerBundle.Companion.message("rider.docker.allowed.dirs.update.title", new Object[0]);
        HtmlChunk[] htmlChunkArray = new HtmlChunk[]{HtmlChunk.text((String)$usualText), HtmlChunk.link((String)"https://docs.docker.com/desktop/mac/#file-sharing", (String)$linkText)};
        String string2 = HtmlChunk.body().children(htmlChunkArray).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        MessageDialogBuilder.YesNo dialogBuilder = (MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).doNotAsk(null)).yesText(RiderDockerBundle.Companion.message("rider.docker.root.add.message", new Object[0]))).noText(RiderDockerBundle.Companion.message("rider.docker.root.cancel.message", new Object[0]))).icon(DockerIcons.Docker);
        $userAllowed.element = dialogBuilder.ask($project);
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderDockerAllowedRootsUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        RiderDockerAllowedRootsUtil.logger = logger;
    }
}

