/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.common;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.model.Key;
import com.jetbrains.rider.model.RunnableProject;
import com.jetbrains.rider.run.configurations.project.RunnableProjectExKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\u0005J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005J\u0014\u0010\f\u001a\u00020\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/common/RiderProjectDockerfileService;", "", "()V", "dockerfileToManuallyFoundProjectMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "dockerfileToRunnableProjectMap", "getProjectByDockerfile", "dockerfilePath", "putManuallyFoundProject", "", "projectFilePath", "updateRunnableProjects", "runnableProjects", "", "Lcom/jetbrains/rider/model/RunnableProject;", "Companion", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nRiderProjectDockerfileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderProjectDockerfileService.kt\ncom/jetbrains/rider/plugins/appender/docker/common/RiderProjectDockerfileService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,56:1\n13#2:57\n*S KotlinDebug\n*F\n+ 1 RiderProjectDockerfileService.kt\ncom/jetbrains/rider/plugins/appender/docker/common/RiderProjectDockerfileService\n*L\n17#1:57\n*E\n"})
public final class RiderProjectDockerfileService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentHashMap<String, String> dockerfileToRunnableProjectMap = new ConcurrentHashMap();
    @NotNull
    private final ConcurrentHashMap<String, String> dockerfileToManuallyFoundProjectMap = new ConcurrentHashMap();
    @NotNull
    private static final Logger LOG;

    @Nullable
    public final String getProjectByDockerfile(@NotNull String dockerfilePath) {
        Intrinsics.checkNotNullParameter((Object)dockerfilePath, (String)"dockerfilePath");
        String runnableProjectPath = this.dockerfileToRunnableProjectMap.get(dockerfilePath);
        if (runnableProjectPath != null) {
            LOG.debug("Runnable project for Dockerfile " + dockerfilePath + " is " + runnableProjectPath);
            return runnableProjectPath;
        }
        String manuallyAddedProjectPath = this.dockerfileToManuallyFoundProjectMap.get(dockerfilePath);
        if (manuallyAddedProjectPath != null) {
            Path path = Paths.get(manuallyAddedProjectPath, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                LOG.debug("Manually added project for Dockerfile " + dockerfilePath + " is " + manuallyAddedProjectPath);
                return manuallyAddedProjectPath;
            }
        }
        LOG.debug("Unable to find project for Dockerfile " + dockerfilePath);
        return null;
    }

    public final void updateRunnableProjects(@NotNull List<RunnableProject> runnableProjects) {
        Intrinsics.checkNotNullParameter(runnableProjects, (String)"runnableProjects");
        this.dockerfileToRunnableProjectMap.clear();
        if (runnableProjects.isEmpty()) {
            return;
        }
        for (RunnableProject runnableProject : runnableProjects) {
            String dockerfilePath;
            if (RunnableProjectExKt.getCustomAttribute((RunnableProject)runnableProject, (Key)Key.DockerfileFilePath) == null) continue;
            LOG.trace("New runnable project " + runnableProject.getProjectFilePath() + " for Dockerfile " + dockerfilePath);
            ((Map)this.dockerfileToRunnableProjectMap).put(dockerfilePath, runnableProject.getProjectFilePath());
        }
    }

    public final void putManuallyFoundProject(@NotNull String dockerfilePath, @NotNull String projectFilePath) {
        Intrinsics.checkNotNullParameter((Object)dockerfilePath, (String)"dockerfilePath");
        Intrinsics.checkNotNullParameter((Object)projectFilePath, (String)"projectFilePath");
        LOG.trace("New manually found project " + projectFilePath + " for Dockerfile " + dockerfilePath);
        ((Map)this.dockerfileToManuallyFoundProjectMap).put(dockerfilePath, projectFilePath);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(RiderProjectDockerfileService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/common/RiderProjectDockerfileService$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rider/plugins/appender/docker/common/RiderProjectDockerfileService;", "intellij.rider.plugins.appender"})
    @SourceDebugExtension(value={"SMAP\nRiderProjectDockerfileService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderProjectDockerfileService.kt\ncom/jetbrains/rider/plugins/appender/docker/common/RiderProjectDockerfileService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,56:1\n40#2,3:57\n*S KotlinDebug\n*F\n+ 1 RiderProjectDockerfileService.kt\ncom/jetbrains/rider/plugins/appender/docker/common/RiderProjectDockerfileService$Companion\n*L\n16#1:57,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RiderProjectDockerfileService getInstance() {
            boolean $i$f$service = false;
            Class<RiderProjectDockerfileService> serviceClass$iv = RiderProjectDockerfileService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (RiderProjectDockerfileService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

