/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.common;

import com.intellij.openapi.util.NlsSafe;
import com.jetbrains.rider.CPUKind;
import com.jetbrains.rider.plugins.appender.docker.common.DockerContainerType;
import com.jetbrains.rider.plugins.appender.docker.common.DockerExecutionInstruction;
import com.jetbrains.rider.plugins.appender.docker.common.RiderDockerfileBaseImageReferenceBase;
import com.jetbrains.rider.plugins.appender.docker.image.RiderDockerImageProperties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\bH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/common/RiderDockerfileBaseImageReference;", "Lcom/jetbrains/rider/plugins/appender/docker/common/RiderDockerfileBaseImageReferenceBase;", "imageName", "", "properties", "Lcom/jetbrains/rider/plugins/appender/docker/image/RiderDockerImageProperties;", "(Ljava/lang/String;Lcom/jetbrains/rider/plugins/appender/docker/image/RiderDockerImageProperties;)V", "getCmd", "Lcom/jetbrains/rider/plugins/appender/docker/common/DockerExecutionInstruction;", "getContainerType", "Lcom/jetbrains/rider/plugins/appender/docker/common/DockerContainerType;", "getCpuArch", "Lcom/jetbrains/rider/CPUKind;", "getEntrypoint", "getEnv", "name", "getName", "getWorkdir", "intellij.rider.plugins.appender"})
public final class RiderDockerfileBaseImageReference
implements RiderDockerfileBaseImageReferenceBase {
    @NotNull
    private final String imageName;
    @NotNull
    private final RiderDockerImageProperties properties;

    public RiderDockerfileBaseImageReference(@NlsSafe @NotNull String imageName, @NotNull RiderDockerImageProperties properties2) {
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        Intrinsics.checkNotNullParameter((Object)properties2, (String)"properties");
        this.imageName = imageName;
        this.properties = properties2;
    }

    @Override
    @NotNull
    public CPUKind getCpuArch() {
        return this.properties.getCpuKind();
    }

    @Override
    @NotNull
    public DockerContainerType getContainerType() {
        return this.properties.getOs();
    }

    @Override
    @NotNull
    public String getName() {
        return this.imageName;
    }

    @Override
    @Nullable
    public String getWorkdir() {
        return this.properties.getWorkDir();
    }

    @Override
    @Nullable
    public String getEnv(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.properties.getEnvs().get(name);
    }

    @Override
    @Nullable
    public DockerExecutionInstruction<String> getEntrypoint() {
        return this.properties.getEntrypoint();
    }

    @Override
    @Nullable
    public DockerExecutionInstruction<String> getCmd() {
        return this.properties.getCmd();
    }
}

