/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.common;

import com.jetbrains.rider.plugins.appender.docker.common.DockerExecutionInstruction;
import com.jetbrains.rider.plugins.appender.docker.utils.RiderDockerExecutableUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0004H\u00c6\u0003J7\u0010\u0010\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0012J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0016\u0010\u0019\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0002J\u0016\u0010\u001b\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015H\u0002J\t\u0010\u001c\u001a\u00020\u0004H\u00d6\u0001R\u0019\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0019\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/common/DockerContainerExecution;", "", "entrypoint", "Lcom/jetbrains/rider/plugins/appender/docker/common/DockerExecutionInstruction;", "", "cmd", "workingDir", "(Lcom/jetbrains/rider/plugins/appender/docker/common/DockerExecutionInstruction;Lcom/jetbrains/rider/plugins/appender/docker/common/DockerExecutionInstruction;Ljava/lang/String;)V", "getCmd", "()Lcom/jetbrains/rider/plugins/appender/docker/common/DockerExecutionInstruction;", "getEntrypoint", "getWorkingDir", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "getCommandToLaunch", "", "isLinuxContainer", "hashCode", "", "startsWithBinSh", "executable", "startsWithCmd", "toString", "intellij.rider.plugins.appender"})
public final class DockerContainerExecution {
    @Nullable
    private final DockerExecutionInstruction<String> entrypoint;
    @Nullable
    private final DockerExecutionInstruction<String> cmd;
    @NotNull
    private final String workingDir;

    public DockerContainerExecution(@Nullable DockerExecutionInstruction<String> entrypoint, @Nullable DockerExecutionInstruction<String> cmd, @NotNull String workingDir) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        this.entrypoint = entrypoint;
        this.cmd = cmd;
        this.workingDir = workingDir;
    }

    @Nullable
    public final DockerExecutionInstruction<String> getEntrypoint() {
        return this.entrypoint;
    }

    @Nullable
    public final DockerExecutionInstruction<String> getCmd() {
        return this.cmd;
    }

    @NotNull
    public final String getWorkingDir() {
        return this.workingDir;
    }

    @NotNull
    public final List<String> getCommandToLaunch(boolean isLinuxContainer) {
        List containerExecutable = RiderDockerExecutableUtilKt.getContainerExecutable(this.entrypoint, this.cmd, isLinuxContainer);
        return isLinuxContainer ? (this.startsWithBinSh(containerExecutable) ? CollectionsKt.drop((Iterable)containerExecutable, (int)2) : containerExecutable) : (this.startsWithCmd(containerExecutable) ? CollectionsKt.drop((Iterable)containerExecutable, (int)3) : containerExecutable);
    }

    public static /* synthetic */ List getCommandToLaunch$default(DockerContainerExecution dockerContainerExecution, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return dockerContainerExecution.getCommandToLaunch(bl);
    }

    private final boolean startsWithBinSh(List<String> executable) {
        return executable.size() >= 2 && StringsKt.equals((String)executable.get(0), (String)"/bin/sh", (boolean)true) && StringsKt.equals((String)executable.get(1), (String)"-c", (boolean)true);
    }

    private final boolean startsWithCmd(List<String> executable) {
        return executable.size() >= 3 && StringsKt.equals((String)executable.get(0), (String)"cmd", (boolean)true) && StringsKt.equals((String)executable.get(1), (String)"/S", (boolean)true) && StringsKt.equals((String)executable.get(2), (String)"/C", (boolean)true);
    }

    @Nullable
    public final DockerExecutionInstruction<String> component1() {
        return this.entrypoint;
    }

    @Nullable
    public final DockerExecutionInstruction<String> component2() {
        return this.cmd;
    }

    @NotNull
    public final String component3() {
        return this.workingDir;
    }

    @NotNull
    public final DockerContainerExecution copy(@Nullable DockerExecutionInstruction<String> entrypoint, @Nullable DockerExecutionInstruction<String> cmd, @NotNull String workingDir) {
        Intrinsics.checkNotNullParameter((Object)workingDir, (String)"workingDir");
        return new DockerContainerExecution(entrypoint, cmd, workingDir);
    }

    public static /* synthetic */ DockerContainerExecution copy$default(DockerContainerExecution dockerContainerExecution, DockerExecutionInstruction dockerExecutionInstruction, DockerExecutionInstruction dockerExecutionInstruction2, String string, int n, Object object) {
        if ((n & 1) != 0) {
            dockerExecutionInstruction = dockerContainerExecution.entrypoint;
        }
        if ((n & 2) != 0) {
            dockerExecutionInstruction2 = dockerContainerExecution.cmd;
        }
        if ((n & 4) != 0) {
            string = dockerContainerExecution.workingDir;
        }
        return dockerContainerExecution.copy(dockerExecutionInstruction, dockerExecutionInstruction2, string);
    }

    @NotNull
    public String toString() {
        return "DockerContainerExecution(entrypoint=" + this.entrypoint + ", cmd=" + this.cmd + ", workingDir=" + this.workingDir + ")";
    }

    public int hashCode() {
        int result2 = this.entrypoint == null ? 0 : this.entrypoint.hashCode();
        result2 = result2 * 31 + (this.cmd == null ? 0 : this.cmd.hashCode());
        result2 = result2 * 31 + this.workingDir.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DockerContainerExecution)) {
            return false;
        }
        DockerContainerExecution dockerContainerExecution = (DockerContainerExecution)other;
        if (!Intrinsics.areEqual(this.entrypoint, dockerContainerExecution.entrypoint)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.cmd, dockerContainerExecution.cmd)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.workingDir, (Object)dockerContainerExecution.workingDir);
    }
}

