/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.docker.attach;

import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.agent.events.DockerEvent;
import com.intellij.docker.runtimes.DockerServerRuntime;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.jetbrains.rider.plugins.appender.docker.attach.UpdateEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/attach/DockerEventService;", "", "()V", "myUpdateFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/jetbrains/rider/plugins/appender/docker/attach/UpdateEvent;", "updateFlow", "Lkotlinx/coroutines/flow/SharedFlow;", "getUpdateFlow", "()Lkotlinx/coroutines/flow/SharedFlow;", "Companion", "DockerEventsListener", "intellij.rider.plugins.appender"})
public final class DockerEventService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MutableSharedFlow<UpdateEvent> myUpdateFlow;
    @NotNull
    private final SharedFlow<UpdateEvent> updateFlow;

    public DockerEventService() {
        BufferOverflow bufferOverflow = BufferOverflow.DROP_OLDEST;
        this.myUpdateFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, (BufferOverflow)bufferOverflow, (int)1, null);
        this.updateFlow = FlowKt.asSharedFlow(this.myUpdateFlow);
    }

    @NotNull
    public final SharedFlow<UpdateEvent> getUpdateFlow() {
        return this.updateFlow;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/attach/DockerEventService$Companion;", "", "()V", "getInstance", "Lcom/jetbrains/rider/plugins/appender/docker/attach/DockerEventService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.rider.plugins.appender"})
    @SourceDebugExtension(value={"SMAP\nDockerEventService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerEventService.kt\ncom/jetbrains/rider/plugins/appender/docker/attach/DockerEventService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,64:1\n31#2,2:65\n*S KotlinDebug\n*F\n+ 1 DockerEventService.kt\ncom/jetbrains/rider/plugins/appender/docker/attach/DockerEventService$Companion\n*L\n21#1:65,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DockerEventService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<DockerEventService> serviceClass$iv = DockerEventService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (DockerEventService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u00020\u00072\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016J\u0014\u0010\u0011\u001a\u00020\u00072\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rider/plugins/appender/docker/attach/DockerEventService$DockerEventsListener;", "Lcom/intellij/remoteServer/configuration/RemoteServerListener;", "Lcom/intellij/docker/runtimes/DockerServerRuntime$DockerServerListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "onConnected", "", "docker", "Lcom/intellij/docker/runtimes/DockerServerRuntime;", "onDisconnect", "onDockerEvent", "event", "Lcom/intellij/docker/agent/events/DockerEvent;", "serverAdded", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "serverRemoved", "intellij.rider.plugins.appender"})
    public static final class DockerEventsListener
    implements RemoteServerListener,
    DockerServerRuntime.DockerServerListener {
        @NotNull
        private final Project project;

        public DockerEventsListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        public void serverAdded(@NotNull RemoteServer<?> server) {
            Intrinsics.checkNotNullParameter(server, (String)"server");
            if (server.getConfiguration() instanceof DockerCloudConfiguration) {
                Companion.getInstance(this.project).myUpdateFlow.tryEmit((Object)new UpdateEvent(server.getName(), null));
            }
        }

        public void serverRemoved(@NotNull RemoteServer<?> server) {
            Intrinsics.checkNotNullParameter(server, (String)"server");
            if (server.getConfiguration() instanceof DockerCloudConfiguration) {
                Companion.getInstance(this.project).myUpdateFlow.tryEmit((Object)new UpdateEvent(server.getName(), null));
            }
        }

        public void onConnected(@NotNull DockerServerRuntime docker) {
            Intrinsics.checkNotNullParameter((Object)docker, (String)"docker");
            Companion.getInstance(this.project).myUpdateFlow.tryEmit((Object)new UpdateEvent(docker.getServer().getName(), null));
        }

        public void onDisconnect(@NotNull DockerServerRuntime docker) {
            Intrinsics.checkNotNullParameter((Object)docker, (String)"docker");
            Companion.getInstance(this.project).myUpdateFlow.tryEmit((Object)new UpdateEvent(docker.getServer().getName(), null));
        }

        public void onDockerEvent(@NotNull DockerServerRuntime docker, @NotNull DockerEvent event) {
            DockerEvent.Container container;
            Intrinsics.checkNotNullParameter((Object)docker, (String)"docker");
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event instanceof DockerEvent.Container && ((((((container = (DockerEvent.Container)event) instanceof DockerEvent.Container.Start ? true : container instanceof DockerEvent.Container.Stop) ? true : container instanceof DockerEvent.Container.Pause) ? true : container instanceof DockerEvent.Container.Unpause) ? true : container instanceof DockerEvent.Container.Restart) ? true : container instanceof DockerEvent.Container.Die)) {
                Companion.getInstance(this.project).myUpdateFlow.tryEmit((Object)new UpdateEvent(null, event.getElementId()));
            }
        }
    }
}

