/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.debugger.grid;

import com.intellij.database.datagrid.GridFilteringModel;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.rider.languages.fileTypes.csharp.CSharpLanguage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\t\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0012H\u0016J\u0006\u0010\u0017\u001a\u00020\u0012J\u0006\u0010\u0018\u001a\u00020\u0012J\u0006\u0010\u0019\u001a\u00020\u0012J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00100\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u0006H\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u0010H\u0016J\u0016\u0010\"\u001a\u00020\u00122\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00100\u001eH\u0016J\u0010\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u0006H\u0016J\b\u0010&\u001a\u00020\u0012H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\t\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/rider/plugins/appender/debugger/grid/RiderDebuggerGridFilteringModelImpl;", "Lcom/intellij/database/datagrid/GridFilteringModel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "ignoreCurrentText", "", "myDocument", "Lcom/intellij/openapi/editor/Document;", "myEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/database/datagrid/GridFilteringModel$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "myHistory", "", "", "addListener", "", "l", "disposable", "Lcom/intellij/openapi/Disposable;", "applyCurrentText", "fireApplicableUpdated", "firePSIUpdated", "firePrefixUpdated", "getAppliedText", "getFilterDocument", "getFilterText", "getHistory", "", "isIgnoreCurrentText", "setFilterText", "filter", "setHistory", "history", "setIgnoreCurrentText", "ignore", "trimFilterHistory", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nRiderDebuggerGridFilteringModelImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RiderDebuggerGridFilteringModelImpl.kt\ncom/jetbrains/rider/plugins/appender/debugger/grid/RiderDebuggerGridFilteringModelImpl\n+ 2 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,93:1\n107#2:94\n79#2,22:95\n107#2:117\n79#2,22:118\n*S KotlinDebug\n*F\n+ 1 RiderDebuggerGridFilteringModelImpl.kt\ncom/jetbrains/rider/plugins/appender/debugger/grid/RiderDebuggerGridFilteringModelImpl\n*L\n24#1:94\n24#1:95,22\n66#1:117\n66#1:118,22\n*E\n"})
public final class RiderDebuggerGridFilteringModelImpl
implements GridFilteringModel {
    @NotNull
    private final EventDispatcher<GridFilteringModel.Listener> myEventDispatcher;
    @NotNull
    private final List<String> myHistory;
    private boolean ignoreCurrentText;
    @NotNull
    private final Document myDocument;

    public RiderDebuggerGridFilteringModelImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        EventDispatcher eventDispatcher = EventDispatcher.create(GridFilteringModel.Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.myEventDispatcher = eventDispatcher;
        this.myHistory = new ArrayList();
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)new LightVirtualFile("debugger_visualizers", (Language)CSharpLanguage.INSTANCE, (CharSequence)""), project);
        if (document == null) {
            throw new IllegalStateException("Couldn't create a document".toString());
        }
        this.myDocument = document;
    }

    public void applyCurrentText() {
        String $this$trim$iv = this.getFilterText();
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String text = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        this.myHistory.remove(text);
        this.myHistory.add(0, text);
        this.trimFilterHistory();
    }

    public boolean isIgnoreCurrentText() {
        return this.ignoreCurrentText;
    }

    public void setIgnoreCurrentText(boolean ignore) {
        this.ignoreCurrentText = ignore;
    }

    @NotNull
    public String getAppliedText() {
        String item = (String)ContainerUtil.getFirstItem(this.getHistory());
        String string = item;
        if (string == null) {
            string = "";
        }
        return string;
    }

    private final void trimFilterHistory() {
        int historySize = 5;
        while (this.myHistory.size() > historySize) {
            this.myHistory.remove(this.myHistory.size() - 1);
        }
    }

    public void setHistory(@NotNull List<String> history) {
        Intrinsics.checkNotNullParameter(history, (String)"history");
        this.myHistory.clear();
        this.myHistory.addAll((Collection<String>)history);
        this.trimFilterHistory();
    }

    @NotNull
    public List<String> getHistory() {
        return this.myHistory;
    }

    @NotNull
    public String getFilterText() {
        String string = this.myDocument.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String text = string;
        return Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)text)).toString(), (Object)"x => x.") ? "" : text;
    }

    public void setFilterText(@NotNull String filter) {
        boolean valueChanged;
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        String $this$trim$iv = filter;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String newFilter = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        String currentFilter = this.getFilterText();
        boolean bl = valueChanged = !Intrinsics.areEqual((Object)currentFilter, (Object)newFilter);
        if (!valueChanged) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> RiderDebuggerGridFilteringModelImpl.setFilterText$lambda$2(this, filter));
    }

    @NotNull
    public Document getFilterDocument() {
        return this.myDocument;
    }

    public void addListener(@NotNull GridFilteringModel.Listener l, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.myEventDispatcher.addListener((EventListener)l, disposable);
    }

    public final void fireApplicableUpdated() {
        ((GridFilteringModel.Listener)this.myEventDispatcher.getMulticaster()).onApplicableUpdated();
    }

    public final void firePrefixUpdated() {
        ((GridFilteringModel.Listener)this.myEventDispatcher.getMulticaster()).onPrefixUpdated();
    }

    public final void firePSIUpdated() {
        ((GridFilteringModel.Listener)this.myEventDispatcher.getMulticaster()).onPsiUpdated();
    }

    private static final void setFilterText$lambda$2(RiderDebuggerGridFilteringModelImpl this$0, String $filter) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$filter, (String)"$filter");
        this$0.myDocument.setText((CharSequence)$filter);
    }
}

