/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.utils;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import com.intellij.psi.PsiFile;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.mssql.MsDialectBase;
import com.intellij.sql.psi.SqlLanguage;
import com.jetbrains.rider.ideaInterop.fileTypes.msbuild.SqlprojFileType;
import com.jetbrains.rider.model.RdProjectDescriptor;
import com.jetbrains.rider.model.RdProjectFileDescriptor;
import com.jetbrains.rider.model.RdProjectModelItemDescriptor;
import com.jetbrains.rider.plugins.appender.database.sqlproj.binding.SqlProjDocumentBinderKt;
import com.jetbrains.rider.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntity;
import com.jetbrains.rider.projectView.workspace.ProjectModelEntityExtensionsKt;
import com.jetbrains.rider.projectView.workspace.WorkspaceModelExtensionsKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u0002*\u00020\u000f\u001a\n\u0010\u0010\u001a\u00020\u0005*\u00020\u000f\u001a\n\u0010\u0011\u001a\u00020\u0005*\u00020\u000f\"\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u0012"}, d2={"knownBuildActions", "", "", "[Ljava/lang/String;", "isFileWithMsDialect", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "isFileWithSqlDialect", "projectEntityNeedsBinding", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "getFileStructure", "Lcom/jetbrains/rider/projectView/workspace/ProjectModelEntity;", "isDatabaseProject", "shouldBeSynced", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDatabaseExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseExtensions.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/utils/DatabaseExtensionsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n12474#2,2:48\n1747#3,3:50\n*S KotlinDebug\n*F\n+ 1 DatabaseExtensions.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/utils/DatabaseExtensionsKt\n*L\n27#1:48,2\n46#1:50,3\n*E\n"})
public final class DatabaseExtensionsKt {
    @NotNull
    private static final String[] knownBuildActions;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isDatabaseProject(@NotNull ProjectModelEntity $this$isDatabaseProject) {
        Intrinsics.checkNotNullParameter((Object)$this$isDatabaseProject, (String)"<this>");
        if (!ProjectModelEntityExtensionsKt.isProject((ProjectModelEntity)$this$isDatabaseProject)) return false;
        VirtualFileUrl virtualFileUrl = $this$isDatabaseProject.getUrl();
        Object object = virtualFileUrl;
        if (virtualFileUrl == null) return false;
        String string = object.getFileName();
        object = string;
        if (string == null) return false;
        if (!StringsKt.endsWith((String)object, (String)SqlprojFileType.INSTANCE.getDefaultExtension(), (boolean)true)) return false;
        return true;
    }

    public static final boolean shouldBeSynced(@NotNull ProjectModelEntity $this$shouldBeSynced) {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$shouldBeSynced, (String)"<this>");
            RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$shouldBeSynced.getDescriptor();
            RdProjectFileDescriptor rdProjectFileDescriptor = rdProjectModelItemDescriptor instanceof RdProjectFileDescriptor ? (RdProjectFileDescriptor)rdProjectModelItemDescriptor : null;
            if (rdProjectFileDescriptor == null) {
                return false;
            }
            RdProjectFileDescriptor descriptor2 = rdProjectFileDescriptor;
            String[] $this$any$iv = knownBuildActions;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                String element$iv;
                String it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!StringsKt.equals((String)it, (String)descriptor2.getBuildAction(), (boolean)true)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final String getFileStructure(@NotNull ProjectModelEntity $this$getFileStructure) {
        Intrinsics.checkNotNullParameter((Object)$this$getFileStructure, (String)"<this>");
        RdProjectModelItemDescriptor rdProjectModelItemDescriptor = $this$getFileStructure.getDescriptor();
        RdProjectDescriptor rdProjectDescriptor = rdProjectModelItemDescriptor instanceof RdProjectDescriptor ? (RdProjectDescriptor)rdProjectModelItemDescriptor : null;
        return rdProjectDescriptor != null ? ProjectModelNodeExtensionKt.getUserData((RdProjectModelItemDescriptor)((RdProjectModelItemDescriptor)rdProjectDescriptor), (String)"DefaultFileStructure") : null;
    }

    public static final boolean isFileWithMsDialect(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return psiFile.getLanguage() instanceof MsDialectBase;
    }

    public static final boolean isFileWithSqlDialect(@NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return psiFile.getLanguage() instanceof SqlLanguageDialect || psiFile.getLanguage() instanceof SqlLanguage;
    }

    public static final boolean projectEntityNeedsBinding(@NotNull VirtualFile file, @NotNull Project project) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Iterable $this$any$iv = WorkspaceModelExtensionsKt.getProjectModelEntities((WorkspaceModel)WorkspaceModel.Companion.getInstance(project), (VirtualFile)file, (Project)project);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ProjectModelEntity it = (ProjectModelEntity)element$iv;
                    boolean bl2 = false;
                    if (!SqlProjDocumentBinderKt.isSqlProjFileToBind(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        String[] stringArray = new String[]{"Build", "Content"};
        knownBuildActions = stringArray;
    }
}

