/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.tree;

import com.intellij.ui.tree.BaseTreeModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rider.model.RdSchemaCompareAddNodeCommand;
import com.jetbrains.rider.model.RdSchemaCompareChangeInclusionCommand;
import com.jetbrains.rider.model.RdSchemaCompareChangeParentCommand;
import com.jetbrains.rider.model.RdSchemaCompareRoot;
import com.jetbrains.rider.model.RdSchemaCompareTreeModel;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.SchemaCompareDataModel;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.notifications.ModelNotifications;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.notifications.models.SchemaCompareOperationResult;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.tree.SchemaCompareTreeUpdate;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.tree.SchemaCompareTreeUpdateType;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.tree.SchemaCompareTreeUpdater;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.tree.nodes.SchemaCompareTreeNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.tree.nodes.TreeNodesFactory;
import com.jetbrains.rider.plugins.appender.database.sqlproj.utils.ReactiveExtKt;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u0015H\u0002J\u000e\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0002J\u0018\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\u0010\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020\nH\u0002J\u0019\u0010&\u001a\u0004\u0018\u00010\u00022\b\u0010%\u001a\u0004\u0018\u00010\nH\u0002\u00a2\u0006\u0002\u0010'J\n\u0010(\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010)\u001a\u00020*2\b\u0010\u001f\u001a\u0004\u0018\u00010#H\u0016J\u000e\u0010+\u001a\u00020\u00152\u0006\u0010,\u001a\u00020-J\u0010\u0010.\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\nH\u0002R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n0\tj\b\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00020\rj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0002`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/tree/SchemaCompareTreeModel;", "Lcom/intellij/ui/tree/BaseTreeModel;", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/tree/nodes/SchemaCompareTreeNode;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "dataModel", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/SchemaCompareDataModel;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/SchemaCompareDataModel;)V", "expandedNodes", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "idToNodeMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "myRoot", "rdTreeModel", "Lcom/jetbrains/rider/model/RdSchemaCompareTreeModel;", "treeUpdater", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/tree/SchemaCompareTreeUpdater;", "addNode", "", "it", "Lcom/jetbrains/rider/model/RdSchemaCompareAddNodeCommand;", "changeNodeInclusion", "command", "Lcom/jetbrains/rider/model/RdSchemaCompareChangeInclusionCommand;", "changeNodeParent", "Lcom/jetbrains/rider/model/RdSchemaCompareChangeParentCommand;", "clear", "expand", "node", "getChildren", "", "parent", "", "getNodeOrThrow", "id", "getParentOrThrow", "(Ljava/lang/Integer;)Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/tree/nodes/SchemaCompareTreeNode;", "getRoot", "isLeaf", "", "refresh", "update", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/tree/SchemaCompareTreeUpdate;", "removeNode", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nSchemaCompareTreeModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaCompareTreeModel.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/tree/SchemaCompareTreeModel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,141:1\n1#2:142\n*E\n"})
public final class SchemaCompareTreeModel
extends BaseTreeModel<SchemaCompareTreeNode> {
    @NotNull
    private final RdSchemaCompareTreeModel rdTreeModel;
    @NotNull
    private final SchemaCompareTreeUpdater treeUpdater;
    @NotNull
    private final HashMap<Integer, SchemaCompareTreeNode> idToNodeMap;
    @NotNull
    private final HashSet<Integer> expandedNodes;
    @Nullable
    private SchemaCompareTreeNode myRoot;

    public SchemaCompareTreeModel(@NotNull Lifetime lifetime, @NotNull SchemaCompareDataModel dataModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)dataModel, (String)"dataModel");
        this.rdTreeModel = dataModel.getTreeModel();
        this.treeUpdater = new SchemaCompareTreeUpdater(this);
        this.idToNodeMap = new HashMap();
        this.expandedNodes = new HashSet();
        lifetime.onTermination((Function0)new Function0<Unit>(){

            public final void invoke() {
                this.clear();
            }
        });
        this.rdTreeModel.getClear().advise(lifetime, (Function1)new Function1<Unit, Unit>(){

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.clear();
            }
        });
        this.rdTreeModel.getAdd().advise(lifetime, (Function1)new Function1<RdSchemaCompareAddNodeCommand, Unit>(){

            public final void invoke(@NotNull RdSchemaCompareAddNodeCommand it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.addNode(it);
            }
        });
        this.rdTreeModel.getRemove().advise(lifetime, (Function1)new Function1<Integer, Unit>(){

            public final void invoke(int it) {
                this.removeNode(it);
            }
        });
        this.rdTreeModel.getChangeParent().advise(lifetime, (Function1)new Function1<RdSchemaCompareChangeParentCommand, Unit>(){

            public final void invoke(@NotNull RdSchemaCompareChangeParentCommand it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.changeNodeParent(it);
            }
        });
        this.rdTreeModel.getSetInclusion().advise(lifetime, (Function1)new Function1<RdSchemaCompareChangeInclusionCommand, Unit>(){

            public final void invoke(@NotNull RdSchemaCompareChangeInclusionCommand it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.changeNodeInclusion(it);
            }
        });
        this.rdTreeModel.getExpanded().advise(lifetime, (Function1)new Function1<Integer, Unit>(){

            public final void invoke(int it) {
                treeUpdater.updateTree();
            }
        });
        ModelNotifications notifications = dataModel.getNotifications();
        ISource[] iSourceArray = new ISource[]{notifications.getComparisonCompleted(), notifications.getEqualObjectsVisibilityChanged(), notifications.getUnsupportedObjectsVisibilityChanged(), notifications.getInclusionChanged(), notifications.getGroupingChanged()};
        ReactiveExtKt.merge(lifetime, iSourceArray, (Function1)new Function1<SchemaCompareOperationResult, Unit>(){

            public final void invoke(@NotNull SchemaCompareOperationResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                treeUpdater.updateTree();
            }
        });
    }

    public final void refresh(@NotNull SchemaCompareTreeUpdate update2) {
        Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
        switch (WhenMappings.$EnumSwitchMapping$0[update2.getUpdateType().ordinal()]) {
            case 1: {
                this.treeStructureChanged(update2.getPath(), update2.getIndices(), update2.getChildren());
                break;
            }
            case 2: {
                this.treeNodesChanged(update2.getPath(), update2.getIndices(), update2.getChildren());
            }
        }
    }

    public final void expand(@NotNull SchemaCompareTreeNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (this.idToNodeMap.containsKey(node.getId()) && this.expandedNodes.add(node.getId())) {
            this.rdTreeModel.getExpand().fire((Object)node.getId());
        }
    }

    @Nullable
    public SchemaCompareTreeNode getRoot() {
        return this.myRoot;
    }

    @NotNull
    public List<SchemaCompareTreeNode> getChildren(@Nullable Object parent) {
        if (!(parent instanceof SchemaCompareTreeNode)) {
            return CollectionsKt.emptyList();
        }
        return ((SchemaCompareTreeNode)parent).getChildren();
    }

    public boolean isLeaf(@Nullable Object node) {
        if (node instanceof SchemaCompareTreeNode) {
            if (!((Collection)((SchemaCompareTreeNode)node).getChildren()).isEmpty()) {
                return false;
            }
            return !((SchemaCompareTreeNode)node).getHasChildren();
        }
        return super.isLeaf(node);
    }

    private final void changeNodeInclusion(RdSchemaCompareChangeInclusionCommand command) {
        SchemaCompareTreeNode node = this.getNodeOrThrow(command.getNodeId());
        node.setInclusionState(command.getInclusion());
        this.treeUpdater.markForUpdate(node, SchemaCompareTreeUpdateType.Presentation);
    }

    private final void changeNodeParent(RdSchemaCompareChangeParentCommand it) {
        SchemaCompareTreeNode node = this.getNodeOrThrow(it.getNodeId());
        SchemaCompareTreeNode oldParent = node.getParent();
        SchemaCompareTreeNode newParent = this.getParentOrThrow(it.getParentId());
        SchemaCompareTreeNode schemaCompareTreeNode = oldParent;
        if (schemaCompareTreeNode != null) {
            schemaCompareTreeNode.removeChild(node);
        }
        SchemaCompareTreeNode schemaCompareTreeNode2 = newParent;
        node.setPosition(schemaCompareTreeNode2 != null ? Integer.valueOf(schemaCompareTreeNode2.addChild(node)) : null);
        node.setParent(newParent);
        SchemaCompareTreeNode[] schemaCompareTreeNodeArray = new SchemaCompareTreeNode[]{node, oldParent, newParent};
        this.treeUpdater.markForUpdate(SchemaCompareTreeUpdateType.Structure, schemaCompareTreeNodeArray);
    }

    private final void removeNode(int it) {
        SchemaCompareTreeNode parent;
        SchemaCompareTreeNode node = this.getNodeOrThrow(it);
        SchemaCompareTreeNode schemaCompareTreeNode = parent = node.getParent();
        if (schemaCompareTreeNode != null) {
            schemaCompareTreeNode.removeChild(node);
        }
        node.setParent(null);
        node.setPosition(null);
        this.idToNodeMap.remove(node.getId());
        this.expandedNodes.remove(node.getId());
        SchemaCompareTreeNode[] schemaCompareTreeNodeArray = new SchemaCompareTreeNode[]{parent};
        this.treeUpdater.markForUpdate(SchemaCompareTreeUpdateType.Structure, schemaCompareTreeNodeArray);
    }

    private final void addNode(RdSchemaCompareAddNodeCommand it) {
        SchemaCompareTreeNode parent = this.getParentOrThrow(it.getParentId());
        SchemaCompareTreeNode node = TreeNodesFactory.INSTANCE.createNode(it.getNode(), parent);
        if (it.getNode() instanceof RdSchemaCompareRoot) {
            this.myRoot = node;
        }
        SchemaCompareTreeNode schemaCompareTreeNode = parent;
        node.setPosition(schemaCompareTreeNode != null ? Integer.valueOf(schemaCompareTreeNode.addChild(node)) : null);
        ((Map)this.idToNodeMap).put(node.getId(), node);
        SchemaCompareTreeNode[] schemaCompareTreeNodeArray = new SchemaCompareTreeNode[]{node, parent};
        this.treeUpdater.markForUpdate(SchemaCompareTreeUpdateType.Structure, schemaCompareTreeNodeArray);
    }

    private final void clear() {
        this.idToNodeMap.clear();
        this.expandedNodes.clear();
        this.myRoot = null;
    }

    private final SchemaCompareTreeNode getParentOrThrow(Integer id) {
        SchemaCompareTreeNode schemaCompareTreeNode;
        Integer n = id;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            schemaCompareTreeNode = this.idToNodeMap.get(it);
            if (schemaCompareTreeNode == null) {
                throw new Exception("Node was not found");
            }
        } else {
            schemaCompareTreeNode = null;
        }
        return schemaCompareTreeNode;
    }

    private final SchemaCompareTreeNode getNodeOrThrow(int id) {
        SchemaCompareTreeNode schemaCompareTreeNode = this.idToNodeMap.get(id);
        if (schemaCompareTreeNode == null) {
            throw new Exception("Node was not found");
        }
        return schemaCompareTreeNode;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SchemaCompareTreeUpdateType.values().length];
            try {
                nArray[SchemaCompareTreeUpdateType.Structure.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SchemaCompareTreeUpdateType.Presentation.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

