/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.treetable.TreeTable;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.ui.treeStructure.treetable.TreeTableTree;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.SchemaCompareDataModel;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.state.SchemaCompareActionState;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.actions.ExcludeSelectedAction;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.actions.IncludeSelectedAction;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.extensions.LifetimedListenersKt;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.SchemaCompareTreeTableModel;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.columns.ChangeTypeColumn;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.columns.SchemaCompareColumnInfo;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.columns.SchemaCompareTreeColumnInfo;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.columns.ToggleColumn;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.tree.SchemaCompareTreeNodeExpander;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.tree.TreeExpandedPathsPreserver;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.treeTable.tree.nodes.SchemaCompareTreeNode;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0011\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018\u00a2\u0006\u0002\u0010\u0019J0\u0010\u001a\u001a\u00020\n\"\u0004\b\u0000\u0010\u001b\"\u0004\b\u0001\u0010\u001c2\u0006\u0010\u0014\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u0002H\u001c0\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/SchemaCompareTreeTable;", "Lcom/intellij/ui/treeStructure/treetable/TreeTable;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "schemaCompareDataModel", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/SchemaCompareDataModel;", "treeTableModel", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/SchemaCompareTreeTableModel;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/SchemaCompareDataModel;Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/SchemaCompareTreeTableModel;)V", "adjustColumns", "", "getCellEditor", "Ljavax/swing/table/TableCellEditor;", "row", "", "column", "getCellRenderer", "Ljavax/swing/table/TableCellRenderer;", "getColumnInfo", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/columns/SchemaCompareColumnInfo;", "columnIndex", "getRowElement", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/tree/nodes/SchemaCompareTreeNode;", "getSelectedNodes", "", "()[Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/tree/nodes/SchemaCompareTreeNode;", "setFixedWidthForColumnFromItsName", "Item", "Aspect", "Lcom/intellij/util/ui/ColumnInfo;", "SchemaCompareTreeTableViewMouseAdapter", "intellij.rider.plugins.appender"})
public final class SchemaCompareTreeTable
extends TreeTable {
    @NotNull
    private final SchemaCompareTreeTableModel treeTableModel;

    public SchemaCompareTreeTable(@NotNull Lifetime lifetime, @NotNull SchemaCompareDataModel schemaCompareDataModel, @NotNull SchemaCompareTreeTableModel treeTableModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)schemaCompareDataModel, (String)"schemaCompareDataModel");
        Intrinsics.checkNotNullParameter((Object)treeTableModel, (String)"treeTableModel");
        super((TreeTableModel)treeTableModel);
        this.treeTableModel = treeTableModel;
        this.adjustColumns();
        this.getEmptyText().setText(RiderDatabaseBundle.message("schemaCompare.statuses.ready", new Object[0]));
        this.getEmptyText().setShowAboveCenter(false);
        TreeTableTree treeTableTree = this.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)treeTableTree, (String)"getTree(...)");
        JTree jTree = (JTree)treeTableTree;
        TreeTableTree treeTableTree2 = this.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)treeTableTree2, (String)"getTree(...)");
        LifetimedListenersKt.addTreeExpansionListener(jTree, lifetime, new TreeExpandedPathsPreserver(lifetime, (JTree)treeTableTree2, schemaCompareDataModel));
        TreeTableTree treeTableTree3 = this.getTree();
        Intrinsics.checkNotNullExpressionValue((Object)treeTableTree3, (String)"getTree(...)");
        LifetimedListenersKt.addTreeWillExpandListener((JTree)treeTableTree3, lifetime, new SchemaCompareTreeNodeExpander(this.treeTableModel.getTreeModel()));
        this.getTree().setRootVisible(false);
        LifetimedListenersKt.addMouseListener((Component)((Object)this), lifetime, new SchemaCompareTreeTableViewMouseAdapter(this, schemaCompareDataModel.getProject()));
        AnAction[] anActionArray = new AnAction[]{new IncludeSelectedAction(), new ExcludeSelectedAction()};
        PopupHandler.installRowSelectionTablePopup((JTable)((JTable)((Object)this)), (ActionGroup)((ActionGroup)new DefaultActionGroup(anActionArray)), (String)"SchemaComparePopup");
        schemaCompareDataModel.getModelState().getCanChangeInclusion().advise(lifetime, (Function1)new Function1<SchemaCompareActionState, Unit>(){

            public final void invoke(@NotNull SchemaCompareActionState it) {
                Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                this.setEnabled(it == SchemaCompareActionState.Enabled);
            }
        });
    }

    @NotNull
    public final SchemaCompareTreeNode[] getSelectedNodes() {
        Object[] objectArray = this.getTree().getSelectedNodes(SchemaCompareTreeNode.class, null);
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getSelectedNodes(...)");
        return (SchemaCompareTreeNode[])objectArray;
    }

    @NotNull
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = this.getColumnInfo(column).getRenderer(this.getRowElement(row));
        TableCellRenderer tableCellRenderer = renderer;
        if (tableCellRenderer == null) {
            TableCellRenderer tableCellRenderer2 = super.getCellRenderer(row, column);
            tableCellRenderer = tableCellRenderer2;
            Intrinsics.checkNotNullExpressionValue((Object)tableCellRenderer2, (String)"getCellRenderer(...)");
        }
        return tableCellRenderer;
    }

    @Nullable
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor editor2 = this.getColumnInfo(column).getEditor(this.getRowElement(row));
        TableCellEditor tableCellEditor = editor2;
        if (tableCellEditor == null) {
            tableCellEditor = super.getCellEditor(row, column);
        }
        return tableCellEditor;
    }

    private final void adjustColumns() {
        int n = this.treeTableModel.getColumns().length;
        for (int columnIndex = 0; columnIndex < n; ++columnIndex) {
            SchemaCompareColumnInfo column = this.treeTableModel.getColumns()[columnIndex];
            if (column instanceof ToggleColumn ? true : column instanceof ChangeTypeColumn) {
                this.setFixedWidthForColumnFromItsName(columnIndex, column);
                continue;
            }
            if (!(column instanceof SchemaCompareTreeColumnInfo)) continue;
            TableColumn tableColumn = this.getColumnModel().getColumn(columnIndex);
            tableColumn.setPreferredWidth(300);
        }
    }

    private final SchemaCompareColumnInfo getColumnInfo(int columnIndex) {
        return this.treeTableModel.getColumns()[this.convertColumnIndexToModel(columnIndex)];
    }

    private final SchemaCompareTreeNode getRowElement(int row) {
        Object object = this.getTree().getPathForRow(row).getLastPathComponent();
        return object instanceof SchemaCompareTreeNode ? (SchemaCompareTreeNode)object : null;
    }

    private final <Item, Aspect> void setFixedWidthForColumnFromItsName(int columnIndex, ColumnInfo<Item, Aspect> column) {
        TableColumn tableColumn = this.getColumnModel().getColumn(columnIndex);
        int columnWidth = this.getFontMetrics(this.getFont()).stringWidth(column.getName()) + 15;
        tableColumn.setPreferredWidth(columnWidth);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/SchemaCompareTreeTable$SchemaCompareTreeTableViewMouseAdapter;", "Ljava/awt/event/MouseAdapter;", "treeTableView", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/SchemaCompareTreeTable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/treeTable/SchemaCompareTreeTable;Lcom/intellij/openapi/project/Project;)V", "mousePressed", "", "e", "Ljava/awt/event/MouseEvent;", "intellij.rider.plugins.appender"})
    private static final class SchemaCompareTreeTableViewMouseAdapter
    extends MouseAdapter {
        @NotNull
        private final SchemaCompareTreeTable treeTableView;
        @NotNull
        private final Project project;

        public SchemaCompareTreeTableViewMouseAdapter(@NotNull SchemaCompareTreeTable treeTableView, @NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)((Object)treeTableView), (String)"treeTableView");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.treeTableView = treeTableView;
            this.project = project;
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            int row;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.treeTableView.isEmpty()) {
                IdeFocusManager.getInstance((Project)this.project).requestFocusInProject((Component)((Object)this.treeTableView), this.project);
                return;
            }
            if (SwingUtilities.isRightMouseButton(e) && !this.treeTableView.isRowSelected(row = this.treeTableView.rowAtPoint(e.getPoint()))) {
                int col = this.treeTableView.columnAtPoint(e.getPoint());
                if (row >= 0 && col >= 0) {
                    this.treeTableView.changeSelection(row, col, false, false);
                }
            }
        }
    }
}

