/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.statuses;

import com.jetbrains.rider.model.RdSchemaCompareOperationResultFlags;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.notifications.models.ComparisonResult;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.notifications.models.SchemaCompareOperationResult;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.notifications.models.ScriptGenerationResult;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.utils.ExtKt;
import java.util.EnumSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\b\u001a\u00020\tH\u0003J\b\u0010\n\u001a\u00020\tH\u0007J\b\u0010\u000b\u001a\u00020\tH\u0007J(\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012H\u0007J\b\u0010\u0013\u001a\u00020\tH\u0007J(\u0010\u0014\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u00152\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012H\u0007J\b\u0010\u0016\u001a\u00020\tH\u0007J\"\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012H\u0003J\"\u0010\u0018\u001a\u0004\u0018\u00010\t2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012H\u0003J\"\u0010\u0019\u001a\u0004\u0018\u00010\t2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012H\u0003J\u0010\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0010\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J(\u0010 \u001a\u00020\t2\u0006\u0010\r\u001a\u00020!2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u0012H\u0007J\b\u0010\"\u001a\u00020\tH\u0007\u00a8\u0006#"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/statuses/StatusesProvider;", "", "()V", "appendMessage", "", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "text", "", "cancelStarted", "compareOptionsChanged", "comparisonCompleted", "result", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/notifications/models/ComparisonResult;", "status", "Ljava/util/EnumSet;", "Lcom/jetbrains/rider/model/RdSchemaCompareOperationResultFlags;", "Lcom/jetbrains/rd/util/EnumSet;", "comparisonStarted", "deployScriptGenerationFinished", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/notifications/models/ScriptGenerationResult;", "deployScriptGenerationStarted", "getClosedSourceOrTargetMessage", "getDriftedSourceOrTargetMessage", "getModelErrorsMessageForScript", "initialStatus", "canExecuteCompare", "", "sourceAndTargetSwitched", "sourceSet", "targetSet", "updateTargetCompleted", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/notifications/models/SchemaCompareOperationResult;", "updateTargetStarted", "intellij.rider.plugins.appender"})
public final class StatusesProvider {
    @NotNull
    public static final StatusesProvider INSTANCE = new StatusesProvider();

    private StatusesProvider() {
    }

    @Nls
    @NotNull
    public final String deployScriptGenerationStarted() {
        return RiderDatabaseBundle.message("schemaCompare.statuses.scriptGeneration.started", new Object[0]);
    }

    @Nls
    @NotNull
    public final String deployScriptGenerationFinished(@NotNull ScriptGenerationResult result2, @NotNull EnumSet<RdSchemaCompareOperationResultFlags> status) {
        String message;
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter(status, (String)"status");
        if (result2.isSuccess()) {
            return RiderDatabaseBundle.message("schemaCompare.statuses.scriptGeneration.successful", new Object[0]);
        }
        if (result2.isCancelled()) {
            return RiderDatabaseBundle.message("schemaCompare.statuses.scriptGeneration.cancelled", new Object[0]);
        }
        String string = this.getModelErrorsMessageForScript(status);
        if (string == null && (string = this.getClosedSourceOrTargetMessage(status)) == null) {
            string = this.getDriftedSourceOrTargetMessage(status);
        }
        if ((message = string) != null) {
            return message;
        }
        return RiderDatabaseBundle.message("schemaCompare.statuses.scriptGeneration.failed.unknown", new Object[0]);
    }

    @Nls
    @NotNull
    public final String initialStatus(boolean canExecuteCompare) {
        return canExecuteCompare ? RiderDatabaseBundle.message("schemaCompare.statuses.ready", new Object[0]) : RiderDatabaseBundle.message("schemaCompare.statuses.sourceOrTargetMissing", new Object[0]);
    }

    @Nls
    @NotNull
    public final String comparisonStarted() {
        return RiderDatabaseBundle.message("schemaCompare.statuses.compare.started", new Object[0]);
    }

    @Nls
    @NotNull
    public final String updateTargetStarted() {
        return RiderDatabaseBundle.message("schemaCompare.statuses.updateTarget.started", new Object[0]);
    }

    @Nls
    @NotNull
    public final String updateTargetCompleted(@NotNull SchemaCompareOperationResult result2, @NotNull EnumSet<RdSchemaCompareOperationResultFlags> status) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter(status, (String)"status");
        if (result2.isSuccess()) {
            return RiderDatabaseBundle.message("schemaCompare.statuses.updateTarget.successful", new Object[0]);
        }
        if (result2.isCancelled()) {
            return RiderDatabaseBundle.message("schemaCompare.statuses.updateTarget.cancelled", new Object[0]);
        }
        String closedSourceOrTargetMessage = this.getClosedSourceOrTargetMessage(status);
        if (closedSourceOrTargetMessage != null) {
            return closedSourceOrTargetMessage;
        }
        String driftedSourceOrTargetMessage = this.getDriftedSourceOrTargetMessage(status);
        if (driftedSourceOrTargetMessage != null) {
            return driftedSourceOrTargetMessage;
        }
        return RiderDatabaseBundle.message("schemaCompare.statuses.updateTarget.failed.unknown", new Object[0]);
    }

    @Nls
    @NotNull
    public final String comparisonCompleted(@NotNull ComparisonResult result2, @NotNull EnumSet<RdSchemaCompareOperationResultFlags> status) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter(status, (String)"status");
        if (result2.isCancelled()) {
            return RiderDatabaseBundle.message("schemaCompare.statuses.compare.cancelled", new Object[0]);
        }
        String closedSourceOrTargetMessage = this.getClosedSourceOrTargetMessage(status);
        if (closedSourceOrTargetMessage != null) {
            return closedSourceOrTargetMessage;
        }
        String driftedSourceOrTargetMessage = this.getDriftedSourceOrTargetMessage(status);
        if (driftedSourceOrTargetMessage != null) {
            return driftedSourceOrTargetMessage;
        }
        boolean hasOrphanedEntries = ExtKt.sourceOrTargetHasOrphanedObjects(status);
        boolean hasErrors = ExtKt.sourceOrTargetHasErrors(status);
        boolean preventsUpdate = status.contains(RdSchemaCompareOperationResultFlags.SomeActionsMayPreventUpdate);
        StringBuilder stringBuilder = new StringBuilder();
        if (result2.isSuccess()) {
            if (result2.getHasDifferences()) {
                this.appendMessage(stringBuilder, RiderDatabaseBundle.message("schemaCompare.statuses.compare.successful.hasDifferences", new Object[0]));
            } else {
                this.appendMessage(stringBuilder, RiderDatabaseBundle.message("schemaCompare.statuses.compare.successful.noDifferences", new Object[0]));
            }
        }
        if (hasOrphanedEntries) {
            this.appendMessage(stringBuilder, RiderDatabaseBundle.message("schemaCompare.statuses.orphanedEntries", new Object[0]));
        }
        if (preventsUpdate) {
            this.appendMessage(stringBuilder, RiderDatabaseBundle.message("schemaCompare.statuses.updatePrevention", new Object[0]));
        }
        if (hasErrors) {
            this.appendMessage(stringBuilder, RiderDatabaseBundle.message("schemaCompare.statuses.errors", new Object[0]));
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Nls
    @NotNull
    public final String cancelStarted() {
        return RiderDatabaseBundle.message("schemaCompare.statuses.cancel.started", new Object[0]);
    }

    @Nls
    @NotNull
    public final String sourceAndTargetSwitched(boolean canExecuteCompare) {
        return canExecuteCompare ? RiderDatabaseBundle.message("schemaCompare.statuses.switchToggled", new Object[0]) : RiderDatabaseBundle.message("schemaCompare.statuses.sourceOrTargetMissing", new Object[0]);
    }

    @Nls
    @NotNull
    public final String compareOptionsChanged() {
        return RiderDatabaseBundle.message("schemaCompare.statuses.optionsChanged", new Object[0]);
    }

    @Nls
    @NotNull
    public final String sourceSet(boolean canExecuteCompare) {
        return canExecuteCompare ? RiderDatabaseBundle.message("schemaCompare.statuses.sourceSet", new Object[0]) : RiderDatabaseBundle.message("schemaCompare.statuses.sourceOrTargetMissing", new Object[0]);
    }

    @Nls
    @NotNull
    public final String targetSet(boolean canExecuteCompare) {
        return canExecuteCompare ? RiderDatabaseBundle.message("schemaCompare.statuses.targetSet", new Object[0]) : RiderDatabaseBundle.message("schemaCompare.statuses.sourceOrTargetMissing", new Object[0]);
    }

    @Nls
    private final void appendMessage(StringBuilder stringBuilder, String text) {
        if (((CharSequence)stringBuilder).length() > 0) {
            stringBuilder.append(" ");
        }
        stringBuilder.append(text);
    }

    @Nls
    private final String getModelErrorsMessageForScript(EnumSet<RdSchemaCompareOperationResultFlags> status) {
        boolean sourceHasErrors = ExtKt.sourceHasErrors(status);
        boolean targetHasErrors = ExtKt.targetHasErrors(status);
        if (sourceHasErrors && targetHasErrors) {
            return RiderDatabaseBundle.message("schemaCompare.statuses.scriptGeneration.failed.errorsInSourceAndTarget", new Object[0]);
        }
        if (sourceHasErrors) {
            return RiderDatabaseBundle.message("schemaCompare.statuses.scriptGeneration.failed.errorsInSource", new Object[0]);
        }
        if (targetHasErrors) {
            return RiderDatabaseBundle.message("schemaCompare.statuses.scriptGeneration.failed.errorsInTarget", new Object[0]);
        }
        return null;
    }

    @Nls
    private final String getClosedSourceOrTargetMessage(EnumSet<RdSchemaCompareOperationResultFlags> status) {
        if (ExtKt.isSourceClosed(status)) {
            return RiderDatabaseBundle.message("schemaCompare.statuses.sourceUnavailable", new Object[0]);
        }
        if (ExtKt.isTargetClosed(status)) {
            return RiderDatabaseBundle.message("schemaCompare.statuses.targetUnavailable", new Object[0]);
        }
        return null;
    }

    @Nls
    private final String getDriftedSourceOrTargetMessage(EnumSet<RdSchemaCompareOperationResultFlags> status) {
        boolean hasSourceDrifted = ExtKt.hasSourceDrifted(status);
        boolean hasTargetDrifted = ExtKt.hasTargetDrifted(status);
        if (hasSourceDrifted && hasTargetDrifted) {
            return RiderDatabaseBundle.message("schemaCompare.statuses.sourceAndTargetDrifted", new Object[0]);
        }
        if (hasSourceDrifted) {
            return RiderDatabaseBundle.message("schemaCompare.statuses.sourceDrifted", new Object[0]);
        }
        if (hasTargetDrifted) {
            return RiderDatabaseBundle.message("schemaCompare.statuses.targetDrifted", new Object[0]);
        }
        return null;
    }
}

