/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.database;

import com.intellij.database.Dbms;
import com.intellij.database.psi.DataSourceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBList;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rider.model.RdConnectionString;
import com.jetbrains.rider.model.RdSetSchemaCompareParticipantForDatabaseRequest;
import com.jetbrains.rider.model.RdSetSchemaCompareParticipantRequest;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.ConnectionStringsProvider;
import com.jetbrains.rider.plugins.appender.database.connectionStrings.PotentialConnectionString;
import com.jetbrains.rider.plugins.appender.database.dialog.ConnectionType;
import com.jetbrains.rider.plugins.appender.database.dialog.DatabaseConnectionDialog;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.ParticipantSelectionTab;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.database.DataSourcesChangesListener;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.database.DatabaseInDatasource;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.database.ListWithDatabases;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.database.LocalDataSourceToConnectionStringMapper;
import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/participants/tabs/database/DatabaseParticipantSelectionTab;", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/participants/tabs/ParticipantSelectionTab;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/project/Project;)V", "list", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/participants/tabs/database/ListWithDatabases;", "createNewDataSource", "", "getComponent", "Ljavax/swing/JComponent;", "getPreferableFocusComponent", "getSelectedParticipant", "Lcom/jetbrains/rider/model/RdSetSchemaCompareParticipantRequest;", "intellij.rider.plugins.appender"})
public final class DatabaseParticipantSelectionTab
extends ParticipantSelectionTab {
    @NotNull
    private final ListWithDatabases list;

    public DatabaseParticipantSelectionTab(@NotNull Lifetime lifetime, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, RiderDatabaseBundle.INSTANCE.getMessage("schemaCompare.participantSelection.databases.tabHeader", new Object[0]));
        this.list = new ListWithDatabases(project);
        DataSourcesChangesListener listener = new DataSourcesChangesListener(project, this.list);
        MessageBusConnection messageBusConnection = project.getMessageBus().connect(LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null));
        Topic topic = DataSourceManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)listener);
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        return (JComponent)BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this){
            final /* synthetic */ DatabaseParticipantSelectionTab this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ DatabaseParticipantSelectionTab this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.label(RiderDatabaseBundle.INSTANCE.getMessage("schemaCompare.participantSelection.databases.label", new Object[0])).bold().align((Align)AlignX.LEFT.INSTANCE).gap(RightGap.COLUMNS);
                        $this$row.cell((JComponent)new ActionLink(RiderDatabaseBundle.INSTANCE.getMessage("schemaCompare.participantSelection.databases.create", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                            final /* synthetic */ DatabaseParticipantSelectionTab this$0;
                            {
                                this.this$0 = $receiver;
                                super(1);
                            }

                            public final void invoke(@NotNull ActionEvent it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                DatabaseParticipantSelectionTab.access$createNewDataSource(this.this$0);
                            }
                        })).align((Align)AlignX.RIGHT.INSTANCE);
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                    final /* synthetic */ DatabaseParticipantSelectionTab this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Row $this$row) {
                        void $this$invoke_u24lambda_u240;
                        JBList<DatabaseInDatasource> jBList;
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        JBList<DatabaseInDatasource> jBList2 = jBList = DatabaseParticipantSelectionTab.access$getList$p(this.this$0).getComponent();
                        Row row = $this$row;
                        boolean bl = false;
                        $this$invoke_u24lambda_u240.setFixedCellWidth(40);
                        row.scrollCell((JComponent)jBList).resizableColumn().align(Align.FILL);
                    }
                }), (int)1, null).resizableRow();
            }
        }));
    }

    @Override
    @Nullable
    public RdSetSchemaCompareParticipantRequest getSelectedParticipant() {
        DatabaseInDatasource databaseInDatasource = this.list.getSelected();
        if (databaseInDatasource == null) {
            return null;
        }
        DatabaseInDatasource databaseInDatasource2 = databaseInDatasource;
        RdConnectionString rdConnectionString = LocalDataSourceToConnectionStringMapper.Companion.createConnectionString(databaseInDatasource2.getDataSource(), databaseInDatasource2.getDatabase());
        if (rdConnectionString == null) {
            return null;
        }
        RdConnectionString connectionString = rdConnectionString;
        String string = databaseInDatasource2.getDatabase().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return (RdSetSchemaCompareParticipantRequest)new RdSetSchemaCompareParticipantForDatabaseRequest(connectionString, string);
    }

    @Override
    @NotNull
    public JComponent getPreferableFocusComponent() {
        return (JComponent)this.list.getComponent();
    }

    private final void createNewDataSource() {
        Collection<PotentialConnectionString> connectionStrings = ConnectionStringsProvider.Companion.getInstance(this.getProject()).getConnectionStrings();
        DatabaseConnectionDialog.Builder $this$createNewDataSource_u24lambda_u240 = new DatabaseConnectionDialog.Builder(this.getProject());
        boolean bl = false;
        Dbms[] dbmsArray = new Dbms[2];
        Intrinsics.checkNotNullExpressionValue((Object)Dbms.MSSQL, (String)"MSSQL");
        Intrinsics.checkNotNullExpressionValue((Object)Dbms.MSSQL_LOCALDB, (String)"MSSQL_LOCALDB");
        $this$createNewDataSource_u24lambda_u240.filterByDbms(dbmsArray);
        $this$createNewDataSource_u24lambda_u240.useConnectionStrings(connectionStrings);
        $this$createNewDataSource_u24lambda_u240.useConnectionType(!connectionStrings.isEmpty() ? ConnectionType.Url : ConnectionType.Manual);
        Dbms dbms = Dbms.MSSQL;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"MSSQL");
        $this$createNewDataSource_u24lambda_u240.selectDefaultDriverFor(dbms);
        DatabaseConnectionDialog dialog = $this$createNewDataSource_u24lambda_u240.build();
        dialog.show();
    }

    public static final /* synthetic */ void access$createNewDataSource(DatabaseParticipantSelectionTab $this) {
        $this.createNewDataSource();
    }

    public static final /* synthetic */ ListWithDatabases access$getList$p(DatabaseParticipantSelectionTab $this) {
        return $this.list;
    }
}

