/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.jetbrains.rd.platform.util.ComponentsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rdclient.protocol.IPermittedModalities;
import com.jetbrains.rdclient.protocol.PermittedModalitiesImpl;
import com.jetbrains.rider.model.RdSetSchemaCompareParticipantRequest;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.ParticipantSelectionTab;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.dacpac.DacpacParticipantSelectionTab;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.database.DatabaseParticipantSelectionTab;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.project.ProjectParticipantSelectionTab;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0014J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u001c\u0010\u0016\u001a\u00020\u00112\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/participants/ParticipantSelectionDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "Lcom/intellij/ui/tabs/TabsListener;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "currentTab", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/participants/tabs/ParticipantSelectionTab;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "lifetimeDefinition", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "tabs", "", "createCenterPanel", "Ljavax/swing/JComponent;", "dispose", "", "getInitialSize", "Ljava/awt/Dimension;", "getSelectedParticipant", "Lcom/jetbrains/rider/model/RdSetSchemaCompareParticipantRequest;", "selectionChanged", "oldSelection", "Lcom/intellij/ui/tabs/TabInfo;", "newSelection", "intellij.rider.plugins.appender"})
public final class ParticipantSelectionDialog
extends DialogWrapper
implements TabsListener {
    @NotNull
    private final Project project;
    @NotNull
    private final LifetimeDefinition lifetimeDefinition;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final List<ParticipantSelectionTab> tabs;
    @NotNull
    private ParticipantSelectionTab currentTab;

    public ParticipantSelectionDialog(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.lifetimeDefinition = ComponentsKt.getLifetime((UserDataHolder)((UserDataHolder)this.project)).createNested();
        this.lifetime = this.lifetimeDefinition.getLifetime();
        Object[] objectArray = new ParticipantSelectionTab[]{new ProjectParticipantSelectionTab(this.project), new DatabaseParticipantSelectionTab(this.lifetime, this.project), new DacpacParticipantSelectionTab(this.lifetime, this.project)};
        this.tabs = CollectionsKt.listOf((Object[])objectArray);
        this.currentTab = this.tabs.get(0);
        PermittedModalitiesImpl permittedModalitiesImpl = IPermittedModalities.Companion.getInstance$default((IPermittedModalities.Companion)IPermittedModalities.Companion, null, (int)1, null);
        Window window = this.getWindow();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindow(...)");
        Component component2 = window;
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"getDisposable(...)");
        permittedModalitiesImpl.allowPumpProtocolForComponent(component2, disposable);
        this.setTitle(RiderDatabaseBundle.message("schemaCompare.participantSelection.dialog.title", new Object[0]));
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBTabsImpl tabsHolder = new JBTabsImpl(this.project);
        tabsHolder.getComponent().setOpaque(true);
        for (ParticipantSelectionTab tab : this.tabs) {
            TabInfo tabInfo = new TabInfo(tab.getComponent());
            tabInfo.setText(tab.getName());
            tabInfo.setPreferredFocusableComponent(tab.getPreferableFocusComponent());
            tabInfo.setObject((Object)tab);
            tabsHolder.addTab(tabInfo);
        }
        tabsHolder.addListener((TabsListener)this);
        return tabsHolder.getComponent();
    }

    @NotNull
    public Dimension getInitialSize() {
        JBDimension jBDimension = JBUI.size((int)500, (int)500);
        Intrinsics.checkNotNullExpressionValue((Object)jBDimension, (String)"size(...)");
        return (Dimension)jBDimension;
    }

    public void selectionChanged(@Nullable TabInfo oldSelection, @Nullable TabInfo newSelection) {
        if (newSelection != null) {
            Object object = newSelection.getObject();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.participants.tabs.ParticipantSelectionTab");
            this.currentTab = (ParticipantSelectionTab)object;
        }
    }

    protected void dispose() {
        LifetimeDefinition.terminate$default((LifetimeDefinition)this.lifetimeDefinition, (boolean)false, (int)1, null);
        super.dispose();
    }

    @Nullable
    public final RdSetSchemaCompareParticipantRequest getSelectedParticipant() {
        return this.currentTab.getSelectedParticipant();
    }
}

