/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.options;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.components.JBPanelWithEmptyText;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.scale.JBUIScale;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.IOptPropertyView;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rider.model.RdSchemaCompareOption;
import com.jetbrains.rider.model.RdSchemaCompareOptions;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.SchemaCompareDataModel;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.options.nodes.GeneralOptionNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.options.nodes.GroupingOptionsNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.options.nodes.ObjectTypeOptionNode;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.options.trees.SchemaCompareOptionsTree;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui.options.trees.renderers.SchemaCompareOptionsTreeCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.tree.MutableTreeNode;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0015\u001a\u00020\tH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0014J\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001b\u001a\u00020\tH\u0002J\b\u0010\u001c\u001a\u00020\tH\u0002J\u0010\u0010\u001d\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\b\u0010\u001e\u001a\u00020\tH\u0002J\b\u0010\u001f\u001a\u00020\u0011H\u0014J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\tH\u0002R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/options/CompareOptionsDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "session", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/SchemaCompareDataModel;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/SchemaCompareDataModel;)V", "map", "", "Lcom/intellij/ui/CheckedTreeNode;", "Lcom/jetbrains/rd/util/reactive/IOptProperty;", "", "options", "Lcom/jetbrains/rider/model/RdSchemaCompareOptions;", "pendingUpdates", "", "addGeneralTab", "", "tabbedPane", "Lcom/intellij/ui/components/JBTabbedPane;", "addObjectTypesTab", "createApplicationScopedOptions", "createCenterPanel", "Ljavax/swing/JComponent;", "createGeneralNode", "option", "Lcom/jetbrains/rider/model/RdSchemaCompareOption;", "createGeneralOptions", "createNonApplicationScopedOptions", "createObjectTypeNode", "createObjectTypeOptions", "doOKAction", "markForUpdate", "node", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nCompareOptionsDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompareOptionsDialog.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/options/CompareOptionsDialog\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1549#2:146\n1620#2,3:147\n*S KotlinDebug\n*F\n+ 1 CompareOptionsDialog.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/options/CompareOptionsDialog\n*L\n137#1:146\n137#1:147,3\n*E\n"})
public final class CompareOptionsDialog
extends DialogWrapper {
    @NotNull
    private final SchemaCompareDataModel session;
    @NotNull
    private final Map<CheckedTreeNode, IOptProperty<Boolean>> map;
    @NotNull
    private final Set<CheckedTreeNode> pendingUpdates;
    @NotNull
    private final RdSchemaCompareOptions options;

    public CompareOptionsDialog(@NotNull Project project, @NotNull SchemaCompareDataModel session) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(project);
        this.session = session;
        this.map = new LinkedHashMap();
        this.pendingUpdates = new LinkedHashSet();
        this.options = this.session.getOptions();
        this.setResizable(true);
        this.setTitle(RiderDatabaseBundle.message("schemaCompare.dialog.options.title", new Object[0]));
        this.init();
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JBTabbedPane tabbedPane = new JBTabbedPane(1);
        tabbedPane.setTabComponentInsets(null);
        this.addGeneralTab(tabbedPane);
        this.addObjectTypesTab(tabbedPane);
        JBPanelWithEmptyText panel2 = new JBPanelWithEmptyText((LayoutManager)new BorderLayout());
        panel2.add((Component)tabbedPane, (Object)"Center");
        panel2.setPreferredSize(new Dimension(JBUIScale.scale((int)400), JBUIScale.scale((int)500)));
        return (JComponent)panel2;
    }

    private final void addGeneralTab(JBTabbedPane tabbedPane) {
        SchemaCompareOptionsTree generalOptionsTree2 = new SchemaCompareOptionsTree((Function1<? super CheckedTreeNode, Unit>)((Function1)new Function1<CheckedTreeNode, Unit>((Object)this){

            public final void invoke(@NotNull CheckedTreeNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                CompareOptionsDialog.access$markForUpdate((CompareOptionsDialog)((Object)this.receiver), p0);
            }
        }), SchemaCompareOptionsTreeCellRenderer.INSTANCE, this.createGeneralOptions());
        generalOptionsTree2.setRootVisible(true);
        tabbedPane.add(RiderDatabaseBundle.message("schemaCompare.dialog.options.tabs.general.name", new Object[0]), (Component)new JBScrollPane((Component)((Object)generalOptionsTree2)));
    }

    private final void addObjectTypesTab(JBTabbedPane tabbedPane) {
        SchemaCompareOptionsTree objectTypeOptionsTree2 = new SchemaCompareOptionsTree((Function1<? super CheckedTreeNode, Unit>)((Function1)new Function1<CheckedTreeNode, Unit>((Object)this){

            public final void invoke(@NotNull CheckedTreeNode p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                CompareOptionsDialog.access$markForUpdate((CompareOptionsDialog)((Object)this.receiver), p0);
            }
        }), SchemaCompareOptionsTreeCellRenderer.INSTANCE, this.createObjectTypeOptions());
        tabbedPane.add(RiderDatabaseBundle.message("schemaCompare.dialog.options.tabs.objectTypes.name", new Object[0]), (Component)new JBScrollPane((Component)((Object)objectTypeOptionsTree2)));
    }

    private final CheckedTreeNode createGeneralOptions() {
        GroupingOptionsNode root = new GroupingOptionsNode(RiderDatabaseBundle.message("schemaCompare.dialog.options.groups.general", new Object[0]));
        for (RdSchemaCompareOption generalOption : this.options.getGeneralOptions()) {
            root.add((MutableTreeNode)this.createGeneralNode(generalOption));
        }
        return root;
    }

    private final CheckedTreeNode createObjectTypeOptions() {
        GroupingOptionsNode root = new GroupingOptionsNode("Root");
        root.add((MutableTreeNode)this.createApplicationScopedOptions());
        root.add((MutableTreeNode)this.createNonApplicationScopedOptions());
        return root;
    }

    private final CheckedTreeNode createApplicationScopedOptions() {
        GroupingOptionsNode root = new GroupingOptionsNode(RiderDatabaseBundle.message("schemaCompare.dialog.options.groups.applicationScoped", new Object[0]));
        for (RdSchemaCompareOption objectTypeOption : this.options.getApplicationScopedOptions()) {
            root.add((MutableTreeNode)this.createObjectTypeNode(objectTypeOption));
        }
        return root;
    }

    private final CheckedTreeNode createNonApplicationScopedOptions() {
        GroupingOptionsNode root = new GroupingOptionsNode(RiderDatabaseBundle.message("schemaCompare.dialog.options.groups.nonApplicationScoped", new Object[0]));
        for (RdSchemaCompareOption objectTypeOption : this.options.getNonApplicationScopedOptions()) {
            root.add((MutableTreeNode)this.createObjectTypeNode(objectTypeOption));
        }
        return root;
    }

    private final CheckedTreeNode createGeneralNode(RdSchemaCompareOption option) {
        GeneralOptionNode node = new GeneralOptionNode(option);
        node.setChecked((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)option.getValue())));
        this.map.put(node, (IOptProperty<Boolean>)option.getValue());
        return node;
    }

    private final CheckedTreeNode createObjectTypeNode(RdSchemaCompareOption option) {
        ObjectTypeOptionNode node = new ObjectTypeOptionNode(option);
        node.setChecked((Boolean)InterfacesKt.getValueOrThrow((IOptPropertyView)((IOptPropertyView)option.getValue())));
        this.map.put(node, (IOptProperty<Boolean>)option.getValue());
        return node;
    }

    private final void markForUpdate(CheckedTreeNode node) {
        if (node.getChildCount() > 0) {
            return;
        }
        if (this.pendingUpdates.contains(node)) {
            this.pendingUpdates.remove(node);
        } else {
            this.pendingUpdates.add(node);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void doOKAction() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.pendingUpdates;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CheckedTreeNode checkedTreeNode = (CheckedTreeNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IOptProperty<Boolean> iOptProperty = this.map.get(it);
            Intrinsics.checkNotNull(iOptProperty);
            collection.add(TuplesKt.to(iOptProperty, (Object)it.isChecked()));
        }
        List pairs = (List)destination$iv$iv;
        this.session.changeOptions(pairs);
        super.doOKAction();
    }

    public static final /* synthetic */ void access$markForUpdate(CompareOptionsDialog $this, CheckedTreeNode node) {
        $this.markForUpdate(node);
    }
}

