/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.ui.LoadingDecorator;
import com.intellij.ui.ColorUtil;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.ISource;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.SchemaCompareDataModel;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.notifications.ModelNotifications;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.notifications.models.InclusionChangeStarted;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.notifications.models.SchemaCompareOperationResult;
import com.jetbrains.rider.plugins.appender.database.sqlproj.utils.ReactiveExtKt;
import java.awt.Color;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/ui/SchemaCompareLoadingDecorator;", "Lcom/intellij/openapi/ui/LoadingDecorator;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/SchemaCompareDataModel;", "content", "Ljavax/swing/JComponent;", "parent", "Lcom/intellij/openapi/Disposable;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/SchemaCompareDataModel;Ljavax/swing/JComponent;Lcom/intellij/openapi/Disposable;)V", "makeTransparent", "Ljava/awt/Color;", "originalColor", "startLoading", "", "startLoadingTransparent", "intellij.rider.plugins.appender"})
public final class SchemaCompareLoadingDecorator
extends LoadingDecorator {
    public SchemaCompareLoadingDecorator(@NotNull Lifetime lifetime, @NotNull SchemaCompareDataModel model, @NotNull JComponent content, @NotNull Disposable parent) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        super(content, parent, 0, false, null, 16, null);
        ModelNotifications notifications = model.getNotifications();
        ISource[] iSourceArray = new ISource[]{notifications.getComparisonStarted(), notifications.getScriptGenerationStarted(), notifications.getUpdateTargetStarted()};
        ReactiveExtKt.merge(lifetime, iSourceArray, (Function1)new Function1<Unit, Unit>(){

            public final void invoke(@NotNull Unit it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.startLoading();
            }
        });
        iSourceArray = new ISource[]{notifications.getComparisonCompleted(), notifications.getScriptGenerationCompleted(), notifications.getUpdateTargetCompleted()};
        ReactiveExtKt.merge(lifetime, iSourceArray, (Function1)new Function1<SchemaCompareOperationResult, Unit>(){

            public final void invoke(@NotNull SchemaCompareOperationResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.isLoading()) {
                    this.stopLoading();
                }
            }
        });
        notifications.getInclusionChangeStarted().advise(lifetime, (Function1)new Function1<InclusionChangeStarted, Unit>(){

            public final void invoke(@NotNull InclusionChangeStarted it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (it.getNumberOfNodes() >= 15) {
                    this.startLoadingTransparent();
                }
            }
        });
        notifications.getInclusionChanged().advise(lifetime, (Function1)new Function1<SchemaCompareOperationResult, Unit>(){

            public final void invoke(@NotNull SchemaCompareOperationResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.isLoading()) {
                    this.stopLoading();
                }
            }
        });
    }

    private final void startLoading() {
        if (!this.isLoading()) {
            this.setOverlayBackground(LoadingDecorator.OVERLAY_BACKGROUND);
            this.startLoading(false);
        }
    }

    private final void startLoadingTransparent() {
        if (!this.isLoading()) {
            this.setOverlayBackground(this.makeTransparent(LoadingDecorator.OVERLAY_BACKGROUND));
            this.startLoading(false);
        }
    }

    private final Color makeTransparent(Color originalColor) {
        Color color = ColorUtil.withAlpha((Color)originalColor, (double)0.7);
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"withAlpha(...)");
        return color;
    }
}

