/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.session.services;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.ISignal;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rider.model.RdSchemaCompareDeployScriptGenerationResult;
import com.jetbrains.rider.model.RdSchemaCompareDeployScriptGenerationSession;
import com.jetbrains.rider.model.RdSchemaCompareSession;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.dataModel.notifications.models.ScriptGenerationResult;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.utils.MappersKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u0011H\u0086@\u00a2\u0006\u0002\u0010\u0012R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/session/services/DeployScriptGenerator;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "schemaCompareSession", "Lcom/jetbrains/rider/model/RdSchemaCompareSession;", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rider/model/RdSchemaCompareSession;)V", "canceling", "Lcom/jetbrains/rd/util/reactive/Property;", "", "isDeployScriptGenerationInProgress", "()Lcom/jetbrains/rd/util/reactive/Property;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "cancel", "", "generateScript", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/dataModel/notifications/models/ScriptGenerationResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nDeployScriptGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeployScriptGenerator.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/session/services/DeployScriptGenerator\n+ 2 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,57:1\n13#2:58\n13#3:59\n310#4,11:60\n*S KotlinDebug\n*F\n+ 1 DeployScriptGenerator.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/session/services/DeployScriptGenerator\n*L\n18#1:58\n18#1:59\n22#1:60,11\n*E\n"})
public final class DeployScriptGenerator {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final RdSchemaCompareSession schemaCompareSession;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Property<Boolean> canceling;
    @NotNull
    private final Property<Boolean> isDeployScriptGenerationInProgress;

    public DeployScriptGenerator(@NotNull Lifetime lifetime, @NotNull RdSchemaCompareSession schemaCompareSession) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)schemaCompareSession, (String)"schemaCompareSession");
        this.lifetime = lifetime;
        this.schemaCompareSession = schemaCompareSession;
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DeployScriptGenerator.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
        this.canceling = new Property((Object)false);
        this.isDeployScriptGenerationInProgress = new Property((Object)false);
    }

    @NotNull
    public final Property<Boolean> isDeployScriptGenerationInProgress() {
        return this.isDeployScriptGenerationInProgress;
    }

    @Nullable
    public final Object generateScript(@NotNull Continuation<? super ScriptGenerationResult> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super ScriptGenerationResult> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation continuation = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        if (((Boolean)this.isDeployScriptGenerationInProgress().getValue()).booleanValue()) {
            ((Continuation)continuation).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new Exception("Script Generation is already in progress"))));
        }
        LifetimeDefinition scriptGenerationLifetime = this.lifetime.createNested();
        RdSchemaCompareDeployScriptGenerationSession rdScriptGenerationSession = new RdSchemaCompareDeployScriptGenerationSession();
        rdScriptGenerationSession.getResult().advise((Lifetime)scriptGenerationLifetime, (Function1)new Function1<RdSchemaCompareDeployScriptGenerationResult, Unit>(this, scriptGenerationLifetime, (CancellableContinuation<? super ScriptGenerationResult>)continuation){
            final /* synthetic */ DeployScriptGenerator this$0;
            final /* synthetic */ LifetimeDefinition $scriptGenerationLifetime;
            final /* synthetic */ CancellableContinuation<ScriptGenerationResult> $continuation;
            {
                this.this$0 = $receiver;
                this.$scriptGenerationLifetime = $scriptGenerationLifetime;
                this.$continuation = $continuation;
                super(1);
            }

            public final void invoke(@NotNull RdSchemaCompareDeployScriptGenerationResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DeployScriptGenerator.access$getLogger$p(this.this$0).info("Schema compare deploy script generation finished with result: " + it);
                this.this$0.isDeployScriptGenerationInProgress().setValue((Object)false);
                DeployScriptGenerator.access$getCanceling$p(this.this$0).setValue((Object)false);
                LifetimeDefinition.terminate$default((LifetimeDefinition)this.$scriptGenerationLifetime, (boolean)false, (int)1, null);
                ((Continuation)this.$continuation).resumeWith(Result.constructor-impl((Object)MappersKt.fromRd(it)));
            }
        });
        Function0 cancelAction2 = (Function0)new Function0<Unit>(this, rdScriptGenerationSession){
            final /* synthetic */ DeployScriptGenerator this$0;
            final /* synthetic */ RdSchemaCompareDeployScriptGenerationSession $rdScriptGenerationSession;
            {
                this.this$0 = $receiver;
                this.$rdScriptGenerationSession = $rdScriptGenerationSession;
                super(0);
            }

            public final void invoke() {
                DeployScriptGenerator.access$getLogger$p(this.this$0).info("Trying to cancel schema compare deploy script generation");
                InterfacesKt.fire((ISignal)this.$rdScriptGenerationSession.getCancel());
            }
        };
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)this.canceling), (Lifetime)((Lifetime)scriptGenerationLifetime), (Function1)((Function1)new Function1<Lifetime, Unit>((Function0<Unit>)cancelAction2){
            final /* synthetic */ Function0<Unit> $cancelAction;
            {
                this.$cancelAction = $cancelAction;
                super(1);
            }

            public final void invoke(@NotNull Lifetime it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$cancelAction.invoke();
            }
        }));
        this.logger.info("Deploy script generation started");
        this.schemaCompareSession.getDeployScriptGenerationSession().set((Object)rdScriptGenerationSession);
        this.isDeployScriptGenerationInProgress().set((Object)Boxing.boxBoolean((boolean)true));
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }

    public final void cancel() {
        if (((Boolean)this.isDeployScriptGenerationInProgress.getValue()).booleanValue() && !((Boolean)this.canceling.getValue()).booleanValue()) {
            this.canceling.set((Object)true);
        }
    }
}

