/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.participants;

import com.google.common.base.Objects;
import com.intellij.credentialStore.OneTimeString;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.DataSourceSslConfiguration;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.LocalDataSourceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.rider.model.RdAuthentication;
import com.jetbrains.rider.model.RdIntegratedSecurityAuthentication;
import com.jetbrains.rider.model.RdNoAuthentication;
import com.jetbrains.rider.model.RdParsedConnectionString;
import com.jetbrains.rider.model.RdSqlPasswordAuthentication;
import com.jetbrains.rider.plugins.appender.database.RiderDatabaseBundle;
import com.jetbrains.rider.plugins.appender.database.driver.ExtensionsKt;
import com.jetbrains.rider.plugins.appender.database.sqlproj.schemaCompare.participants.SchemaCompareParticipantBase;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0010\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001c\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0017H\u0002J<\u0010\u0019\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u001a\"\u0004\b\u0001\u0010\u001b2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u0002H\u001a\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0002J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\n2\u0006\u0010 \u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010$\u001a\u00020%2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010&\u001a\u00020'H\u0002J\u0018\u0010(\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002J\u0018\u0010)\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/participants/SchemaCompareParticipantForDatabase;", "Lcom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/participants/SchemaCompareParticipantBase;", "project", "Lcom/intellij/openapi/project/Project;", "parsedConnectionString", "Lcom/jetbrains/rider/model/RdParsedConnectionString;", "name", "", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/rider/model/RdParsedConnectionString;Ljava/lang/String;)V", "dataSource", "Lcom/intellij/database/dataSource/LocalDataSource;", "getDataSource", "()Lcom/intellij/database/dataSource/LocalDataSource;", "databaseName", "getDatabaseName", "()Ljava/lang/String;", "areDataSourcesConfigEqual", "", "first", "second", "createLocalDataSource", "driversEqual", "a", "Lcom/intellij/database/dataSource/DatabaseDriver;", "b", "equals", "K", "V", "firstMap", "", "secondMap", "findExistingDataSource", "newDataSource", "getIcon", "Ljavax/swing/Icon;", "getOrCreateDataSource", "setAuthProviderAndCredentials", "", "authentication", "Lcom/jetbrains/rider/model/RdAuthentication;", "sshConfigEqual", "sslConfigEqual", "intellij.rider.plugins.appender"})
@SourceDebugExtension(value={"SMAP\nSchemaCompareParticipantForDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchemaCompareParticipantForDatabase.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/participants/SchemaCompareParticipantForDatabase\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,144:1\n288#2,2:145\n*S KotlinDebug\n*F\n+ 1 SchemaCompareParticipantForDatabase.kt\ncom/jetbrains/rider/plugins/appender/database/sqlproj/schemaCompare/participants/SchemaCompareParticipantForDatabase\n*L\n37#1:145,2\n*E\n"})
public final class SchemaCompareParticipantForDatabase
extends SchemaCompareParticipantBase {
    @Nullable
    private final String databaseName;
    @NotNull
    private final LocalDataSource dataSource;

    public SchemaCompareParticipantForDatabase(@NotNull Project project, @NotNull RdParsedConnectionString parsedConnectionString, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parsedConnectionString, (String)"parsedConnectionString");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name);
        this.databaseName = parsedConnectionString.getDatabase();
        this.dataSource = this.getOrCreateDataSource(parsedConnectionString, project);
    }

    @Nullable
    public final String getDatabaseName() {
        return this.databaseName;
    }

    @NotNull
    public final LocalDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = this.dataSource.getDbms().getIcon();
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIcon(...)");
        return icon;
    }

    private final LocalDataSource getOrCreateDataSource(RdParsedConnectionString parsedConnectionString, Project project) {
        LocalDataSource newDataSource = this.createLocalDataSource(parsedConnectionString);
        LocalDataSource localDataSource = this.findExistingDataSource(newDataSource, project);
        if (localDataSource == null) {
            localDataSource = newDataSource;
        }
        return localDataSource;
    }

    private final LocalDataSource findExistingDataSource(LocalDataSource newDataSource, Project project) {
        Object v2;
        block5: {
            List list2 = LocalDataSourceManager.getInstance((Project)project).getDataSources();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getDataSources(...)");
            Iterable $this$firstOrNull$iv = list2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                LocalDataSource it = (LocalDataSource)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                if (!this.areDataSourcesConfigEqual(newDataSource, it)) {
                    bl = false;
                } else if (!Intrinsics.areEqual((Object)DatabaseAuthProvider.Companion.get((DatabaseConnectionPoint)newDataSource), (Object)DatabaseAuthProvider.Companion.get((DatabaseConnectionPoint)it))) {
                    bl = false;
                } else {
                    Object existingDataSourceCredentials;
                    DatabaseCredentials credentials2 = DatabaseCredentials.Companion.getInstance();
                    Object newDataSourceCredentials = DatabaseAuthProvider.Companion.get((DatabaseConnectionPoint)newDataSource).loadAuthConfig((DatabaseConnectionPoint)newDataSource, credentials2, false);
                    bl = Objects.equal((Object)newDataSourceCredentials, (Object)(existingDataSourceCredentials = DatabaseAuthProvider.Companion.get((DatabaseConnectionPoint)it).loadAuthConfig((DatabaseConnectionPoint)it, credentials2, false)));
                }
                if (!bl) continue;
                v2 = element$iv;
                break block5;
            }
            v2 = null;
        }
        return v2;
    }

    private final LocalDataSource createLocalDataSource(RdParsedConnectionString parsedConnectionString) {
        DatabaseDriverManager databaseDriverManager = DatabaseDriverManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)databaseDriverManager, (String)"getInstance(...)");
        DatabaseDriver jbDriver = ExtensionsKt.getJbDriverForMsSql(databaseDriverManager);
        LocalDataSource localDataSource = LocalDataSource.fromDriver((DatabaseDriver)jbDriver, (String)parsedConnectionString.getConnectionString(), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"fromDriver(...)");
        LocalDataSource dataSource = localDataSource;
        dataSource.setName(RiderDatabaseBundle.message("schemaCompare.dataSource.name", new Object[0]) + " [" + parsedConnectionString.getServer() + "]");
        this.setAuthProviderAndCredentials(dataSource, parsedConnectionString.getAuthentication());
        dataSource.setAutoSynchronize(true);
        dataSource.setConfiguredByUrl(true);
        return dataSource;
    }

    private final void setAuthProviderAndCredentials(LocalDataSource dataSource, RdAuthentication authentication) {
        RdAuthentication rdAuthentication = authentication;
        if (rdAuthentication instanceof RdNoAuthentication) {
            dataSource.setAuthProviderId("no-auth");
        } else if (rdAuthentication instanceof RdIntegratedSecurityAuthentication) {
            dataSource.setAuthProviderId("ms-sso");
        } else if (rdAuthentication instanceof RdSqlPasswordAuthentication) {
            dataSource.setAuthProviderId("user-pass");
            dataSource.setUsername(((RdSqlPasswordAuthentication)authentication).getUser());
            DatabaseCredentials.Companion.getInstance().storePassword((DatabaseConnectionConfig)dataSource, new OneTimeString(((RdSqlPasswordAuthentication)authentication).getPassword()));
        }
    }

    private final boolean areDataSourcesConfigEqual(LocalDataSource first, LocalDataSource second) {
        if (first.isConfiguredByUrl() != second.isConfiguredByUrl()) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)StringUtil.nullize((String)first.getUrl()), (CharSequence)StringUtil.nullize((String)second.getUrl()))) {
            return false;
        }
        if (!this.driversEqual(first.getDatabaseDriver(), second.getDatabaseDriver())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)first.getDriverClass(), (CharSequence)second.getDriverClass())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)first.getAuthProviderId(), (Object)second.getAuthProviderId())) {
            return false;
        }
        Map map2 = LocalDataSource.getAdditionalPropertiesMap((LocalDataSource)first);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getAdditionalPropertiesMap(...)");
        Map map3 = LocalDataSource.getAdditionalPropertiesMap((LocalDataSource)second);
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"getAdditionalPropertiesMap(...)");
        if (!this.equals(map2, map3)) {
            return false;
        }
        if (!this.sshConfigEqual(first, second)) {
            return false;
        }
        if (!this.sslConfigEqual(first, second)) {
            return false;
        }
        if (first.isImported() != second.isImported()) {
            return false;
        }
        if (first.getPasswordStorage() != second.getPasswordStorage()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)first.getUsername(), (Object)second.getUsername())) {
            return false;
        }
        if (first.getSchemaControl() != second.getSchemaControl()) {
            return false;
        }
        if (first.isReadOnly() != second.isReadOnly()) {
            return false;
        }
        if (first.useJdbcIntrospector() != second.useJdbcIntrospector()) {
            return false;
        }
        return first.getIntrospectionLevel() == second.getIntrospectionLevel();
    }

    private final boolean sshConfigEqual(LocalDataSource first, LocalDataSource second) {
        DataSourceSshTunnelConfiguration firstConfig = first.getSshConfiguration();
        DataSourceSshTunnelConfiguration secondConfig = second.getSshConfiguration();
        if (firstConfig != null && secondConfig != null) {
            return firstConfig.equalConfiguration(secondConfig);
        }
        return firstConfig == null && secondConfig == null;
    }

    private final boolean sslConfigEqual(LocalDataSource first, LocalDataSource second) {
        DataSourceSslConfiguration firstConfig = first.getSslCfg();
        DataSourceSslConfiguration secondConfig = second.getSslCfg();
        if (firstConfig != null && secondConfig != null) {
            return firstConfig.equalConfiguration(secondConfig);
        }
        return firstConfig == null && secondConfig == null;
    }

    private final boolean driversEqual(DatabaseDriver a, DatabaseDriver b) {
        return a == null || b == null ? a == b : Intrinsics.areEqual((Object)a.getId(), (Object)b.getId());
    }

    private final <K, V> boolean equals(Map<K, ? extends V> firstMap, Map<K, ? extends V> secondMap) {
        if (firstMap.size() != secondMap.size()) {
            return false;
        }
        for (K key : firstMap.keySet()) {
            if (!secondMap.containsKey(key)) {
                return false;
            }
            if (Comparing.equal(firstMap.get(key), secondMap.get(key))) continue;
            return false;
        }
        return true;
    }
}

